// src/utils/visit-tracker.js
import { BASE_API } from './config';

export function recordVisit(additionalData = {}) {
    const visitData = {
        site_url: window.location.href,
        page_title: document.title,
        ...additionalData
    };

    const apiUrl = BASE_API;
    console.log('Attempting to record visit to:', `${apiUrl}/api/record-visit`);
    console.log('Visit data:', visitData);

    fetch(`${apiUrl}/api/record-visit`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(visitData),
        credentials: 'include'
    })
    .then(response => {
        console.log('Fetch response status:', response.status);
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        console.log('Visit recorded successfully:', data);
    })
    .catch(error => {
        console.error('Error recording visit:', error);
        console.error('Error details:', {
            message: error.message,
            stack: error.stack,
            name: error.name
        });
    });
}
