import React from 'react';
import './Footer.css';

const Footer = () => (
  <footer className="footer-section bg-black text-white pt-5 pb-3">
    <div className="container">
      <div className="row">
        {/* Get in Touch */}
        <div className="col-md-4 mb-4">
          <h5 className="text-danger mb-3" style={{ letterSpacing: 2 }}>GET IN TOUCH</h5>
          <ul className="list-unstyled mb-3">
            <li><i className="fa fa-map-marker-alt me-2"></i> Hybrid Services</li>
            <li><i className="fa fa-phone me-2"></i> +1 849 267–3627</li>
            <li><i className="fa fa-envelope me-2"></i> school@makeitservices.org</li>
          </ul>
          <div>
            <a href="#" className="footer-social"><i className="fab fa-twitter"></i></a>
            <a href="#" className="footer-social"><i className="fab fa-facebook-f"></i></a>
            <a href="#" className="footer-social"><i className="fab fa-linkedin-in"></i></a>
            <a href="#" className="footer-social"><i className="fab fa-instagram"></i></a>
          </div>
        </div>
        {/* Our Courses */}
        <div className="col-md-4 mb-4">
          <h5 className="text-danger mb-3" style={{ letterSpacing: 2 }}>OUR COURSES</h5>
          <ul className="list-unstyled footer-links">
            <li><i className="fa fa-chevron-right me-2"></i> Web Design</li>
            <li><i className="fa fa-chevron-right me-2"></i> Apps Design</li>
            <li><i className="fa fa-chevron-right me-2"></i> Marketing</li>
            <li><i className="fa fa-chevron-right me-2"></i> Research</li>
            <li><i className="fa fa-chevron-right me-2"></i> SEO</li>
          </ul>
        </div>
        {/* Newsletter */}
        <div className="col-md-4 mb-4">
          <h5 className="text-danger mb-3" style={{ letterSpacing: 2 }}>JOIN OUR NEWSLETTER</h5>
          <p>Subscribe to our newsletter to receive news about projects and features.</p>
          <form className="d-flex">
            <input type="email" className="form-control me-2" placeholder="Your Email Address" />
            <button className="btn btn-danger" type="submit">Subscribe</button>
          </form>
        </div>
      </div>
      <hr className="bg-secondary" />
      <div className="d-flex flex-wrap justify-content-between align-items-center small mt-3">
        <div>
          <span className="text-white-50">© Make-IT Services. All Rights Reserved. Designed by </span>
          <span className="text-danger fw-bold">MAKE-IT</span>
        </div>
        <div>
          <a href="#" className="text-white-50 me-3">Privacy</a>
          <a href="#" className="text-white-50 me-3">Terms</a>
          <a href="#" className="text-white-50 me-3">FAQs</a>
          <a href="#" className="text-white-50">Help</a>
        </div>
      </div>
    </div>
  </footer>
);

export default Footer;
