import React, { useState } from 'react';
import './CourseCardPopup.css';
import CourseCardPopup from './CourseCardPopup';

export default function CourseCard({ course, enrolledCount = 0 }) {
  const [showPopup, setShowPopup] = useState(false);

  // Example: level, duration, type, etc. can be added to course object
  const level = course.level || (course.title && course.title.toLowerCase().includes('beginner') ? 'Beginner' : course.title && course.title.toLowerCase().includes('intermediate') ? 'Intermediate' : null);

  return (
    <>
      <div className="card shadow-sm course-card" style={{ borderRadius: 16, margin: '1rem 0', cursor: 'pointer', minHeight: 340 }} onClick={() => setShowPopup(true)}>
        {course.image_url && (
          <img src={course.image_url} alt={course.title} style={{ width: '100%', height: 210, objectFit: 'cover', borderTopLeftRadius: 16, borderTopRightRadius: 16, display: 'block' }} />
        )}
        <div className="card-body">
          <div style={{ display: 'flex', alignItems: 'center', marginBottom: 8 }}>
            {level && <span className={`badge badge-${level.toLowerCase()}`} style={{ marginRight: 8 }}>{level}</span>}
            <span className="text-muted small">{course.type || 'Course'}</span>
          </div>
          <h5 className="card-title fw-bold mb-2">{course.title}</h5>
          <p className="card-text mb-2" style={{ minHeight: 48 }}>{course.description}</p>
          <div className="d-flex align-items-center" style={{ fontSize: 16, gap: 24, marginBottom: 8 }}>
            {course.hourlengh && (
              <span style={{background:'#e3f2fd', color:'#1976d2', borderRadius:8, padding:'2px 12px', fontWeight:500, display:'inline-block'}}>
                <i className="fa fa-clock-o me-1"></i> {course.hourlengh} Hours
              </span>
            )}
            {course.pricing > 0 ? (
              <span style={{background:'#fff3e0', color:'#fb8c00', borderRadius:8, padding:'2px 12px', fontWeight:500, display:'inline-block'}}>
                <i className="fa fa-tag me-1"></i> ${course.pricing}
              </span>
            ) : (
              <span style={{background:'#e8f5e9', color:'#388e3c', borderRadius:8, padding:'2px 12px', fontWeight:500, display:'inline-block'}}>
                <i className="fa fa-tag me-1"></i> Free
              </span>
            )}
            <span style={{background:'#ffebee', color:'#c62828', borderRadius:8, padding:'2px 12px', fontWeight:500, display:'inline-block'}}>
              <i className="fa fa-users me-1"></i> {enrolledCount} Enrolled
            </span>
          </div>
        </div>
      </div>
      {showPopup && (
        <CourseCardPopup course={course} onClose={() => setShowPopup(false)} />
      )}
    </>
  );
}
