import React, { useState } from 'react';
import { AppBar, Toolbar, Typography, Button, IconButton, Drawer, List, ListItem, ListItemText } from '@mui/material';
import MenuIcon from '@mui/icons-material/Menu';
import { useNavigate } from 'react-router-dom';

export default function Header() {
  const navigate = useNavigate();
  const [drawerOpen, setDrawerOpen] = useState(false);
  const menuItems = [
    { label: 'Home', path: '/' },
    { label: 'About', path: '/about' },
    { label: 'Courses', path: '/courses' },
    { label: 'Teachers', path: '/teachers' },
    { label: 'Portfolio', path: '/portfolio' },
    { label: 'Contact', path: '/contact' },
  ];

  return (
    <AppBar position="static" color="default">
      <Toolbar>
        <Typography variant="h6" sx={{ flexGrow: 1 }}>
          MAKE-IT CLASSICAL COURSES
        </Typography>
        <div className="desktop-menu">
          {menuItems.map(item => (
            <Button color="primary" key={item.label} onClick={() => navigate(item.path)}>{item.label}</Button>
          ))}
          <Button variant="contained" color="error" onClick={() => navigate('/login')}>Log In</Button>
        </div>
        <div className="mobile-menu">
          <IconButton edge="end" color="inherit" aria-label="menu" onClick={() => setDrawerOpen(true)}>
            <MenuIcon />
          </IconButton>
        </div>
        <Drawer anchor="right" open={drawerOpen} onClose={() => setDrawerOpen(false)}>
          <List sx={{ width: 220 }}>
            {menuItems.map(item => (
              <ListItem button key={item.label} onClick={() => { navigate(item.path); setDrawerOpen(false); }}>
                <ListItemText primary={item.label} />
              </ListItem>
            ))}
            <ListItem button onClick={() => { navigate('/login'); setDrawerOpen(false); }}>
              <ListItemText primary="Log In" sx={{ color: 'red' }} />
            </ListItem>
          </List>
        </Drawer>
      </Toolbar>
      <style>{`
        @media (max-width: 900px) {
          .desktop-menu { display: none !important; }
          .mobile-menu { display: block !important; }
        }
        @media (min-width: 901px) {
          .desktop-menu { display: flex !important; gap: 8px; }
          .mobile-menu { display: none !important; }
        }
      `}</style>
    </AppBar>
  );
}
