
import React from 'react';
import Header from './Header';

export default function ClassicalIndex() {
  return (
    <div style={{
      minHeight: '100vh',
      width: '100vw',
      display: 'flex',
      flexDirection: 'column',
      background: 'radial-gradient(circle at 60% 40%, #f7f8fa 60%, #a259e6 100%)',
      padding: 0,
      overflow: 'auto',
    }}>
      <Header />
      <div style={{
        flex: 1,
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'center',
        alignItems: 'center',
        width: '100%',
        padding: '0 16px',
      }}>
        <div style={{
          background: 'rgba(255,255,255,0.95)',
          borderRadius: '32px',
          boxShadow: '0 8px 32px rgba(60,60,120,0.13)',
          padding: '56px 32px 48px 32px',
          maxWidth: '440px',
          width: '100%',
          textAlign: 'center',
          margin: '40px 0',
          position: 'relative',
          zIndex: 2,
        }}>
          <div style={{marginBottom: 32, display: 'flex', justifyContent: 'center'}}>
            <svg width="80" height="80" viewBox="0 0 80 80" fill="none" style={{animation: 'bounce 1.8s infinite'}} xmlns="http://www.w3.org/2000/svg">
              <defs>
                <radialGradient id="circleGradient" cx="50%" cy="50%" r="50%">
                  <stop offset="0%" stopColor="#a259e6" stopOpacity="0.18" />
                  <stop offset="100%" stopColor="#f75c7a" stopOpacity="0.13" />
                </radialGradient>
              </defs>
              <circle cx="40" cy="40" r="40" fill="url(#circleGradient)" />
              <path d="M40 24V48" stroke="#a259e6" strokeWidth="4.5" strokeLinecap="round"/>
              <circle cx="40" cy="60" r="3.5" fill="#f75c7a"/>
            </svg>
          </div>
          <h1 style={{
            fontSize: '2.5rem',
            fontWeight: 800,
            color: '#2d2d4d',
            marginBottom: 16,
            letterSpacing: 1.5,
            fontFamily: 'Segoe UI, Arial, sans-serif',
          }}>Coming Soon</h1>
          <p style={{
            fontSize: '1.18rem',
            color: '#555',
            marginBottom: 32,
            lineHeight: 1.7,
            fontWeight: 500,
          }}>
            <span style={{color:'#a259e6', fontWeight:700}}>The Classical site</span> is currently under construction.<br/>
            We're working hard to bring you a <span style={{color:'#f75c7a', fontWeight:700}}>new and improved experience</span>.<br/>
            <span style={{color:'#2d2d4d'}}>Please check back soon!</span>
          </p>
          <a href="/" style={{
            background: 'linear-gradient(90deg, #a259e6 0%, #f75c7a 100%)',
            color: '#fff',
            padding: '14px 0',
            borderRadius: '10px',
            fontWeight: 700,
            fontSize: '1.08rem',
            textDecoration: 'none',
            boxShadow: '0 2px 8px rgba(162,89,230,0.10)',
            transition: 'background 0.2s',
            display: 'block',
            margin: '0 auto',
            width: '100%',
            maxWidth: '320px',
          }}>Back to Main Site</a>
        </div>
      </div>
      <footer style={{
        color: '#a0a0b2',
        fontSize: '1.05rem',
        padding: '28px 0 12px 0',
        textAlign: 'center',
        width: '100%',
        letterSpacing: 0.5,
        zIndex: 1,
      }}>
        &copy; {new Date().getFullYear()} Classical Site. All rights reserved.
      </footer>
      <style>{`
        @media (max-width: 600px) {
          div[style*='padding: 56px 32px 48px 32px'] {
            padding: 32px 8px 28px 8px !important;
            max-width: 98vw !important;
          }
          h1 {
            font-size: 1.6rem !important;
          }
          p {
            font-size: 1rem !important;
          }
        }
        @keyframes bounce {
          0%, 100% { transform: translateY(0); }
          50% { transform: translateY(-16px); }
        }
      `}</style>
    </div>
  );
}
