import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';

const logoUrl = '/M2.png';
const classicalImg = 'https://images.unsplash.com/photo-1513258496099-48168024aec0?auto=format&fit=crop&w=400&q=80';
const professionalImg = 'https://images.unsplash.com/photo-1515378791036-0648a3ef77b2?auto=format&fit=crop&w=400&q=80';

const pageStyle = {
  minHeight: '100vh',
  background: 'linear-gradient(135deg, #e0c3fc 0%, #8ec5fc 100%)',
  display: 'flex',
  flexDirection: 'column',
  alignItems: 'center',
  justifyContent: 'center',
  padding: '0',
};

const logoStyle = {
  width: '120px',
  height: '120px',
  borderRadius: '50%',
  marginBottom: '24px',
  boxShadow: '0 4px 24px rgba(0,0,0,0.08)',
};

const headingStyle = {
  fontSize: '2.5rem',
  fontWeight: 'bold',
  color: '#a259e6',
  textAlign: 'center',
  marginBottom: '40px',
  marginTop: '0',
  letterSpacing: '0.02em',
};

const cardsContainer = {
  display: 'flex',
  gap: '48px',
  justifyContent: 'center',
  alignItems: 'center',
};

const cardStyle = {
  background: '#fff',
  borderRadius: '20px',
  boxShadow: '0 4px 24px rgba(0,0,0,0.08)',
  width: '320px', // reduced width
  minHeight: '520px', // increased height
  overflow: 'hidden',
  display: 'flex',
  flexDirection: 'column',
  alignItems: 'stretch',
};

const cardImage = {
  width: '100%',
  height: '220px', // taller image for taller card
  objectFit: 'cover',
};

const cardContent = {
  padding: '24px',
  flex: '1',
};

const cardTitle = {
  fontSize: '1.3rem',
  fontWeight: 'bold',
  marginBottom: '8px',
  color: '#333',
};

const cardDesc = {
  fontSize: '1rem',
  color: '#666',
  marginBottom: '16px',
};

const cardButton = {
  background: 'linear-gradient(90deg, #a259e6 0%, #f75c7a 100%)',
  color: '#fff',
  border: 'none',
  borderRadius: '0 0 20px 20px',
  padding: '18px',
  fontWeight: 'bold',
  fontSize: '1.1rem',
  cursor: 'pointer',
  width: '100%',
  letterSpacing: '0.03em',
  transition: 'background 0.2s',
};

function HomePage() {
  const navigate = useNavigate();

  return (
    <>
      <div style={pageStyle}>
        <img src={logoUrl} alt="Logo" style={logoStyle} />
        <h1 style={{...headingStyle, fontFamily: 'Poppins, sans-serif', fontWeight: 700, letterSpacing: '0.04em'}}>Decide on your desired destination.</h1>
        <div style={{...cardsContainer, flexWrap: 'wrap'}}>
          <div style={{
            ...cardStyle,
            border: '2px solid transparent',
            background: 'linear-gradient(#fff, #fff) padding-box, linear-gradient(90deg, #a259e6, #f75c7a) border-box',
            transition: 'transform 0.2s, box-shadow 0.2s',
            boxShadow: '0 8px 32px rgba(162,89,230,0.08)',
            marginBottom: '24px',
            cursor: 'pointer',
          }}
          onMouseOver={e => {e.currentTarget.style.transform='translateY(-6px) scale(1.03)'; e.currentTarget.style.boxShadow='0 12px 32px rgba(162,89,230,0.18)';}}
          onMouseOut={e => {e.currentTarget.style.transform='none'; e.currentTarget.style.boxShadow='0 8px 32px rgba(162,89,230,0.08)';}}
          >
            <img src={classicalImg} alt="Ecole Classique" style={{...cardImage, borderTopLeftRadius: '18px', borderTopRightRadius: '18px'}} />
            <div style={cardContent}>
              <div style={{...cardTitle, fontFamily: 'Poppins, sans-serif', fontWeight: 600}}>Ecole Classique</div>
              <div style={{...cardDesc, fontFamily: 'Inter, sans-serif', color: '#444'}}>Confiez votre éducation à MAKE-IT SCHOOL tout en restant dans le confort de votre domicile, vous ne serez pas déçu.</div>
            </div>
            <button style={{
              ...cardButton,
              background: 'linear-gradient(90deg, #a259e6 0%, #f75c7a 100%)',
              fontFamily: 'Poppins, sans-serif',
              fontWeight: 600,
              fontSize: '1.1rem',
              borderRadius: '0 0 18px 18px',
              boxShadow: '0 2px 8px rgba(162,89,230,0.10)',
              letterSpacing: '0.04em',
              marginTop: 'auto',
              transition: 'background 0.2s, box-shadow 0.2s',
            }}
            onMouseOver={e => {e.currentTarget.style.background='linear-gradient(90deg, #f75c7a 0%, #a259e6 100%)'; e.currentTarget.style.boxShadow='0 4px 16px rgba(247,92,122,0.18)';}}
            onMouseOut={e => {e.currentTarget.style.background='linear-gradient(90deg, #a259e6 0%, #f75c7a 100%)'; e.currentTarget.style.boxShadow='0 2px 8px rgba(162,89,230,0.10)';}}
            onClick={() => navigate('/Classical')}>
              VISITER LE SITE WEB...
            </button>
          </div>
          <div style={{
            ...cardStyle,
            border: '2px solid transparent',
            background: 'linear-gradient(#fff, #fff) padding-box, linear-gradient(90deg, #43cea2, #185a9d) border-box',
            transition: 'transform 0.2s, box-shadow 0.2s',
            boxShadow: '0 8px 32px rgba(67,206,162,0.08)',
            marginBottom: '24px',
            cursor: 'pointer',
          }}
          onMouseOver={e => {e.currentTarget.style.transform='translateY(-6px) scale(1.03)'; e.currentTarget.style.boxShadow='0 12px 32px rgba(67,206,162,0.18)';}}
          onMouseOut={e => {e.currentTarget.style.transform='none'; e.currentTarget.style.boxShadow='0 8px 32px rgba(67,206,162,0.08)';}}
          >
            <img src={professionalImg} alt="Professional School" style={{...cardImage, borderTopLeftRadius: '18px', borderTopRightRadius: '18px'}} />
            <div style={cardContent}>
              <div style={{...cardTitle, fontFamily: 'Poppins, sans-serif', fontWeight: 600}}>Professional School</div>
              <div style={{...cardDesc, fontFamily: 'Inter, sans-serif', color: '#444'}}>Rely on MAKE-IT SCHOOL for your education, allowing you to learn from home and still reap the benefits.</div>
            </div>
            <button style={{
              ...cardButton,
              background: 'linear-gradient(90deg, #43cea2 0%, #185a9d 100%)',
              fontFamily: 'Poppins, sans-serif',
              fontWeight: 600,
              fontSize: '1.1rem',
              borderRadius: '0 0 18px 18px',
              boxShadow: '0 2px 8px rgba(67,206,162,0.10)',
              letterSpacing: '0.04em',
              marginTop: 'auto',
              transition: 'background 0.2s, box-shadow 0.2s',
            }}
            onMouseOver={e => {e.currentTarget.style.background='linear-gradient(90deg, #185a9d 0%, #43cea2 100%)'; e.currentTarget.style.boxShadow='0 4px 16px rgba(24,90,157,0.18)';}}
            onMouseOut={e => {e.currentTarget.style.background='linear-gradient(90deg, #43cea2 0%, #185a9d 100%)'; e.currentTarget.style.boxShadow='0 2px 8px rgba(67,206,162,0.10)';}}
            onClick={() => navigate('/Professional')}>
              NAVIGATE TO THE WEBSITE...
            </button>
          </div>
        </div>
      </div>
      <style>{`
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600&family=Poppins:wght@600;700&display=swap');
        @media (min-width: 901px) {
          div[style*='width: 320px'] {
            width: 420px !important;
            min-height: 520px !important;
            box-shadow: 0 4px 24px rgba(162,89,230,0.10) !important;
            border-radius: 20px !important;
            margin: 0 24px !important;
            animation: none !important;
          }
        }
        @media (max-width: 900px) {
          h1 {
            font-size: 1.5rem !important;
          }
          div[style*='display: flex'][style*='gap: 48px'] {
            flex-direction: column !important;
            gap: 24px !important;
          }
          div[style*='width: 320px'] {
            width: 95vw !important;
            min-width: 0 !important;
            max-width: 98vw !important;
            min-height: 420px !important;
            box-shadow: 0 2px 12px rgba(162,89,230,0.10) !important;
            border-radius: 16px !important;
          }
          img[alt='Logo'] {
            width: 80px !important;
            height: 80px !important;
          }
        }
        @media (max-width: 600px) {
          h1 {
            font-size: 1.1rem !important;
          }
          div[style*='padding: 24px'] {
            padding: 10px !important;
          }
          div[style*='width: 320px'] {
            width: 90vw !important;
            min-width: 0 !important;
            max-width: 99vw !important;
            min-height: 340px !important;
            box-shadow: 0 1px 8px rgba(162,89,230,0.08) !important;
            border-radius: 12px !important;
            animation: cardWidthPlay 2.5s infinite alternate ease-in-out;
          }
          img[alt='Logo'] {
            width: 54px !important;
            height: 54px !important;
          }
          button {
            font-size: 1rem !important;
            padding: 14px !important;
            border-radius: 0 0 12px 12px !important;
          }
          .card-content {
            padding: 10px !important;
          }
        }
        @media (max-width: 600px) {
          div[style*='width: 320px'] {
            animation: cardWidthPlay 2.5s infinite alternate ease-in-out;
          }
        }
        @media (max-width: 420px) {
          div[style*='width: 320px'] {
            width: 96vw !important;
            min-height: 260px !important;
            border-radius: 8px !important;
            animation: cardWidthPlaySmall 2.5s infinite alternate ease-in-out;
          }
          button {
            font-size: 0.95rem !important;
            padding: 10px !important;
            border-radius: 0 0 8px 8px !important;
          }
        }
        @keyframes cardWidthPlay {
          0% { width: 90vw; }
          50% { width: 94vw; }
          100% { width: 99vw; }
        }
        @keyframes cardWidthPlaySmall {
          0% { width: 96vw; }
          50% { width: 99vw; }
          100% { width: 94vw; }
        }
        button {
          transition: background 0.2s, box-shadow 0.2s, font-size 0.2s;
        }
        div[style*='width: 320px'] {
          transition: box-shadow 0.2s, border-radius 0.2s, min-height 0.2s, width 0.2s;
        }
      `}</style>
    </>
  );
}

export default HomePage;
