import React from 'react';

const sidebarStyle = {
  width: '220px',
  background: '#fff',
  boxShadow: '0 2px 12px rgba(0,0,0,0.08)',
  borderRadius: '16px',
  padding: '24px 0',
  position: 'fixed',
  top: 0,
  left: 0,
  height: '100vh',
  display: 'flex',
  flexDirection: 'column',
  gap: '12px',
};

const DashboardSidebar = ({ role, selectedMenu, onSelectMenu }) => (
  <aside style={sidebarStyle}>
    <div style={{fontWeight:'bold', fontSize:'1.3rem', color:'#a259e6', marginBottom:'32px', textAlign:'center'}}>MAKE-IT</div>
      <nav>
        <div style={{padding:'12px 32px', cursor:'pointer', color:selectedMenu==='dashboard'?'#1565c0':'#333', fontWeight:'bold', background:selectedMenu==='dashboard'?'#eaf6ff':'#f7f8fa', borderRadius:'8px'}} onClick={()=>onSelectMenu('dashboard')}>Dashboard</div>
        <div style={{padding:'12px 32px', cursor:'pointer', color:selectedMenu==='courses'?'#1565c0':'#333', background:selectedMenu==='courses'?'#eaf6ff':'#fff', borderRadius:'8px'}} onClick={()=>onSelectMenu('courses')}>Courses</div>
        <div style={{padding:'12px 32px', cursor:'pointer', color:selectedMenu==='users'?'#1565c0':'#333', background:selectedMenu==='users'?'#eaf6ff':'#fff', borderRadius:'8px', fontWeight:selectedMenu==='users'?'bold':'normal'}} onClick={()=>onSelectMenu('users')}>Users</div>
        <div style={{padding:'12px 32px', cursor:'pointer', color:selectedMenu==='access'?'#1565c0':'#333', background:selectedMenu==='access'?'#eaf6ff':'#fff', borderRadius:'8px'}} onClick={()=>onSelectMenu('access')}>Access</div>
        <div style={{padding:'12px 32px', cursor:'pointer', color:selectedMenu==='settings'?'#1565c0':'#333', background:selectedMenu==='settings'?'#eaf6ff':'#fff', borderRadius:'8px'}} onClick={()=>onSelectMenu('settings')}>Settings</div>
        <div style={{padding:'12px 32px', cursor:'pointer', color:selectedMenu==='signature'?'#1565c0':'#1565c0', fontWeight:'bold', background:selectedMenu==='signature'?'#eaf6ff':'#fff', borderRadius:'8px'}} onClick={()=>onSelectMenu('signature')}>Manage Signature Manager</div>
        <div style={{padding:'12px 32px', cursor:'pointer', color:selectedMenu==='tasks'?'#1565c0':'#333', background:selectedMenu==='tasks'?'#eaf6ff':'#fff', borderRadius:'8px', fontWeight:selectedMenu==='tasks'?'bold':'normal'}} onClick={()=>onSelectMenu('tasks')}>Tasks</div>
        <div style={{padding:'12px 32px', cursor:'pointer', color:selectedMenu==='traces'?'#1565c0':'#333', background:selectedMenu==='traces'?'#eaf6ff':'#fff', borderRadius:'8px', fontWeight:selectedMenu==='traces'?'bold':'normal'}} onClick={()=>onSelectMenu('traces')}>Traces</div>
      </nav>
  </aside>
);

export default DashboardSidebar;
