import React, { useEffect, useState } from 'react';
import axios from 'axios';
import './LegalCertificateModal.css'; // You can style as needed

function LegalCertificateModal({ cerf_id, onClose }) {
  const [data, setData] = useState(null);

  useEffect(() => {
    axios.get(`/api/certificates?cerf_id=${cerf_id}`).then(res => setData(res.data));
  }, [cerf_id]);

  if (!data) return <div>Loading...</div>;

  return (
    <div className="certificate-modal-bg">
      <div className="certificate-modal">
        <button className="close-btn" onClick={onClose}>Close</button>
        <div className="certificate-container">
          <div className="watermark">CERTIFIED</div>
          <div className="certificate-header">
            <h1 className="certificate-title">Legal Interpreter Certification</h1>
            <p className="certificate-subtitle">40 Hours Legal Interpreter Program</p>
          </div>
          <div className="certificate-body">
            <div className="main-content">
              <p className="certificate-text">This is to certify that</p>
              <div className="recipient-name">{data.fullname}</div>
              <p className="certificate-text">
                This certificate confirms that the individual has successfully completed the 40-hour Legal Interpreter certification program and is qualified to provide legal interpretation services.
              </p>
              <div className="legal-simple-container">
                <div className="legal-subtitle">Legal Interpretation in English and Arabic</div>
                <div className="legal-verification-text">
                  This certificate verifies passing scores in MAKE-IT Legal Center' written exam and legal interpretation exam (verbal)
                </div>
                <div className="legal-signature-section">
                  <div className="legal-signature-left">
                    <div className="signature-image-container">
                      <img src={data.signature_url || '/Other/ernston_signature_legal.png'} alt="Signature" className="legal-signature-img" />
                    </div>
                    <div className="signature-line-legal"></div>
                    <div className="legal-signatory-info">
                      <div className="signatory-name">Ernston St Pierre</div>
                      <div className="signatory-title">Lead Legal Trainer</div>
                      <div className="signatory-org">MAKE-IT SERVICES TECHNOLOGY legal Center.</div>
                    </div>
                    <div className="signature-dates-container">
                      <div className="signature-date-item">
                        <div className="signature-date-label">Issue Date</div>
                        <div className="signature-date-value">{data.date_validity}</div>
                      </div>
                      <div className="signature-date-item">
                        <div className="signature-date-label">Expiration</div>
                        <div className="signature-date-value">{data.expiration_date}</div>
                      </div>
                    </div>
                  </div>
                  <div className="legal-qr-center">
                    <img src={data.qr_code_url || `/Company/qr_certificate/qr_legal_${cerf_id}.png`} alt="Verification QR Code" className="qr-code-legal" />
                    <div className="qr-text">Scan to Verify</div>
                  </div>
                  <div className="legal-info-right">
                    <div className="legal-info-box">
                      <div className="legal-info-title">Advancing Justice Through Legal Education®</div>
                      <div className="legal-info-desc">
                        is developed and maintained by MAKE-IT LEGAL CENTER, committed to excellence in legal training and aligned with best practices recognized by leading U.S. legal organizations
                      </div>
                      <div className="legal-info-number">Certificate #: {data.cerf_id}</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}

export default LegalCertificateModal;
