import React, { useState, useEffect } from 'react';

function InvoicePage() {
  React.useEffect(() => {
    const style = document.createElement('style');
    style.innerHTML = `
      @media print {
        .no-print { display: none !important; }
      }
    `;
    document.head.appendChild(style);
    return () => { document.head.removeChild(style); };
  }, []);
  const invoiceRef = React.useRef();
  React.useEffect(() => {
    const style = document.createElement('style');
    style.innerHTML = `
      @media print {
        html, body { height: 100%; margin: 0 !important; padding: 0 !important; }
        body * { visibility: hidden !important; }
        .print-invoice, .print-invoice * { visibility: visible !important; }
        .print-invoice {
          position: absolute;
          left: 0;
          top: 0;
          width: 100vw;
          height: 100vh;
          max-height: 1056px;
          background: white;
          z-index: 9999;
          overflow: hidden;
          margin: 0 !important;
          padding: 0 !important;
          page-break-after: avoid;
        }
        @page { size: Letter; margin: 0; }
      }
    `;
    document.head.appendChild(style);
    return () => { document.head.removeChild(style); };
  }, []);
  const [users, setUsers] = useState([]);
  const [criteria, setCriteria] = useState({ userId: '', month: '', year: '' });
  const [invoice, setInvoice] = useState(null);
  const [invoiceNote, setInvoiceNote] = useState('This invoice will be executing within 15 following days');
  // Company info state
  const [company, setCompany] = useState({
    name: 'CASHMINING',
    service: 'Hybrid Services',
    phone: '+1 849 267 3627',
    email: 'payment@cashmining.website',
    website: 'www.cashmining.website',
    logo: '/images/cashmining-logo.png'
  });
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);

  useEffect(() => {
    fetch('/api/users')
      .then(res => res.json())
      .then(data => setUsers(data || []));
  }, []);

  const handleFetchInvoice = async () => {
    setLoading(true);
    setError(null);
    try {
      const user = users.find(u => String(u.Id) === String(criteria.userId));
      const chartRes = await fetch(`/api/interpreter_chart/${criteria.userId}`);
      const chartData = await chartRes.json();
      let monthKey = `${criteria.year}-${String(criteria.month).padStart(2,'0')}`;
      let minutesWorked = chartData.chart && chartData.chart[monthKey] ? chartData.chart[monthKey] : 0;
      setInvoice({
        user,
        month: criteria.month,
        year: criteria.year,
        items: [
          {
            item: 'Interpretation',
            description: 'Service',
            rate:
              user &&
              ((typeof user.rates === 'string' && user.rates.trim() !== '' && !isNaN(Number(user.rates)))
                ? Number(user.rates)
                : (typeof user.rates === 'number' && !isNaN(user.rates))
                  ? user.rates
                  : 0),
            quantity: minutesWorked,
          }
        ]
      });
    } catch (err) {
      setError('Failed to fetch invoice data');
    }
    setLoading(false);
  };

  return (
  <div style={{padding:'32px', maxWidth:'700px', margin:'0 auto'}}>
      <h2>Invoice Generator</h2>
  <div style={{display:'flex', gap:'16px', marginBottom:'18px'}}>
        <select value={criteria.userId} onChange={e=>setCriteria({...criteria, userId: e.target.value})} style={{padding:'8px', borderRadius:'8px', border:'1px solid #ccc'}}>
          <option value="">Select User</option>
          {users.filter(u => String(u.invoice) === '1').map(u => (
            <option key={u.Id} value={u.Id}>{u.name || u.email}</option>
          ))}
        </select>
        <select value={criteria.month} onChange={e=>setCriteria({...criteria, month: e.target.value})} style={{padding:'8px', borderRadius:'8px', border:'1px solid #ccc'}}>
          <option value="">Month</option>
          {[...Array(12)].map((_,i)=>(<option key={i+1} value={i+1}>{new Date(2000,i).toLocaleString('default',{month:'long'})}</option>))}
        </select>
        <select value={criteria.year} onChange={e=>setCriteria({...criteria, year: e.target.value})} style={{padding:'8px', borderRadius:'8px', border:'1px solid #ccc'}}>
          <option value="">Year</option>
          {[2024,2025,2026].map(y=>(<option key={y} value={y}>{y}</option>))}
        </select>
        <button style={{background:'#1565c0', color:'#fff', border:'none', borderRadius:'8px', padding:'8px 18px', fontWeight:'bold', cursor:'pointer'}} onClick={handleFetchInvoice} disabled={loading || !criteria.userId || !criteria.month || !criteria.year}>Fetch</button>
        <button style={{background:'#388e3c', color:'#fff', border:'none', borderRadius:'8px', padding:'8px 18px', fontWeight:'bold', cursor:'pointer'}} onClick={()=>{
          if (invoice?.user?.name) {
            document.title = invoice.user.name;
          }
          window.print();
          document.title = 'Invoice Generator';
        }} disabled={!invoice}>Print</button>
      </div>
      {error && <div style={{color:'#f75c7a', marginBottom:'8px'}}>{error}</div>}
      {invoice && (
  <div ref={invoiceRef} className="print-invoice" style={{background:'#fff', borderRadius:'12px', padding:'0', marginTop:'12px', boxShadow:'0 2px 8px #eee'}}>
          {/* Header */}
          <div style={{background:'#111', color:'#fff', textAlign:'center', fontWeight:'bold', fontSize:'1.5rem', letterSpacing:'6px', padding:'8px 0', borderRadius:'12px 12px 0 0'}}>INVOICE</div>
          <div style={{display:'flex', justifyContent:'space-between', alignItems:'flex-start', padding:'24px', gap:'24px'}}>
            {/* Company Info */}
            <div style={{flex:'1', background:'#f7f8fa', borderRadius:'8px', padding:'16px', minWidth:'220px'}}>
              <input type="text" value={company.name} onChange={e=>setCompany({...company, name: e.target.value})} style={{fontWeight:'bold', fontSize:'1.1rem', width:'100%', marginBottom:'4px', border:'none', background:'transparent'}} />
              <input type="text" value={company.service} onChange={e=>setCompany({...company, service: e.target.value})} style={{width:'100%', marginBottom:'4px', border:'none', background:'transparent'}} />
              <input type="text" value={company.phone} onChange={e=>setCompany({...company, phone: e.target.value})} style={{width:'100%', marginBottom:'4px', border:'none', background:'transparent'}} />
              <input type="email" value={company.email} onChange={e=>setCompany({...company, email: e.target.value})} style={{width:'100%', marginBottom:'4px', border:'none', background:'transparent', color:'#1565c0'}} />
              <input type="text" value={company.website} onChange={e=>setCompany({...company, website: e.target.value})} style={{width:'100%', border:'none', background:'transparent', color:'#1565c0'}} />
            </div>
            {/* Logo */}
            <div style={{flex:'0 0 120px', textAlign:'center'}}>
              <input type="text" className="no-print" value={company.logo} onChange={e=>setCompany({...company, logo: e.target.value})} style={{width:'100%', marginBottom:'4px', border:'none', background:'transparent', fontSize:'0.8rem'}} />
              <img src={company.logo} alt="Company Logo" style={{maxWidth:'100px', maxHeight:'100px'}} />
              <div className="no-print" style={{fontSize:'0.8rem', color:'#888', marginTop:'4px'}}>{company.logo}</div>
            </div>
          </div>
          <div style={{display:'flex', justifyContent:'space-between', alignItems:'flex-start', padding:'0 24px 24px 24px', gap:'24px'}}>
            {/* Recipient Info */}
            <div style={{flex:'1', background:'#f7f8fa', borderRadius:'8px', padding:'16px', minWidth:'220px'}}>
              <div style={{fontWeight:'bold', color:'#1565c0'}}>To : {invoice.user?.name?.toUpperCase() || invoice.user?.email}</div>
             
              <div style={{fontWeight:'bold'}}>Email : <span style={{color:'#1565c0'}}>{invoice.user?.email}</span></div>
              {invoice.user?.bank_name && (
                <div style={{fontWeight:'bold'}}>Bank Name : <span style={{color:'#1565c0'}}>{invoice.user.bank_name}</span></div>
              )}
              {invoice.user?.account_number && (
                <div style={{fontWeight:'bold'}}>Account Number : <span style={{color:'#1565c0'}}>{invoice.user.account_number}</span></div>
              )}
              {invoice.user?.paid_devise && (
                <div style={{fontWeight:'bold'}}>Currency : <span style={{color:'#1565c0'}}>{invoice.user.paid_devise}</span></div>
                            )}
            </div>
            {/* Invoice Info */}
            <div style={{flex:'1', background:'#f7f8fa', borderRadius:'8px', padding:'16px', minWidth:'220px'}}>
              <div><b>Invoice # :</b> <span style={{color:'#1565c0'}}>{Math.floor(Math.random()*1000000000)}</span></div>
              <div><b>Date :</b> <span style={{color:'#1565c0'}}>{new Date().toISOString().slice(0,10)}</span></div>
              <div style={{fontWeight:'bold'}}>Month : <span style={{color:'#1565c0'}}>{new Date(2000,invoice.month-1).toLocaleString('default',{month:'long'})} {invoice.year}</span></div>
              <div><b>Amount Due :</b> <span style={{color:'#1565c0', fontWeight:'bold'}}>$ {invoice.items.reduce((sum, item) => sum + item.rate * item.quantity, 0).toFixed(2)}</span></div>
            </div>
          </div>
          {/* Invoice Table */}
          <div style={{padding:'0 24px'}}>
            <table style={{width:'100%', borderCollapse:'collapse', marginBottom:'18px'}}>
              <thead>
                <tr style={{background:'#f7f8fa'}}>
                  <th style={{border:'1px solid #ccc', padding:'8px'}}>Item</th>
                  <th style={{border:'1px solid #ccc', padding:'8px'}}>Description</th>
                  <th style={{border:'1px solid #ccc', padding:'8px'}}>Rate</th>
                  <th style={{border:'1px solid #ccc', padding:'8px'}}>Quantity</th>
                  <th style={{border:'1px solid #ccc', padding:'8px'}}>Total Price</th>
                  <th className="no-print" style={{border:'1px solid #ccc', padding:'8px'}}>Remove</th>
                </tr>
              </thead>
              <tbody>
                {invoice.items.map((item, idx) => (
                  <tr key={idx}>
                    <td style={{border:'1px solid #ccc', padding:'8px'}}>
                      <input type="text" value={item.item} onChange={e => {
                        const items = [...invoice.items];
                        items[idx].item = e.target.value;
                        setInvoice({...invoice, items});
                      }} style={{width:'100%', border:'none', background:'transparent'}} />
                    </td>
                    <td style={{border:'1px solid #ccc', padding:'8px'}}>
                      <input type="text" value={item.description} onChange={e => {
                        const items = [...invoice.items];
                        items[idx].description = e.target.value;
                        setInvoice({...invoice, items});
                      }} style={{width:'100%', border:'none', background:'transparent'}} />
                    </td>
                    <td style={{border:'1px solid #ccc', padding:'8px'}}>
                      <input type="number" value={item.rate} min="0" step="0.01" onChange={e => {
                        const items = [...invoice.items];
                        items[idx].rate = parseFloat(e.target.value);
                        setInvoice({...invoice, items});
                      }} style={{width:'100px', border:'none', background:'transparent'}} />
                    </td>
                    <td style={{border:'1px solid #ccc', padding:'8px'}}>
                      <input type="number" value={item.quantity} min="0" step="1" onChange={e => {
                        const items = [...invoice.items];
                        items[idx].quantity = parseInt(e.target.value);
                        setInvoice({...invoice, items});
                      }} style={{width:'100px', border:'none', background:'transparent'}} />
                    </td>
                    <td style={{border:'1px solid #ccc', padding:'8px'}}>${(item.rate * item.quantity).toFixed(2)}</td>
                    <td style={{border:'1px solid #ccc', padding:'8px', textAlign:'center'}}>
                      {invoice.items.length > 1 && (
                        <button className="no-print" onClick={() => {
                          const items = invoice.items.filter((_, i) => i !== idx);
                          setInvoice({...invoice, items});
                        }} style={{background:'#f75c7a', color:'#fff', border:'none', borderRadius:'50%', width:'24px', height:'24px', fontWeight:'bold', cursor:'pointer'}}>×</button>
                      )}
                    </td>
                  </tr>
                ))}
              </tbody>
            </table>
            <button style={{background:'#1565c0', color:'#fff', border:'none', borderRadius:'50%', width:'32px', height:'32px', fontSize:'1.5rem', fontWeight:'bold', cursor:'pointer', marginBottom:'12px'}} onClick={() => {
              setInvoice({...invoice, items: [...invoice.items, {item:'', description:'', rate:0, quantity:0}]});
            }} className="no-print">+</button>
          </div>
          {/* Totals Section */}
          <div style={{display:'flex', justifyContent:'flex-end', gap:'12px', padding:'0 24px 18px 24px'}}>
            <div style={{minWidth:'120px', background:'#f7f8fa', borderRadius:'6px', padding:'8px', textAlign:'right', fontWeight:'bold', border:'1px solid #eee'}}>Total<br/>${invoice.items.reduce((sum, item) => sum + item.rate * item.quantity, 0).toFixed(2)}</div>
            <div style={{minWidth:'120px', background:'#f7f8fa', borderRadius:'6px', padding:'8px', textAlign:'right', border:'1px solid #eee'}}>Amount Paid<br/>$ 0</div>
            <div style={{minWidth:'120px', background:'#f7f8fa', borderRadius:'6px', padding:'8px', textAlign:'right', fontWeight:'bold', border:'1px solid #eee'}}>Balance Due<br/>${invoice.items.reduce((sum, item) => sum + item.rate * item.quantity, 0).toFixed(2)}</div>
          </div>
          {/* Additional Notes Section */}
          <div style={{margin:'24px 0 0 0', padding:'0 24px'}}>
            <div style={{textAlign:'center', fontWeight:'bold', letterSpacing:'6px', fontSize:'1.1rem', marginBottom:'8px'}}>ADDITIONAL NOTES</div>
            <textarea
              value={invoiceNote}
              onChange={e => setInvoiceNote(e.target.value)}
              style={{width:'100%', minHeight:'40px', fontStyle:'italic', color:'#444', marginBottom:'18px', border:'1px solid #ccc', borderRadius:'6px', padding:'8px', resize:'vertical'}}
            />
          </div>
        </div>
      )}

    </div>
  );
}
export default InvoicePage;
