
import CourseSidebar from './CourseSidebar';

const DashboardSidebar = ({ role, onSelectMenu, selectedMenu }) => {
  return (
    <div style={{width:'240px', background:'#fff', borderRadius:'0 24px 24px 0', boxShadow:'0 2px 12px rgba(0,0,0,0.08)', padding:'32px 0', minHeight:'100vh', position:'fixed', left:0, top:'64px', zIndex:99}}>
      <div style={{margin:'0', fontWeight:'bold', color:'#1976d2', padding:'20px 18px 8px 18px', cursor:'pointer', background:selectedMenu==='dashboard'?'#e3f2fd':'none', borderRadius:'8px', fontSize:'1.15rem', textAlign:'left'}} onClick={()=>onSelectMenu('dashboard')}>Dashboard</div>
      <div style={{margin:'0', fontWeight:'bold', color:'#1976d2', padding:'20px 18px 8px 18px', cursor:'pointer', background:selectedMenu==='courses'?'#e3f2fd':'none', borderRadius:'8px', fontSize:'1.15rem', textAlign:'left'}} onClick={()=>onSelectMenu('courses')}>Courses</div>
      <div style={{margin:'0', fontWeight:'bold', color:'#1565c0', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='myTutorial'?'#e3f2fd':'none', borderRadius:'8px', fontSize:'1.08rem', textAlign:'left'}} onClick={()=>onSelectMenu('myTutorial')}>My Tutorial</div>
      <div style={{margin:'18px 0', fontWeight:'bold', color:'#1976d2', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='mydocument'?'#e3f2fd':'none', borderRadius:'8px'}} onClick={()=>onSelectMenu('mydocument')}>My Document</div>
      <CourseSidebar 
        active={selectedMenu === 'addCourse' || selectedMenu === 'editCourse' || selectedMenu === 'addCourseAccess' || selectedMenu === 'assignCourse' || selectedMenu === 'manageMedia'}
        onSelectMenu={onSelectMenu}
        role={role}
        selectedMenu={selectedMenu}
      />
  <div style={{margin:'18px 0', fontWeight:'bold', color:'#222', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='users'?'#e3f2fd':'none', borderRadius:'8px'}} onClick={()=>onSelectMenu('users')}>Users</div>
  <div style={{margin:'18px 0', fontWeight:'bold', color:'#1976d2', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='userAccess'?'#e3f2fd':'none', borderRadius:'8px'}} onClick={()=>onSelectMenu('userAccess')}>User Access Management</div>
  <div style={{margin:'18px 0', fontWeight:'bold', color:'#1976d2', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='paymentUserMethod'?'#e3f2fd':'none', borderRadius:'8px'}} onClick={()=>onSelectMenu('paymentUserMethod')}>Payment User Method</div>
      <div style={{margin:'18px 0', fontWeight:'bold', color:'#222', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='signature'?'#e3f2fd':'none', borderRadius:'8px'}} onClick={()=>onSelectMenu('signature')}>Manage Signature Manager</div>
      <div style={{margin:'18px 0', fontWeight:'bold', color:'#222', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='tasks'?'#e3f2fd':'none', borderRadius:'8px'}} onClick={()=>onSelectMenu('tasks')}>Tasks</div>
      <div style={{margin:'18px 0', fontWeight:'bold', color:'#222', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='traces'?'#e3f2fd':'none', borderRadius:'8px'}} onClick={()=>onSelectMenu('traces')}>Traces</div>
    </div>
  );
};

export default DashboardSidebar;
