import React, { useState, useEffect } from 'react';
import { BASE_API } from '../../utils/config';

const AddCourse = ({ onCourseAdded }) => {
  const [type, setType] = useState('classical');
  const [title, setTitle] = useState('');
  const [description, setDescription] = useState('');
  const [videoUrl, setVideoUrl] = useState('');
  const [file, setFile] = useState(null);
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState('');
  const [imageId, setImageId] = useState('');
  const [images, setImages] = useState([]);

  useEffect(() => {
    // Fetch images from backend
    fetch(`${BASE_API}/api/images`)
      .then(res => res.json())
      .then(data => setImages(data.images || []));
  }, []);

  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    setError('');
    const formData = new FormData();
    formData.append('type', type);
    formData.append('title', title);
    formData.append('description', description);
    formData.append('video_url', videoUrl);
    if (file) formData.append('file', file);
    try {
      const res = await fetch(`${BASE_API}/api/courses/add`, {
        method: 'POST',
        body: formData
      });
      const data = await res.json();
      if (res.ok) {
        setTitle(''); setDescription(''); setVideoUrl(''); setFile(null);
        if (onCourseAdded) onCourseAdded(data);
      } else {
        setError(data.error || 'Failed to add course');
      }
    } catch (err) {
      setError('Network error');
    }
    setLoading(false);
  };

  return (
    <form onSubmit={handleSubmit} style={{maxWidth:'480px', margin:'32px auto', background:'#fff', borderRadius:'16px', boxShadow:'0 2px 12px rgba(0,0,0,0.08)', padding:'32px'}}>
      <h2 style={{marginBottom:'18px'}}>Add Course</h2>
      <label style={{fontWeight:'bold'}}>Type:</label>
      <select value={type} onChange={e=>setType(e.target.value)} style={{width:'100%', padding:'8px', borderRadius:'6px', border:'1px solid #ccc', marginBottom:'12px'}}>
        <option value="classical">Classical</option>
        <option value="professional">Professional</option>
      </select>
      <label style={{fontWeight:'bold'}}>Title:</label>
      <input type="text" value={title} onChange={e=>setTitle(e.target.value)} required style={{width:'100%', padding:'8px', borderRadius:'6px', border:'1px solid #ccc', marginBottom:'12px'}} />
       <label style={{fontWeight:'bold'}}>Description:</label>
       <textarea value={description} onChange={e=>setDescription(e.target.value)} required style={{width:'100%', padding:'8px', borderRadius:'6px', border:'1px solid #ccc', marginBottom:'12px'}} />
      <label style={{fontWeight:'bold'}}>Video URL:</label>
      <input type="text" value={videoUrl} onChange={e=>setVideoUrl(e.target.value)} style={{width:'100%', padding:'8px', borderRadius:'6px', border:'1px solid #ccc', marginBottom:'12px'}} />
      <label style={{fontWeight:'bold'}}>Upload File:</label>
      <input type="file" onChange={e=>setFile(e.target.files[0])} style={{width:'100%', marginBottom:'12px'}} />
      <div style={{marginBottom:'16px'}}>
        <label>Course Image:</label>
        <select value={imageId} onChange={e => setImageId(e.target.value)} style={{width:'100%', marginBottom:'8px'}}>
          <option value="">Select an image</option>
          {images.map(img => (
            <option key={img.id} value={img.id}>{img.image_name}</option>
          ))}
        </select>
        {imageId && (
          <img src={images.find(img => img.id === Number(imageId))?.image_url} alt="Course" style={{maxWidth:'120px', maxHeight:'80px', borderRadius:'8px', marginTop:'8px'}} />
        )}
      </div>
      {error && <div style={{color:'red', marginBottom:'12px'}}>{error}</div>}
      <button type="submit" style={{background:'#1976d2', color:'#fff', border:'none', borderRadius:'6px', padding:'10px 24px', fontWeight:'bold', fontSize:'1rem', cursor:'pointer'}} disabled={loading}>{loading ? 'Adding...' : 'Add Course'}</button>
    </form>
  );
};

export default AddCourse;
