// Visitor Tracking Script
import { BASE_API } from '../../../src/utils/config.js';
function recordVisit(additionalData = {}) {
    // Get basic visit information
    const visitData = {
        site_url: window.location.href,
        page_title: document.title,
        ...additionalData
    };

    // Use BASE_API from config.js
    const apiUrl = BASE_API;
    console.log('Attempting to record visit to:', `${apiUrl}/api/record-visit`);
    console.log('Visit data:', visitData);

    // Send visit data to backend
    fetch(`${apiUrl}/api/record-visit`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(visitData),
        credentials: 'include'
    })
    .then(response => {
        console.log('Fetch response status:', response.status);
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        console.log('Visit recorded successfully:', data);
    })
    .catch(error => {
        console.error('Error recording visit:', error);
        console.error('Error details:', {
            message: error.message,
            stack: error.stack,
            name: error.name
        });
    });
}

// Record visit when page loads
document.addEventListener('DOMContentLoaded', function() {
    recordVisit();
});

// Export the function to use it manually
window.recordVisit = recordVisit;
