from flask import jsonify, request
from datetime import datetime
from .app import app, get_db

# Helper to get time ago string
from dateutil.relativedelta import relativedelta

def time_ago(dt):
    now = datetime.utcnow()
    diff = relativedelta(now, dt)
    if diff.years > 0:
        return f"{diff.years} year{'s' if diff.years > 1 else ''} ago"
    if diff.months > 0:
        return f"{diff.months} month{'s' if diff.months > 1 else ''} ago"
    if diff.days > 0:
        return f"{diff.days} day{'s' if diff.days > 1 else ''} ago"
    if diff.hours > 0:
        return f"{diff.hours} hour{'s' if diff.hours > 1 else ''} ago"
    if diff.minutes > 0:
        return f"{diff.minutes} minute{'s' if diff.minutes > 1 else ''} ago"
    return "just now"

@app.route('/api/recent-actions', methods=['GET'])
def get_recent_actions():
    user_id = request.args.get('user_id')
    role = request.args.get('role')
    db = get_db()
    cursor = db.cursor()
    if role == 'Administrator':
        cursor.execute('''SELECT * FROM action_logs WHERE actor_id = ? ORDER BY created_at DESC LIMIT 15''', (user_id,))
    else:
        cursor.execute('''SELECT * FROM action_logs WHERE actor_id = ? OR target_id = ? ORDER BY created_at DESC LIMIT 10''', (user_id, user_id))
    rows = cursor.fetchall()
    columns = [desc[0] for desc in cursor.description]
    actions = []
    for row in rows:
        action = dict(zip(columns, row))
        # Parse created_at and add time_ago
        try:
            dt = datetime.strptime(action['created_at'], '%Y-%m-%d %H:%M:%S')
            action['time_ago'] = time_ago(dt)
        except Exception:
            action['time_ago'] = action['created_at']
        actions.append(action)
    return jsonify({'actions': actions})
