-- Table for medical words (source words)

CREATE TABLE medical_word (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    source_language VARCHAR, 
    source_word VARCHAR,
    date_created VARCHAR,
    created_by VARCHAR,
    update_by VARCHAR,
    last_update VARCHAR
);

-- Table for translations of medical words

CREATE TABLE medical_word_translation (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    word_id INTEGER REFERENCES medical_word(id),
    language TEXT,
    target_word VARCHAR,
    description VARCHAR,
    status VARCHAR DEFAULT 'pending',
    date_created VARCHAR,
    created_by VARCHAR,
    update_by VARCHAR,
    last_update VARCHAR,
    UNIQUE(word_id, language) -- Ensure each word_id/language pair is unique
);



INSERT INTO medical_word (source_language, source_word, date_created, created_by, update_by, last_update)
VALUES ('English', 'daycare', '2025-11-01', 'user1', 'user1', '2025-11-01');



INSERT INTO medical_word_translation (word_id, language, target_word, description, status, date_created, created_by, update_by, last_update)
VALUES (5, 'French', 'garderie', 'French description', 'pending', '2025-11-01', 'user1', 'user1', '2025-11-01');

INSERT INTO medical_word_translation (word_id, language, target_word, description, status, date_created, created_by, update_by, last_update)
VALUES (5, 'Spanish', 'guardería', 'Spanish description', 'pending', '2025-11-01', 'user1', 'user1', '2025-11-01');


-- ...existing code...