
-- SQL for creating the access_names table with access_code column (unique integer)
CREATE TABLE IF NOT EXISTS access_names (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name VARCHAR(64) NOT NULL,
    access_code INTEGER NOT NULL UNIQUE
);

-- Insert initial access names (name, access_code)
INSERT INTO access_names (name, access_code) VALUES
('Dashboard', 100),
('Courses', 101),
('My Tutorial', 102),
('My Document', 103),
('Profile', 104),
('My Progress', 105),
('Tasks', 106),
('Edit User', 107),
('Admin Settings', 108),
('Announcements Page', 109),
('Manage Media', 110),
('Manage Certificate', 111),
('Traces', 112),
('Users', 113),
('Quiz Management', 114),
('Website Traffic', 115),
('Manage Insight', 116),
('Signature', 117);
