-- Migration: Add 'code' column to access_names and update inserts

-- Add the code column
ALTER TABLE access_names ADD COLUMN code VARCHAR(64) NOT NULL UNIQUE DEFAULT '';

-- Update existing rows with codes (if needed, you can run an UPDATE for each row)
-- Example:
-- UPDATE access_names SET code = 'dashboard' WHERE name = 'dashboard';

-- For new inserts, always provide both name and code
-- Example insert:
-- INSERT INTO access_names (name, code) VALUES ('Dashboard', 'dashboard');

-- If you want to re-create the table from scratch, use:
-- CREATE TABLE IF NOT EXISTS access_names (
--     id INTEGER PRIMARY KEY AUTOINCREMENT,
--     name VARCHAR(64) NOT NULL,
--     code VARCHAR(64) NOT NULL UNIQUE
-- );
