
# --- Do not add new API here all new api should be go down the last---
from flask import request
from datetime import datetime
from flask import send_from_directory
from flask import Flask, g, request, jsonify
from flask_cors import CORS
import calendar
from flask import Flask, g, request, jsonify
from flask_cors import CORS
import sqlite3
import os
from flask_mail import Mail, Message
import pdfkit
from werkzeug.security import check_password_hash, generate_password_hash
from werkzeug.utils import secure_filename
import secrets
import datetime
from reportlab.lib.pagesizes import letter
from reportlab.pdfgen import canvas
from io import BytesIO
from flask import send_file
from flask import send_from_directory, Response
from flask import request, jsonify


app = Flask(__name__)
# --- Main block ---

# Flask-Mail configuration
app.config['MAIL_SERVER'] = 'smtp.gmail.com'
app.config['MAIL_PORT'] = 587
app.config['MAIL_USE_TLS'] = True
app.config['MAIL_USERNAME'] = 'artengineerdaudier4@gmail.com'  # Replace with your Gmail
app.config['MAIL_PASSWORD'] = 'Dauan'     # Replace with your app password
mail = Mail(app)
CORS(app, resources={r"/*": {"origins": "http://localhost:3000"}}, supports_credentials=True)
DATABASE = os.path.join(os.path.dirname(__file__), '..', 'makeitse_companies.db')


# --- Quiz Question Endpoints ---
# Create a quiz question
@app.route('/api/quiz_questions', methods=['POST'])
def create_quiz_question():
    data = request.get_json()
    quiz_id = data.get('quiz_id')
    course_id = data.get('course_id')
    module_id = data.get('module_id')
    chapter_id = data.get('chapter_id')
    content = data.get('content')
    options = data.get('options')
    correct_answer = data.get('correct_answer')
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO quiz_question (quiz_id, course_id, module_id, chapter_id, content, options, correct_answer, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)''',
                   (quiz_id, course_id, module_id, chapter_id, content, options, correct_answer, created_at))
    db.commit()
    return jsonify({'message': 'Quiz question created'}), 201


# Get all quiz questions (optionally filter by quiz/chapter)
@app.route('/api/quiz_questions', methods=['GET'])
def get_quiz_questions():
    quiz_id = request.args.get('quiz_id')
    module_id = request.args.get('module_id')
    chapter_id = request.args.get('chapter_id')
    db = get_db()
    cursor = db.cursor()
    query = 'SELECT * FROM quiz_question WHERE 1=1'
    params = []
    if quiz_id:
        query += ' AND quiz_id = ?'
        params.append(quiz_id)
    if module_id:
        query += ' AND module_id = ?'
        params.append(module_id)
    if chapter_id:
        query += ' AND chapter_id = ?'
        params.append(chapter_id)
    cursor.execute(query, params)
    questions = [dict(zip([column[0] for column in cursor.description], row)) for row in cursor.fetchall()]
    return jsonify({'questions': questions})

# Update a quiz question
@app.route('/api/quiz_questions/<int:question_id>', methods=['PUT'])
def update_quiz_question(question_id):
    data = request.get_json()
    db = get_db()
    cursor = db.cursor()
    fields = ['quiz_id', 'chapter_id', 'content', 'options', 'correct_answer']
    updates = []
    params = []
    for field in fields:
        if field in data:
            updates.append(f"{field} = ?")
            params.append(data[field])
    if not updates:
        return jsonify({'error': 'No fields to update'}), 400
    params.append(question_id)
    cursor.execute(f'''UPDATE quiz_question SET {', '.join(updates)} WHERE id = ?''', params)
    db.commit()
    return jsonify({'message': 'Quiz question updated'})

# Delete a quiz question
@app.route('/api/quiz_questions/<int:question_id>', methods=['DELETE'])
def delete_quiz_question(question_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM quiz_question WHERE id = ?', (question_id,))
    db.commit()
    return jsonify({'message': 'Quiz question deleted'})

def get_db():
    db = getattr(g, '_database', None)
    if db is None:
        db = g._database = sqlite3.connect(DATABASE, timeout=10)
    return db

@app.teardown_appcontext
def close_connection(exception):
    db = getattr(g, '_database', None)
    if db is not None:
        db.close()

# Document content supports HTML including <img> tags for image links. Images should be uploaded separately and referenced by URL in the document HTML.

# --- Create tables for course content (modules and chapters) ---
@app.route('/api/modules', methods=['POST'])
def add_module():
    data = request.get_json()
    course_id = data.get('course_id')
    name = data.get('name')
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO modules (course_id, name, created_at) VALUES (?, ?, ?)''', (course_id, name, created_at))
    db.commit()
    return jsonify({'message': 'Module added'}), 201

@app.route('/api/modules/<int:course_id>', methods=['GET'])
def get_modules(course_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id, name, created_at FROM modules WHERE course_id = ?', (course_id,))
    modules = [{'id': row[0], 'name': row[1], 'created_at': row[2]} for row in cursor.fetchall()]
    return jsonify({'modules': modules})

@app.route('/api/chapters', methods=['POST'])
def add_chapter():
    data = request.get_json()
    module_id = data.get('module_id')
    name = data.get('name')
    content = data.get('content')
    insight = data.get('insight')
    document_url = data.get('document_url')
    image_url = data.get('image_url')
    video_url = data.get('video_url')
    audio_url = data.get('audio_url')
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO chapters (module_id, name, content, insight, document_url, image_url, video_url, audio_url, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)''',
                   (module_id, name, content, insight, document_url, image_url, video_url, audio_url, created_at))
    db.commit()
    return jsonify({'message': 'Chapter added'}), 201

@app.route('/api/chapters/<int:module_id>', methods=['GET'])
def get_chapters(module_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''
        SELECT c.id, c.name, c.content, c.insight, c.document_url, c.image_url, c.video_url, c.audio_url, c.created_at, q.id as quiz_id
        FROM chapters c
        LEFT JOIN quiz q ON q.chapter_id = c.id
        WHERE c.module_id = ?
    ''', (module_id,))
    chapters = [
        {
            'id': row[0],
            'name': row[1],
            'content': row[2],
            'insight': row[3],
            'document_url': row[4],
            'image_url': row[5],
            'video_url': row[6],
            'audio_url': row[7],
            'created_at': row[8],
            'quiz_id': row[9]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'chapters': chapters})
def create_course_content_tables():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS modules (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        course_id INTEGER,
        name TEXT,
        created_at TEXT
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS chapters (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        module_id INTEGER,
        name TEXT,
        content TEXT,
        insight TEXT,
        document_url TEXT,
        image_url TEXT,
        video_url TEXT,
        created_at TEXT
    )''')

    # Quiz table: stores quiz settings and links to course/chapter
    cursor.execute('''CREATE TABLE IF NOT EXISTS quiz (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        course_id INTEGER,
        module_id INTEGER,
        chapter_id INTEGER,
        name TEXT,
        duration_minutes INTEGER,
        num_questions INTEGER,
        allowed_attempts INTEGER,
        unlock_next_on_success INTEGER DEFAULT 1,
        retry_wait_hours INTEGER DEFAULT 20,
        passing_score INTEGER DEFAULT 80,
        created_at TEXT
    )''')

    # Migration: add passing_score column if not exists
    cursor.execute("PRAGMA table_info(quiz)")
    columns = [col[1] for col in cursor.fetchall()]
    if 'passing_score' not in columns:
        cursor.execute('ALTER TABLE quiz ADD COLUMN passing_score INTEGER DEFAULT 80')
# Create a quiz
@app.route('/api/quizzes', methods=['POST'])
def create_quiz_api():
    data = request.get_json()
    course_id = data.get('course_id')
    module_id = data.get('module_id')
    chapter_id = data.get('chapter_id')
    name = data.get('name')
    duration_minutes = data.get('duration_minutes')
    num_questions = data.get('num_questions')
    allowed_attempts = data.get('allowed_attempts')
    unlock_next_on_success = data.get('unlock_next_on_success', 1)
    retry_wait_hours = data.get('retry_wait_hours', 20)
    passing_score = data.get('passing_score', 80)
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO quiz (course_id, module_id, chapter_id, name, duration_minutes, num_questions, allowed_attempts, unlock_next_on_success, retry_wait_hours, passing_score, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)''',
                   (course_id, module_id, chapter_id, name, duration_minutes, num_questions, allowed_attempts, unlock_next_on_success, retry_wait_hours, passing_score, created_at))
    db.commit()
    return jsonify({'message': 'Quiz created'}), 201

# Update a quiz
@app.route('/api/quizzes/<int:quiz_id>', methods=['PUT'])
def update_quiz_api(quiz_id):
    data = request.get_json()
    fields = ['course_id', 'module_id', 'chapter_id', 'name', 'duration_minutes', 'num_questions', 'allowed_attempts', 'unlock_next_on_success', 'retry_wait_hours', 'passing_score']
    updates = []
    params = []
    for field in fields:
        if field in data:
            updates.append(f"{field} = ?")
            params.append(data[field])
    if not updates:
        return jsonify({'error': 'No fields to update'}), 400
    params.append(quiz_id)
    db = get_db()
    cursor = db.cursor()
    cursor.execute(f'''UPDATE quiz SET {', '.join(updates)} WHERE id = ?''', params)
    db.commit()
    return jsonify({'message': 'Quiz updated'})

    # Quiz question table: stores questions, options, correct answer, and links to quiz
    cursor.execute('''CREATE TABLE IF NOT EXISTS quiz_question (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        quiz_id INTEGER,
        module_id INTEGER,
        chapter_id INTEGER,
        content TEXT,
        options TEXT,
        correct_answer TEXT,
        created_at TEXT
    )''')
    # Quiz result table: stores each user's quiz attempts and score
    cursor.execute('''CREATE TABLE IF NOT EXISTS quiz_result (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_id INTEGER,
        quiz_id INTEGER,
        score REAL,
        attempts INTEGER DEFAULT 1,
        is_passed INTEGER DEFAULT 0,
        last_updated TEXT
    )''')
    db.commit()


# --- Rates Table Creation Helper ---
def create_rates_table():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS rates (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_id INTEGER,
        language1 TEXT,
        language2 TEXT,
        rate REAL,
        per_minute INTEGER DEFAULT 0,
        hourly INTEGER DEFAULT 0,
        accept_invoice INTEGER DEFAULT 0,
        last_update TEXT,
        date_add TEXT,
        comment TEXT,
        FOREIGN KEY(user_id) REFERENCES users(id_user)
    )''')
    # Add accept_invoice column if missing
    cursor.execute("PRAGMA table_info(rates)")
    columns = [col[1] for col in cursor.fetchall()]
    if 'accept_invoice' not in columns:
        cursor.execute('ALTER TABLE rates ADD COLUMN accept_invoice INTEGER DEFAULT 0')
    db.commit()

# --- Enrolled Course Table Creation Helper ---
def create_enrolled_course_table():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS enrolled_course (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        course_id INTEGER NOT NULL,
        user_id INTEGER NOT NULL,
        assigned_at TEXT NOT NULL,
        FOREIGN KEY(course_id) REFERENCES courses(id),
        FOREIGN KEY(user_id) REFERENCES users(id_user)
    )''')
    db.commit()

# Ensure course content tables are created at startup
with app.app_context():
    create_course_content_tables()
    create_rates_table()
    create_enrolled_course_table()

    # --- Create Trace Table and Endpoint ---
def create_trace_table():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS trace (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        actor_id INTEGER,
        actor_email TEXT,
        target_id INTEGER,
        target_email TEXT,
        action_type TEXT,
        action_details TEXT,
        timestamp TEXT
    )''')
    db.commit()
    
# --- Create course Table and Endpoint  Endpoint to add a new course ---
@app.route('/api/courses/add', methods=['POST', 'OPTIONS'])
def add_course():
    if request.method == 'OPTIONS':
        return jsonify({'message': 'CORS preflight'}), 200
    data = request.get_json()
    type_ = data.get('type')
    course_name = data.get('course_name')
    course_language = data.get('course_language')
    description = data.get('description')
    create_by = data.get('create_by')
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS courses (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        type TEXT,
        course_id INTEGER,
        course_name TEXT,
        course_language TEXT,
        description TEXT,
        image_url TEXT,
        create_by TEXT,
        created_at TEXT,
        update_by TEXT
    )''')
    db.commit()
    # Generate next course_id (max + 1)
    cursor.execute('SELECT MAX(course_id) FROM courses')
    max_course_id = cursor.fetchone()[0]
    next_course_id = (max_course_id or 0) + 1
    image_id = data.get('image_id')
    image_url = None
    if image_id:
        cursor.execute('SELECT image_url FROM image_url WHERE id = ?', (image_id,))
        row = cursor.fetchone()
        if row:
            image_url = row[0]
    cursor.execute('''INSERT INTO courses (type, course_id, course_name, course_language, description, image_url, create_by, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)''',
        (type_, next_course_id, course_name, course_language, description, image_url, create_by, created_at))
    db.commit()
    return jsonify({'message': 'Course added successfully', 'course_id': next_course_id}), 201


@app.route('/api/trace', methods=['POST'])
def log_trace():
    data = request.get_json()
    actor_id = data.get('actor_id')
    actor_email = data.get('actor_email')
    target_id = data.get('target_id')
    target_email = data.get('target_email')
    action_type = data.get('action_type')
    action_details = data.get('action_details')
    timestamp = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    create_trace_table()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO trace (actor_id, actor_email, target_id, target_email, action_type, action_details, timestamp)
        VALUES (?, ?, ?, ?, ?, ?, ?)''',
        (actor_id, actor_email, target_id, target_email, action_type, action_details, timestamp))
    db.commit()
    return jsonify({'message': 'Action logged'}), 201


# Endpoint to view and sign a document
@app.route('/sign/<int:doc_id>', methods=['GET', 'POST'])
def sign_document(doc_id):
    db = get_db()
    cursor = db.cursor()
    if request.method == 'GET':
        token = request.args.get('token')
        cursor.execute('SELECT expires_at, email FROM signature_tokens WHERE token = ?', (token,))
        token_row = cursor.fetchone()
        now = int(datetime.datetime.utcnow().timestamp())
        if not token_row or now > token_row[0]:
            return jsonify({'error': 'Invalid or expired token'}), 403
        cursor.execute('SELECT id, name, document_content, company_code FROM documents WHERE id = ?', (doc_id,))
        doc = cursor.fetchone()
        if not doc:
            return jsonify({'error': 'Document not found'}), 404
        return jsonify({
            'id': doc[0],
            'name': doc[1],
            'document_content': doc[2],
            'company_code': doc[3],
            'email': token_row[1]
        })
    elif request.method == 'POST':
        data = request.get_json()
        signed_content = data.get('signed_content')
        signer_email = data.get('signer_email')
        if not signed_content:
            return jsonify({'error': 'Signed content required'}), 400
        cursor.execute('UPDATE documents SET signed_content = ? WHERE id = ?', (signed_content, doc_id))
        db.commit()
        # Generate PDF from signed_content
        pdf_filename = f'signed_document_{doc_id}.pdf'
        pdfkit.from_string(signed_content, pdf_filename)
        # Send PDF to signer and admin
        admin_email = 'artengineerdaudier4@gmail.com'
        subject = 'Signed Document Copy'
        html_body = f"""
        <h2>Signed Document</h2>
        <p>The document has been signed. Please find the PDF attached.</p>
        <hr>
        <div>{signed_content}</div>
        """
        with app.open_resource(pdf_filename) as pdf:
            msg_signer = Message(subject, sender=app.config['MAIL_USERNAME'], recipients=[signer_email])
            msg_signer.html = html_body
            msg_signer.attach(pdf_filename, 'application/pdf', pdf.read())
            mail.send(msg_signer)
        with app.open_resource(pdf_filename) as pdf:
            msg_admin = Message(subject, sender=app.config['MAIL_USERNAME'], recipients=[admin_email])
            msg_admin.html = html_body
            msg_admin.attach(pdf_filename, 'application/pdf', pdf.read())
            mail.send(msg_admin)
        # Clean up PDF file if needed
        os.remove(pdf_filename)
        return jsonify({'message': 'Document signed and emailed successfully'})

# Endpoint to get all documents (for preview)
@app.route('/documents/all', methods=['GET'])
def get_all_documents():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id, document_content, company_code, signature_indication FROM documents')
    docs = [
        {
            'id': row[0],
            'document_content': row[1],
            'company_code': row[2],
            'signature_indication': row[3]
        } for row in cursor.fetchall()
    ]
    return jsonify({'documents': docs})
@app.route('/register', methods=['POST', 'OPTIONS'])
def register():
    if request.method == 'OPTIONS':
        return jsonify({'message': 'CORS preflight'}), 200
    data = request.get_json()
    email = data.get('email')
    mot_de_pass = data.get('password')
    role = data.get('role')
    code = data.get('code')
    sexe = data.get('sexe')
    language = data.get('language')
    if not email or not mot_de_pass or not role:
        return jsonify({'error': 'Email, password, and role required'}), 400
    hashed_password = generate_password_hash(mot_de_pass)
    db = get_db()
    cursor = db.cursor()
    # Ensure users table exists with all columns
    cursor.execute('''CREATE TABLE IF NOT EXISTS users (
        id_user INTEGER PRIMARY KEY,
        email TEXT UNIQUE,
        mot_de_passe TEXT,
        role TEXT,
        code TEXT,
        sexe TEXT,
        language TEXT,
        invoice INTEGER DEFAULT 0,
        nom TEXT,
        prenom TEXT,
        rates REAL DEFAULT 0.0,
        hourly INTEGER DEFAULT 0,
        minute INTEGER DEFAULT 0
    )''')
    db.commit()
    start_id = 72
    cursor.execute('SELECT id_user FROM users WHERE id_user >= ? ORDER BY id_user ASC', (start_id,))
    used_ids = [row[0] for row in cursor.fetchall()]
    iduser = start_id
    for used in used_ids:
        if used > iduser:
            break
        if used == iduser:
            iduser += 1
    # Insert new user
    try:
        cursor.execute('INSERT INTO users (email, mot_de_passe, role, id_user, code, sexe, language) VALUES (?, ?, ?, ?, ?, ?, ?)',
                        (email, hashed_password, role, iduser, code, sexe, language))
        db.commit()
        return jsonify({'message': 'User registered', 'id_user': iduser}), 201
    except sqlite3.IntegrityError:
        return jsonify({'error': 'Email already exists'}), 409
@app.route('/')
def index():
    return {'message': 'Backend is running.'}

@app.route('/documents', methods=['POST'])
def add_document():
    data = request.get_json()
    name = data.get('name')
    content = data.get('content')
    company_code = data.get('company_code')
    indication = data.get('indication')
    if not name or not name.strip():
        return jsonify({'error': 'Document name is required'}), 400
    if not content:
        return jsonify({'error': 'Document content required'}), 400
    db = get_db()
    cursor = db.cursor()
    try:
        cursor.execute('INSERT INTO documents (name, document_content, company_code, signature_indication) VALUES (?, ?, ?, ?)', (name, content, company_code, indication))
        db.commit()
    except Exception as e:
        return jsonify({'error': str(e)}), 500
    return jsonify({'message': 'Document added'}), 201

@app.route('/documents/request-signature', methods=['POST'])
def request_signature():
    data = request.get_json()
    document_id = data.get('document_id')
    email = data.get('email')
    expires_in = data.get('expires_in', 3600)  # seconds, default 1 hour
    if not document_id or not email:
        return jsonify({'error': 'Document ID and email required'}), 400
    # Generate secure token
    token = secrets.token_urlsafe(32)
    expires_at = int((datetime.datetime.utcnow() + datetime.timedelta(seconds=expires_in)).timestamp())
    db = get_db()
    cursor = db.cursor()
    cursor.execute('CREATE TABLE IF NOT EXISTS signature_tokens (token TEXT PRIMARY KEY, document_id INTEGER, email TEXT, expires_at INTEGER)')
    cursor.execute('INSERT INTO signature_tokens (token, document_id, email, expires_at) VALUES (?, ?, ?, ?)', (token, document_id, email, expires_at))
    db.commit()
    # Generate frontend link for React app
    frontend_link = f"http://localhost:3000/sign/{document_id}/{token}"
    return jsonify({'link': frontend_link, 'expires_at': expires_at})


@app.route('/documents/signed', methods=['GET'])
def view_signed_documents():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id, document_content, signed_content FROM documents WHERE signed_content IS NOT NULL')
    docs = [
        {'id': row[0], 'document_content': row[1], 'signed_content': row[2]} for row in cursor.fetchall()
    ]
    return jsonify({'signed_documents': docs})

@app.route('/courses/<int:user_id>', methods=['GET'])
def get_courses(user_id):
    db = get_db()
    cursor = db.cursor()
    # Ensure certificate table exists
    cursor.execute('''CREATE TABLE IF NOT EXISTS certificate (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_id TEXT,
        certificate_type TEXT,
        cerf_id TEXT,
        qr_code_filename TEXT,
        html_filename TEXT,
        pdf_filename TEXT,
        created_at TEXT,
        updated_at TEXT,
        field_1 INTEGER,
        field_2 INTEGER,
        field_3 INTEGER,
        field_4 INTEGER,
        field_5 INTEGER,
        field_6 INTEGER,
        field_7 INTEGER,
        field_8 INTEGER,
        field_9 INTEGER,
        field_10 INTEGER,
        field_11 INTEGER,
        certificate_medical_interpreter INTEGER,
        certificate_hipaa_compliance INTEGER,
        certificate_legal_interpreter INTEGER,
        date_validity TEXT,
        certificate_text TEXT,
        is_active INTEGER,
        language_from TEXT,
        language_to TEXT
    )''')
    db.commit()
    # Get user role
    cursor.execute('SELECT role FROM users WHERE id_user = ?', (user_id,))
    user = cursor.fetchone()
    if not user:
        return jsonify({'error': 'User not found'}), 404
    role = user[0]
    # Fetch courses/videos for this role
    cursor.execute('SELECT id, course_id, course_name, course_language, description, image_url FROM courses')
    courses = [
        {
            'id': row[0],
            'course_id': row[1],
            'course_name': row[2],
            'course_language': row[3],
            'description': row[4],
            'image_url': row[5]
        } for row in cursor.fetchall()
    ]
    return jsonify({'courses': courses})


@app.route('/login', methods=['POST'])
def login():
    data = request.get_json()
    email = data.get('email')
    mot_de_pass = data.get('password')
    if not email or not mot_de_pass:
        return jsonify({'error': 'Email and password required'}), 400
    db = get_db()
    cursor = db.cursor()
    # Ensure users table exists
    cursor.execute('''CREATE TABLE IF NOT EXISTS users (
        id_user INTEGER PRIMARY KEY,
        email TEXT UNIQUE,
        mot_de_passe TEXT,
        role TEXT,
        code TEXT,
        sexe TEXT,
        language TEXT,
        invoice INTEGER DEFAULT 0,
        nom TEXT,
        prenom TEXT,
        rates REAL DEFAULT 0.0,
        hourly INTEGER DEFAULT 0,
        minute INTEGER DEFAULT 0
    )''')
    db.commit()
    cursor.execute('SELECT id_user, mot_de_passe, role FROM users WHERE email = ?', (email,))
    user = cursor.fetchone()
    if not user:
        return jsonify({'error': 'Invalid email or password'}), 401
    db_password = user[1]
    if not check_password_hash(db_password, mot_de_pass):
        return jsonify({'error': 'Invalid email or password'}), 401
    # Set enligne=1 for this user
    cursor.execute('UPDATE users SET enligne = 1 WHERE id_user = ?', (user[0],))
    db.commit()
    return jsonify({'id_user': user[0], 'role': user[2]}), 200

@app.route('/roles/<int:user_id>', methods=['GET'])
def get_roles(user_id):
    db = get_db()
    cursor = db.cursor()
    # Ensure users table exists
    cursor.execute('''CREATE TABLE IF NOT EXISTS users (
        id_user INTEGER PRIMARY KEY,
        email TEXT UNIQUE,
        mot_de_passe TEXT,
        role TEXT,
        code TEXT,
        sexe TEXT,
        language TEXT,
        invoice INTEGER DEFAULT 0,
        nom TEXT,
        prenom TEXT,
        rates REAL DEFAULT 0.0,
        hourly INTEGER DEFAULT 0,
        minute INTEGER DEFAULT 0
    )''')
    db.commit()
    cursor.execute('SELECT role FROM users WHERE id_user = ?', (user_id,))
    user = cursor.fetchone()
    if not user:
        return jsonify({'error': 'User not found'}), 404
    role = user[0]
    # If you have a permissions table, fetch permissions here
    # cursor.execute('SELECT permission FROM permissions WHERE role = ?', (role,))
    # permissions = [row[0] for row in cursor.fetchall()]
    # return jsonify({'role': role, 'permissions': permissions})
    return jsonify({'role': role})

# --- PDF Preview Endpoint ---
@app.route('/documents/pdf-preview/<int:doc_id>', methods=['GET'])
def pdf_preview(doc_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT name, document_content FROM documents WHERE id = ?', (doc_id,))
    doc = cursor.fetchone()
    if not doc:
        return jsonify({'error': 'Document not found'}), 404
    name, content = doc
    buffer = BytesIO()
    p = canvas.Canvas(buffer, pagesize=letter)
    p.setFont("Helvetica", 12)
    y = 750
    p.drawString(72, y, f"Document Name: {name if name else 'N/A'}")
    y -= 30
    # Simple HTML to text conversion for PDF preview
    import re
    text_content = re.sub('<[^<]+?>', '', content)
    for line in text_content.split('\n'):
        p.drawString(72, y, line[:100])
        y -= 18
        if y < 72:
            p.showPage()
            y = 750
    p.save()
    buffer.seek(0)
    return send_file(buffer, as_attachment=False, download_name=f'document_{doc_id}_preview.pdf', mimetype='application/pdf')

@app.route('/api/users', methods=['GET'])
def get_users():
    db = get_db()
    cursor = db.cursor()
    # Ensure users table exists
    cursor.execute('''CREATE TABLE IF NOT EXISTS users (
        id_user INTEGER PRIMARY KEY,
        email TEXT UNIQUE,
        mot_de_passe TEXT,
        role TEXT,
        code TEXT,
        sexe TEXT,
        language TEXT,
        invoice INTEGER DEFAULT 0,
        nom TEXT,
        prenom TEXT,
        rates REAL DEFAULT 0.0,
        hourly INTEGER DEFAULT 0,
        minute INTEGER DEFAULT 0,
        visible INTEGER DEFAULT 1,
        date_created TEXT,
        llogin TEXT,
        img TEXT
    )''')
    db.commit()
    # Add visible column if missing
    cursor.execute("PRAGMA table_info(users)")
    columns = [col[1] for col in cursor.fetchall()]
    if 'visible' not in columns:
        cursor.execute('ALTER TABLE users ADD COLUMN visible INTEGER DEFAULT 1')
        db.commit()
    cursor.execute('SELECT id, id_user, email, role, code, sexe, language, invoice, nom, prenom, rates, date_created, llogin, img, visible FROM users')
    users = []
    for row in cursor.fetchall():
        # id is row[0], id_user is row[1]
        lastname = row[8] if len(row) > 8 and row[8] else ''
        firstname = row[9] if len(row) > 9 and row[9] else ''
        name = f"{firstname} {lastname}".strip() if firstname or lastname else row[2].split('@')[0]
        rates = row[10] if len(row) > 10 else None
        date_created = row[11] if len(row) > 11 else None
        lastlogin = row[12] if len(row) > 12 else None
        img = row[13] if len(row) > 13 else None
        visible = row[14] if len(row) > 14 else 1
        users.append({
            'id': row[0],
            'id_user': row[1],
            'email': row[2],
            'role': row[3],
            'code': row[4],
            'sexe': row[5],
            'language': row[6],
            'invoice': row[7],
            'name': name,
            'prenom': firstname,
            'nom': lastname,
            'rates': rates,
            'date_created': date_created,
            'llogin': lastlogin,
            'img': img,
            'visible': visible,
            'is_new': False
        })
    return jsonify(users)

# --- Add Role Endpoint ---
@app.route('/api/roles', methods=['POST'])
def add_role():
    data = request.get_json()
    role_name = data.get('role_name')
    redirect_path = data.get('redirect_path')
    description = data.get('description')
    permissions = data.get('permissions')
    now = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    if not role_name:
        return jsonify({'error': 'Role name required'}), 400
    db = get_db()
    cursor = db.cursor()
    try:
        cursor.execute('''INSERT INTO roles (role_name, redirect_path, description, permissions, created_at, updated_at)
            VALUES (?, ?, ?, ?, ?, ?)''',
            (role_name, redirect_path, description, permissions, now, now))
        db.commit()
        return jsonify({'message': 'Role added successfully'}), 201
    except Exception as e:
        return jsonify({'error': str(e)}), 500
    
    
# --- Interpreter Chart Endpoints ---
def create_interpreter_chart_table():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS interpreter_chart (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        interpreter_id INTEGER,
        interpreter_email TEXT,
        year INTEGER,
        month INTEGER,
        minutes_worked INTEGER DEFAULT 0,
        accept_invoice BOOLEAN DEFAULT 0
    )''')
    db.commit()

# Endpoint to bulk update minutes worked for interpreters with accept_invoice = true
@app.route('/api/interpreter_chart/update_minutes', methods=['POST'])
def update_interpreter_minutes():
    data = request.get_json()
    year = data.get('year')
    month = data.get('month')
    minutes = data.get('minutes')
    if not year or not month or minutes is None:
        return jsonify({'error': 'Year, month, and minutes required'}), 400
    db = get_db()
    create_interpreter_chart_table()
    cursor = db.cursor()
    # Ensure users table exists
    cursor.execute('''CREATE TABLE IF NOT EXISTS users (
        id_user INTEGER PRIMARY KEY,
        email TEXT UNIQUE,
        mot_de_passe TEXT,
        role TEXT,
        code TEXT,
        sexe TEXT,
        language TEXT,
        invoice INTEGER DEFAULT 0,
        nom TEXT,
        prenom TEXT,
        rates REAL DEFAULT 0.0,
        hourly INTEGER DEFAULT 0,
        minute INTEGER DEFAULT 0
    )''')
    db.commit()
    interpreter_id = data.get('interpreter_id')
    if interpreter_id:
        # Update for a single interpreter (role = 'Interpreter' only)
        # Only allow role = 'Interpreter' (case-sensitive)
        cursor.execute('SELECT id_user, nom FROM users WHERE id_user = ? AND role = "Interpreter" AND invoice = 1', (interpreter_id,))
        row = cursor.fetchone()
        if not row:
            return jsonify({'error': 'Interpreter not found or invoice not enabled'}), 404
        interpreter_id_db, interpreter_nom = row
        cursor.execute('SELECT interpreter_id FROM interpreter_chart WHERE interpreter_id = ? AND year = ? AND month = ?', (interpreter_id_db, year, month))
        chart_row = cursor.fetchone()
        if chart_row:
            cursor.execute('UPDATE interpreter_chart SET minutes_worked = ? WHERE interpreter_id = ? AND year = ? AND month = ?', (minutes, interpreter_id_db, year, month))
        else:
            cursor.execute('INSERT INTO interpreter_chart (interpreter_id, interpreter_email, year, month, minutes_worked, accept_invoice) VALUES (?, ?, ?, ?, ?, 1)', (interpreter_id_db, interpreter_nom, year, month, minutes))
        db.commit()
        return jsonify({'message': f'Minutes updated for interpreter {interpreter_id_db}'}), 200
    else:
        # Bulk update for all interpreters with invoice = 1 (role = 'Interpreter' only)
        # Only allow role = 'Interpreter' (case-sensitive)
        cursor.execute('SELECT id_user, nom FROM users WHERE role = "Interpreter" AND invoice = 1')
        interpreters = cursor.fetchall()
        for interpreter_id_bulk, interpreter_nom_bulk in interpreters:
            cursor.execute('SELECT interpreter_id FROM interpreter_chart WHERE interpreter_id = ? AND year = ? AND month = ?', (interpreter_id_bulk, year, month))
            row = cursor.fetchone()
            if row:
                cursor.execute('UPDATE interpreter_chart SET minutes_worked = ? WHERE interpreter_id = ? AND year = ? AND month = ?', (minutes, interpreter_id_bulk, year, month))
            else:
                cursor.execute('INSERT INTO interpreter_chart (interpreter_id, interpreter_email, year, month, minutes_worked, accept_invoice) VALUES (?, ?, ?, ?, ?, 1)', (interpreter_id_bulk, interpreter_nom_bulk, year, month, minutes))
        db.commit()
        return jsonify({'message': 'Minutes updated for interpreters'}), 200

# Endpoint to get interpreter chart for dashboard
@app.route('/api/interpreter_chart', methods=['GET'])
def get_interpreter_chart():
    year = request.args.get('year', datetime.datetime.now().year)
    db = get_db()
    create_interpreter_chart_table()
    cursor = db.cursor()
    cursor.execute('''SELECT interpreter_id, interpreter_email, year, month, minutes_worked FROM interpreter_chart WHERE year = ? AND accept_invoice = 1''', (year,))
    rows = cursor.fetchall()
    chart = {}
    for interpreter_id, interpreter_email, year, month, minutes_worked in rows:
        if interpreter_id not in chart:
            chart[interpreter_id] = {
                'interpreter_email': interpreter_email,
                'year': year,
                'monthly_minutes': [0]*12
            }
        chart[interpreter_id]['monthly_minutes'][month-1] = minutes_worked
    return jsonify({'chart': chart})

# --- Endpoint to fetch school types for course type dropdown ---
@app.route('/api/schools', methods=['GET'])
def get_schools():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS schools (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        type TEXT NOT NULL,
        description TEXT,
        create_at TEXT
    )''')
    db.commit()
    cursor.execute('SELECT id, name ,type FROM schools')
    schools = [{'id': row[0], 'name': row[1], 'type': row[2]} for row in cursor.fetchall()]
    return jsonify({'schools': schools})

# --- Endpoint to list all courses ---
@app.route('/api/courses', methods=['GET'])
def list_courses():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS courses (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        type TEXT,
        course_id INTEGER,
        course_name TEXT,
        course_language TEXT,
        description TEXT,
        create_by TEXT,
        created_at TEXT,
        update_by TEXT
    )''')
    db.commit()
    cursor.execute('SELECT id, type, course_id, course_name, course_language, description, image_url, create_by, created_at, update_by FROM courses')
    courses = [
        {
            'id': row[0],
            'type': row[1],
            'course_id': row[2],
            'course_name': row[3],
            'course_language': row[4],
            'description': row[5],
            'image_url': row[6],
            'create_by': row[7],
            'created_at': row[8],
            'update_by': row[9]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'courses': courses})

# --- Endpoint to list all audios ---
@app.route('/api/audios', methods=['GET'])
def list_audios():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS audio_url (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        audio_name TEXT,
        audio_url TEXT,
        type TEXT,
        description TEXT,
        create_by TEXT,
        created_at TEXT,
        update_by TEXT
    )''')
    db.commit()
    cursor.execute('SELECT id, audio_name, audio_url, type, description, create_by, created_at, update_by FROM audio_url')
    audios = [
        {
            'id': row[0],
            'audio_name': row[1],
            'audio_url': row[2],
            'type': row[3],
            'description': row[4],
            'create_by': row[5],
            'created_at': row[6],
            'update_by': row[7]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'audios': audios})

# --- Endpoint to list all images ---
@app.route('/api/images', methods=['GET'])
def list_images():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS image_url (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        image_name TEXT,
        image_url TEXT,
        type TEXT,
        description TEXT,
        create_by TEXT,
        created_at TEXT,
        update_by TEXT
    )''')
    db.commit()
    cursor.execute('SELECT id, image_name, image_url, type, description, create_by, created_at, update_by FROM image_url')
    images = [
        {
            'id': row[0],
            'image_name': row[1],
            'image_url': row[2],
            'type': row[3],
            'description': row[4],
            'create_by': row[5],
            'created_at': row[6],
            'update_by': row[7]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'images': images})

# --- Endpoint to list all videos ---
@app.route('/api/videos', methods=['GET'])
def list_videos():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS video_url (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        video_name TEXT,
        video_url TEXT,
        type TEXT,
        description TEXT,
        create_by TEXT,
        created_at TEXT,
        update_by TEXT
    )''')
    db.commit()
    cursor.execute('SELECT id, video_name, video_url, type, description, create_by, created_at, update_by FROM video_url')
    videos = [
        {
            'id': row[0],
            'video_name': row[1],
            'video_url': row[2],
            'type': row[3],
            'description': row[4],
            'create_by': row[5],
            'created_at': row[6],
            'update_by': row[7]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'videos': videos})

# --- Endpoint to list all documents---
@app.route('/api/documents_url', methods=['GET'])
def list_documents_url():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS documents_url (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        document_name TEXT,
        document_url TEXT,
        type TEXT,
        description TEXT,
        create_by TEXT,
        created_at TEXT,
        update_by TEXT
    )''')
    db.commit()
    cursor.execute('SELECT id, document_name, document_url, type, description, create_by, created_at, update_by FROM documents_url')
    documents = [
        {
            'id': row[0],
            'document_name': row[1],
            'document_url': row[2],
            'type': row[3],
            'description': row[4],
            'create_by': row[5],
            'created_at': row[6],
            'update_by': row[7]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'documents': documents})

# --- Upload endpoint for documents (for documents_url table) ---
@app.route('/api/documents_url/upload', methods=['POST'])
def upload_document_url():
    file = request.files.get('file')
    name = request.form.get('name')
    type_ = request.form.get('type')
    description = request.form.get('description')
    create_by = request.form.get('create_by')
    update_by = request.form.get('update_by')
    if not file or not name:
        return jsonify({'error': 'Missing file or name'}), 400
    filename = secure_filename(file.filename)
    save_dir = os.path.join('public', 'documents')
    os.makedirs(save_dir, exist_ok=True)
    save_path = os.path.join(save_dir, filename)
    file.save(save_path)
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO documents_url (document_name, document_url, type, description, create_by, created_at, update_by) VALUES (?, ?, ?, ?, ?, ?, ?)''',
                   (name, f'/documents/{filename}', type_, description, create_by, datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'), update_by))
    db.commit()
    return jsonify({'message': 'Document uploaded'}), 201

# --- Delete endpoint for images ---
@app.route('/api/images/delete/<int:id>', methods=['DELETE'])
def delete_image(id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT image_url FROM image_url WHERE id = ?', (id,))
    row = cursor.fetchone()
    if row:
        file_path = os.path.join('public', row[0].lstrip('/'))
        try:
            os.remove(file_path)
        except Exception:
            pass
    cursor.execute('DELETE FROM image_url WHERE id = ?', (id,))
    db.commit()
    return jsonify({'message': 'Image deleted'})

# --- Upload endpoint for audios ---
@app.route('/api/audios/upload', methods=['POST'])
def upload_audio():
    file = request.files.get('file')
    name = request.form.get('name')
    type_ = request.form.get('type')
    if not file or not name:
        return jsonify({'error': 'Missing file or name'}), 400
    filename = secure_filename(file.filename)
    save_dir = os.path.join('public', 'audios')
    os.makedirs(save_dir, exist_ok=True)
    save_path = os.path.join(save_dir, filename)
    file.save(save_path)
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO audio_url (audio_name, audio_url, type, created_at) VALUES (?, ?, ?, ?)''',
                   (name, f'/audios/{filename}', type_, datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')))
    db.commit()
    return jsonify({'message': 'Audio uploaded'}), 201

# --- Upload endpoint for videos ---
@app.route('/api/videos/upload', methods=['POST'])
def upload_video():
    file = request.files.get('file')
    name = request.form.get('name')
    type_ = request.form.get('type')
    if not file or not name:
        return jsonify({'error': 'Missing file or name'}), 400
    filename = secure_filename(file.filename)
    save_dir = os.path.join('public', 'videos')
    os.makedirs(save_dir, exist_ok=True)
    save_path = os.path.join(save_dir, filename)
    file.save(save_path)
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO video_url (video_name, video_url, type, created_at) VALUES (?, ?, ?, ?)''',
                   (name, f'/videos/{filename}', type_, datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')))
    db.commit()
    return jsonify({'message': 'Video uploaded'}), 201

# --- Upload endpoint for images ---
@app.route('/api/images/upload', methods=['POST'])
def upload_image():
    file = request.files.get('file')
    name = request.form.get('name')
    type_ = request.form.get('type')
    if not file or not name:
        return jsonify({'error': 'Missing file or name'}), 400
    filename = secure_filename(file.filename)
    save_dir = os.path.join('public', 'images')
    os.makedirs(save_dir, exist_ok=True)
    save_path = os.path.join(save_dir, filename)
    file.save(save_path)
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO image_url (image_name, image_url, type, created_at) VALUES (?, ?, ?, ?)''',
                   (name, f'/images/{filename}', type_, datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')))
    db.commit()
    return jsonify({'message': 'Image uploaded'}), 201

# --- Delete endpoint for audios ---
@app.route('/api/audios/delete/<int:id>', methods=['DELETE'])
def delete_audio(id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT audio_url FROM audio_url WHERE id = ?', (id,))
    row = cursor.fetchone()
    if row:
        file_path = os.path.join('public', row[0].lstrip('/'))
        try:
            os.remove(file_path)
        except Exception:
            pass
    cursor.execute('DELETE FROM audio_url WHERE id = ?', (id,))
    db.commit()
    return jsonify({'message': 'Audio deleted'})

# --- Delete endpoint for videos ---
@app.route('/api/videos/delete/<int:id>', methods=['DELETE'])
def delete_video(id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT video_url FROM video_url WHERE id = ?', (id,))
    row = cursor.fetchone()
    if row:
        file_path = os.path.join('public', row[0].lstrip('/'))
        try:
            os.remove(file_path)
        except Exception:
            pass
    cursor.execute('DELETE FROM video_url WHERE id = ?', (id,))
    db.commit()
    return jsonify({'message': 'Video deleted'})

# --- Edit Course Endpoint ---
@app.route('/api/courses/edit/<int:course_id>', methods=['POST', 'OPTIONS'])
def edit_course(course_id):
    if request.method == 'OPTIONS':
        return jsonify({'message': 'CORS preflight'}), 200
    data = request.get_json()
    type_ = data.get('type')
    course_name = data.get('course_name')
    course_language = data.get('course_language')
    description = data.get('description')
    image_id = data.get('image_id')
    update_by = data.get('update_by')
    db = get_db()
    cursor = db.cursor()
    image_url = None
    if image_id:
        cursor.execute('SELECT image_url FROM image_url WHERE id = ?', (image_id,))
        row = cursor.fetchone()
        if row:
            image_url = row[0]
    cursor.execute('''UPDATE courses SET type=?, course_name=?, course_language=?, description=?, image_url=?, update_by=? WHERE id=?''',
                   (type_, course_name, course_language, description, image_url, update_by, course_id))
    db.commit()
    return jsonify({'message': 'Course updated successfully'}), 200

@app.route('/api/interpreter_chart/<int:user_id>', methods=['GET'])
def get_user_interpreter_chart(user_id):
    db = get_db()
    create_interpreter_chart_table()
    cursor = db.cursor()
    cursor.execute('SELECT month, year, minutes_worked FROM interpreter_chart WHERE interpreter_id = ? ORDER BY year, month', (user_id,))
    data = cursor.fetchall()
    chart = {}
    for month, year, minutes_worked in data:
        key = f'{year}-{month:02d}'
        chart[key] = chart.get(key, 0) + (minutes_worked or 0)
    return jsonify({'chart': chart})


# Serve images from public/images
@app.route('/images/<path:filename>')
def serve_image(filename):
    return send_from_directory('public/images', filename)

# Serve profile images from absolute path
@app.route('/profile/<path:filename>')
def serve_profile(filename):
    import os
    profile_dir = os.path.join(os.path.dirname(__file__), 'public', 'profile')
    return send_from_directory(profile_dir, filename)

# Serve assets from public/assets
@app.route('/public/assets/<path:filename>')
def serve_asset(filename):
    return send_from_directory('public/assets', filename)

# --- Serve videos from public/videos ---
@app.route('/videos/<path:filename>')
def serve_video(filename):
    return send_from_directory(os.path.join('public', 'videos'), filename)

# --- Interpreter earnings Endpoint ---
@app.route('/api/interpreter_earnings/<int:user_id>/<int:month>/<int:year>', methods=['GET'])
def get_interpreter_earnings(user_id, month, year):
    db = get_db()
    create_interpreter_chart_table()
    cursor = db.cursor()
    # Ensure users table exists
    cursor.execute('''CREATE TABLE IF NOT EXISTS users (
        id_user INTEGER PRIMARY KEY,
        email TEXT UNIQUE,
        mot_de_passe TEXT,
        role TEXT,
        code TEXT,
        sexe TEXT,
        language TEXT,
        invoice INTEGER DEFAULT 0,
        nom TEXT,
        prenom TEXT,
        rates REAL DEFAULT 0.0,
        hourly INTEGER DEFAULT 0,
        minute INTEGER DEFAULT 0
    )''')
    db.commit()
    # Get rate and type from users table
    cursor.execute('SELECT rates, hourly, minute FROM users WHERE id_user = ?', (user_id,))
    user_row = cursor.fetchone()
    if not user_row:
        return jsonify({'error': 'User not found'}), 404
    rate, hourly, minute = user_row
    try:
        rate = float(rate)
    except (TypeError, ValueError):
        rate = 0.0
    # Convert to boolean: treat 1 as true, 0 as false
    hourly = True if str(hourly) == '1' else False
    minute = True if str(minute) == '1' else False
    # Get minutes worked for this month/year from interpreter_chart
    cursor.execute('SELECT minutes_worked FROM interpreter_chart WHERE interpreter_id = ? AND month = ? AND year = ?', (user_id, month, year))
    minutes_worked_row = cursor.fetchone()
    minutes_worked = minutes_worked_row[0] if minutes_worked_row and minutes_worked_row[0] is not None else 0
    earning = 0
    earning_type = ''
    display_quantity = 0
    display_unit = ''
    if hourly:
        hours = minutes_worked / 60.0
        earning = hours * rate
        earning_type = 'hourly'
        display_quantity = round(hours, 2)
        display_unit = 'hours'
    elif minute:
        earning = minutes_worked * rate
        earning_type = 'minute'
        display_quantity = minutes_worked
        display_unit = 'minutes'
    return jsonify({
        'minutes_worked': minutes_worked,
        'earning': round(earning, 2),
        'rate': rate,
        'type': earning_type,
        'display_quantity': display_quantity,
        'display_unit': display_unit
    })

# --- Main block ---

# --- Announcements Table and Endpoints ---
######################### Medical Document Glossary API #########################
######################### Assigned Insights API #########################

# Endpoint: List insights assigned to a user
@app.route('/api/assigned_insights/<int:user_id>', methods=['GET'])
def list_assigned_insights(user_id):
    db = get_db()
    cursor = db.cursor()
    # Get all insight IDs assigned to this user
    cursor.execute('SELECT insight_id FROM insight_assignment WHERE user_id = ?', (user_id,))
    insight_ids = [row[0] for row in cursor.fetchall()]
    if not insight_ids:
        return jsonify({'insights': []})
    placeholders = ','.join(['?'] * len(insight_ids))
    cursor.execute(f'SELECT id, title, content, document_url, image_url, created_at, updated_at FROM insight_documentation WHERE id IN ({placeholders}) ORDER BY created_at DESC', tuple(insight_ids))
    insights = [
        {
            'id': row[0],
            'title': row[1],
            'content': row[2],
            'document_url': row[3],
            'image_url': row[4],
            'created_at': row[5],
            'updated_at': row[6]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'insights': insights})
import math

def create_medical_document_tables():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS medical_document (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        owner_id INTEGER NOT NULL,
        created_at TEXT
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS medical_word (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        source_language VARCHAR, 
        source_word VARCHAR,
        date_created VARCHAR,
        created_by VARCHAR,
        update_by VARCHAR,
        last_update VARCHAR
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS medical_word_translation (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        word_id INTEGER REFERENCES medical_word(id),
        language TEXT,
        target_word VARCHAR,
        description VARCHAR,
        status VARCHAR DEFAULT 'pending',
        date_created VARCHAR,
        created_by VARCHAR,
        update_by VARCHAR,
        last_update VARCHAR
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS medical_document_access (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        document_id INTEGER,
        user_id INTEGER NOT NULL,
        can_edit INTEGER DEFAULT 0,
        can_approve INTEGER DEFAULT 0
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS medical_word_edit_request (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        word_id INTEGER,
        old_source_word TEXT,
        new_source_word TEXT,
        old_description TEXT,
        new_description TEXT,
        old_language TEXT,
        new_language TEXT,
        old_target_word TEXT,
        new_target_word TEXT,
        old_translation_description TEXT,
        new_translation_description TEXT,
        requested_by INTEGER NOT NULL,
        status TEXT DEFAULT 'pending',
        created_at TEXT
    )''')
    # Add missing columns if they don't exist (for existing databases)
    cursor.execute("PRAGMA table_info(medical_word_edit_request)")
    columns = [column[1] for column in cursor.fetchall()]
    if 'old_source_word' not in columns:
        cursor.execute('ALTER TABLE medical_word_edit_request ADD COLUMN old_source_word TEXT')
    if 'new_language' not in columns:
        cursor.execute('ALTER TABLE medical_word_edit_request ADD COLUMN new_language TEXT')
    if 'old_language' not in columns:
        cursor.execute('ALTER TABLE medical_word_edit_request ADD COLUMN old_language TEXT')
    if 'new_target_word' not in columns:
        cursor.execute('ALTER TABLE medical_word_edit_request ADD COLUMN new_target_word TEXT')
    if 'old_target_word' not in columns:
        cursor.execute('ALTER TABLE medical_word_edit_request ADD COLUMN old_target_word TEXT')
    if 'new_translation_description' not in columns:
        cursor.execute('ALTER TABLE medical_word_edit_request ADD COLUMN new_translation_description TEXT')
    if 'old_translation_description' not in columns:
        cursor.execute('ALTER TABLE medical_word_edit_request ADD COLUMN old_translation_description TEXT')
    if 'old_description' not in columns:
        cursor.execute('ALTER TABLE medical_word_edit_request ADD COLUMN old_description TEXT')
    db.commit()


# --- Medical Document CRUD ---
@app.route('/api/medical_documents', methods=['POST'])
def create_medical_document():
    data = request.get_json()
    name = data.get('name')
    owner_id = data.get('owner_id')
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('INSERT INTO medical_document (name, owner_id, created_at) VALUES (?, ?, ?)', (name, owner_id, created_at))
    db.commit()
    return jsonify({'message': 'Medical document created'}), 201

@app.route('/api/medical_documents', methods=['GET'])
def list_medical_documents():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id, name, owner_id, created_at FROM medical_document')
    docs = [{'id': row[0], 'name': row[1], 'owner_id': row[2], 'created_at': row[3]} for row in cursor.fetchall()]
    return jsonify({'documents': docs})

# --- Medical Word CRUD & Approval ---
@app.route('/api/add_medical_word', methods=['POST'])
def add_medical_word_api():
    data = request.get_json()
    source_language = data.get('source_language')
    source_word = data.get('source_word')
    # status is now handled in translation, not source word
    date_created = data.get('date_created')
    created_by = data.get('created_by')
    update_by = data.get('update_by')
    last_update = data.get('last_update')
    language = data.get('language')
    target_word = data.get('target_word')
    description = data.get('description')
    db = get_db()
    cursor = db.cursor()
    # Check if source_word already exists
    cursor.execute('SELECT id FROM medical_word WHERE source_word = ?', (source_word,))
    word_row = cursor.fetchone()
    if word_row:
        word_id = word_row[0]
        # Check if translation for this language already exists
        cursor.execute('SELECT id FROM medical_word_translation WHERE word_id = ? AND language = ?', (word_id, language))
        translation_row = cursor.fetchone()
        if translation_row:
            return jsonify({'message': 'We already have the source and target word'}), 409
        else:
            # Insert translation only
            cursor.execute('''INSERT INTO medical_word_translation (word_id, language, target_word, description, status, date_created, created_by, update_by, last_update) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)''',
                (word_id, language, target_word, description, data.get('status', 'pending'), date_created, created_by, update_by, last_update))
            db.commit()
            return jsonify({'message': 'Translation added to existing source word', 'id': word_id}), 201
    else:
        # Insert new source word
        cursor.execute('''INSERT INTO medical_word (source_language, source_word, date_created, created_by, update_by, last_update) VALUES (?, ?, ?, ?, ?, ?)''',
            (source_language, source_word, date_created, created_by, update_by, last_update))
        word_id = cursor.lastrowid
        # Insert translation
        cursor.execute('''INSERT INTO medical_word_translation (word_id, language, target_word, description, status, date_created, created_by, update_by, last_update) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)''',
            (word_id, language, target_word, description, data.get('status', 'pending'), date_created, created_by, update_by, last_update))
        db.commit()
        return jsonify({'message': 'Medical word and translation added', 'id': word_id}), 201

@app.route('/api/add_medical_word_translation', methods=['POST'])
def add_medical_word_translation_api():
    data = request.get_json()
    word_id = data.get('word_id')
    language = data.get('language')
    target_word = data.get('target_word')
    description = data.get('description')
    date_created = data.get('date_created')
    created_by = data.get('created_by')
    update_by = data.get('update_by')
    last_update = data.get('last_update')
    status = data.get('status', 'pending')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO medical_word_translation (word_id, language, target_word, description, status, date_created, created_by, update_by, last_update) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)''',
                   (word_id, language, target_word, description, status, date_created, created_by, update_by, last_update))
    db.commit()
    return jsonify({'message': 'Medical word translation added', 'id': cursor.lastrowid}), 201
@app.route('/api/medical_words_with_translations', methods=['GET'])
def get_words_with_translations():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''
        SELECT mw.id, mw.source_word, mw.source_language, mw.last_update,
               mwt.id as translation_id, mwt.language, mwt.target_word, mwt.description, mwt.status
        FROM medical_word mw
        LEFT JOIN medical_word_translation mwt ON mw.id = mwt.word_id
        ORDER BY mw.last_update DESC, mw.id DESC
    ''')
    rows = cursor.fetchall()
    words = {}
    for row in rows:
        word_id = row[0]
        source_word = row[1]
        source_language = row[2]
        last_update = row[3]
        translation_id = row[4]
        language = row[5]
        target_word = row[6]
        description = row[7]
        status = row[8]
        if word_id not in words:
            words[word_id] = {
                'id': word_id,
                'source_word': source_word,
                'source_language': source_language,
                'last_update': last_update,
                'translations': []
            }
        if translation_id:
            words[word_id]['translations'].append({
                'id': translation_id,
                'language': language,
                'target_word': target_word,
                'description': description,
                'status': status
            })
    return jsonify({'words': list(words.values())})
@app.route('/api/medical_words/<int:word_id>', methods=['GET'])
def get_medical_word(word_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id, source_word, description, status, created_by, created_at FROM medical_word WHERE id = ?', (word_id,))
    row = cursor.fetchone()
    if not row:
        return jsonify({'error': 'Word not found'}), 404
    word = dict(zip([column[0] for column in cursor.description], row))
    return jsonify({'word': word})
@app.route('/api/medical_words', methods=['POST'])
def add_medical_word():
    data = request.get_json()
    document_id = data.get('document_id')
    source_word = data.get('source_word')
    description = data.get('description')
    created_by = data.get('created_by')
    translation = data.get('translation')
    db = get_db()
    cursor = db.cursor()
    try:
        cursor.execute('INSERT INTO medical_word (document_id, source_word, description, status, created_by, created_at) VALUES (?, ?, ?, ?, ?, ?)',
            (document_id, source_word, description, 'pending', created_by, datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')))
        word_id = cursor.lastrowid
        # If translation is provided, add it
        if translation and translation.get('language') and translation.get('translation'):
            cursor.execute('INSERT INTO medical_word_translation (word_id, language, translation, description) VALUES (?, ?, ?, ?)',
                (word_id, translation['language'], translation['translation'], translation.get('description')))
        db.commit()
        return jsonify({'message': 'Word and translation added, pending approval'}), 201
    except Exception as e:
        return jsonify({'error': str(e)}), 400

@app.route('/api/medical_words/<int:word_id>/approve', methods=['POST'])
def approve_medical_word(word_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('UPDATE medical_word SET status = "approved" WHERE id = ?', (word_id,))
    db.commit()
    return jsonify({'message': 'Word approved'})

@app.route('/api/medical_words/<int:word_id>/edit', methods=['POST'])
def request_edit_medical_word(word_id):
    # Ensure all columns exist in medical_word_edit_request table
    db = get_db()
    cursor = db.cursor()
    
    # Check and add missing columns if they don't exist
    cursor.execute("PRAGMA table_info(medical_word_edit_request)")
    columns = [column[1] for column in cursor.fetchall()]
    
    required_columns = ['old_source_word', 'new_source_word', 'old_description', 'new_description',
                       'old_language', 'new_language', 'old_target_word', 'new_target_word',
                       'old_translation_description', 'new_translation_description']
    
    for col in required_columns:
        if col not in columns:
            try:
                cursor.execute(f'ALTER TABLE medical_word_edit_request ADD COLUMN {col} TEXT')
            except:
                pass
    db.commit()
    
    # Now proceed with the edit request
    data = request.get_json()
    new_source_word = data.get('source_word')
    new_description = data.get('description')
    requested_by = data.get('requested_by')
    translation = data.get('translation')
    
    # Fetch current word data (source_word only - no description in medical_word table)
    cursor.execute('SELECT source_word FROM medical_word WHERE id = ?', (word_id,))
    word_row = cursor.fetchone()
    old_source_word = word_row[0] if word_row else None
    
    # Description is stored in medical_word_translation, not medical_word
    cursor.execute('SELECT language, target_word, description FROM medical_word_translation WHERE word_id = ? LIMIT 1', (word_id,))
    trans_row = cursor.fetchone()
    old_language = trans_row[0] if trans_row else None
    old_target_word = trans_row[1] if trans_row else None
    old_trans_desc = trans_row[2] if trans_row else None
    old_description = None  # Description is not part of medical_word table
    
    # Extract new translation data
    new_lang = None
    new_target_word = None
    new_trans_desc = None
    if translation:
        new_lang = translation.get('language')
        new_target_word = translation.get('target_word')
        new_trans_desc = translation.get('description')
    
    # Check if an edit request already exists for this word_id
    cursor.execute('SELECT id FROM medical_word_edit_request WHERE word_id = ? AND status = "pending"', (word_id,))
    existing_edit = cursor.fetchone()
    
    if existing_edit:
        # Update existing edit request
        cursor.execute('''
            UPDATE medical_word_edit_request 
            SET new_source_word=?, new_description=?, new_language=?, new_target_word=?, new_translation_description=?, 
                old_source_word=?, old_description=?, old_language=?, old_target_word=?, old_translation_description=?,
                requested_by=?, created_at=datetime('now')
            WHERE word_id = ? AND status = "pending"
        ''', (new_source_word, new_description, new_lang, new_target_word, new_trans_desc,
              old_source_word, old_description, old_language, old_target_word, old_trans_desc,
              requested_by, word_id))
    else:
        # Create new edit request
        cursor.execute('''
            INSERT INTO medical_word_edit_request 
            (word_id, new_source_word, new_description, new_language, new_target_word, new_translation_description,
             old_source_word, old_description, old_language, old_target_word, old_translation_description,
             requested_by, status, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, datetime('now'))
        ''', (word_id, new_source_word, new_description, new_lang, new_target_word, new_trans_desc,
              old_source_word, old_description, old_language, old_target_word, old_trans_desc,
              requested_by, 'pending'))
    
    db.commit()
    return jsonify({'message': 'Edit request submitted and pending approval'})

@app.route('/api/medical_words/<int:edit_id>/approve_edit', methods=['POST'])
def approve_edit_medical_word(edit_id):
    data = request.get_json()
    actor_id = data.get('actor_id')
    actor_role = data.get('actor_role')
    actor_email = data.get('actor_email')
    
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT word_id, new_source_word, new_description, new_language, new_target_word, new_translation_description FROM medical_word_edit_request WHERE id = ?', (edit_id,))
    req = cursor.fetchone()
    if not req:
        return jsonify({'error': 'Edit request not found'}), 404
    word_id, new_source_word, new_description, new_language, new_target_word, new_trans_desc = req
    
    # Fetch old word data for logging
    cursor.execute('SELECT source_word FROM medical_word WHERE id = ?', (word_id,))
    old_word = cursor.fetchone()
    old_source_word = old_word[0] if old_word else 'N/A'
    
    # Update medical_word with new source word and set status to approved
    # cursor.execute('UPDATE medical_word SET status=?, last_update=? WHERE id=?', 
    #               ('approved', datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'), word_id))
    
    # Handle translation - check if one exists for this word with the same language
    if new_language and new_target_word:
        cursor.execute('SELECT id FROM medical_word_translation WHERE word_id=? AND language=?', (word_id, new_language))
        existing_trans = cursor.fetchone()
        
        now = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        
        if existing_trans:
            # Update existing translation with same word_id and language
            cursor.execute('UPDATE medical_word_translation SET target_word=?, description=?, status=?, last_update=? WHERE word_id=? AND language=?', 
                          (new_target_word, new_trans_desc, 'approved', now, word_id, new_language))
        else:
            # Insert new translation if it doesn't exist
            cursor.execute('INSERT INTO medical_word_translation (word_id, language, target_word, description, status, date_created, last_update) VALUES (?, ?, ?, ?, ?, ?, ?)',
                          (word_id, new_language, new_target_word, new_trans_desc, 'approved', now, now))
    
    # Delete the edit request after approval (instead of just updating status)
    cursor.execute('DELETE FROM medical_word_edit_request WHERE id=?', (edit_id,))
    db.commit()
    
    # Log the action
    if actor_id and actor_role and actor_email:
        log_action(
            actor_id=actor_id,
            actor_role=actor_role,
            actor_email=actor_email,
            action_type='approve_medical_word_edit',
            action_description=f'Approved edit for medical word: {old_source_word} → {new_source_word}',
            target_id=word_id,
            page='MedicalDocumentGlossary'
        )
    
    return jsonify({'message': 'Edit approved and request deleted'})

@app.route('/api/medical_words/<int:edit_id>/edit_request', methods=['DELETE'])
def delete_edit_request(edit_id):
    data = request.get_json()
    actor_id = data.get('actor_id')
    actor_role = data.get('actor_role')
    actor_email = data.get('actor_email')
    
    db = get_db()
    cursor = db.cursor()
    
    # Fetch edit request data for logging
    cursor.execute('SELECT word_id, new_source_word FROM medical_word_edit_request WHERE id = ?', (edit_id,))
    edit_req = cursor.fetchone()
    word_id = edit_req[0] if edit_req else None
    edit_source_word = edit_req[1] if edit_req else 'N/A'
    
    cursor.execute('DELETE FROM medical_word_edit_request WHERE id = ?', (edit_id,))
    db.commit()
    
    # Log the action
    if actor_id and actor_role and actor_email and word_id:
        log_action(
            actor_id=actor_id,
            actor_role=actor_role,
            actor_email=actor_email,
            action_type='delete_medical_word_edit_request',
            action_description=f'Deleted edit request for medical word: {edit_source_word}',
            target_id=word_id,
            page='MedicalDocumentGlossary'
        )
    
    return jsonify({'message': 'Edit request deleted'}), 200

# --- Medical Word Translation CRUD ---
@app.route('/api/medical_word_translations', methods=['POST'])
def add_medical_word_translation():
    data = request.get_json()
    word_id = data.get('word_id')
    language = data.get('language')
    translation = data.get('translation')
    description = data.get('description')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO medical_word_translation (word_id, language, translation, description) VALUES (?, ?, ?, ?)''',
            (word_id, language, translation, description))
    db.commit()
    return jsonify({'message': 'Translation added'}), 201

# --- List Medical Words with Filtering, Search, Pagination ---
@app.route('/api/medical_words', methods=['GET'])
def list_medical_words():
    document_id = request.args.get('document_id')
    status = request.args.get('status')
    search = request.args.get('search')
    page = int(request.args.get('page', 1))
    page_size = int(request.args.get('page_size', 20))
    db = get_db()
    cursor = db.cursor()
    query = 'SELECT id, source_word, created_by, date_created FROM medical_word WHERE 1=1'
    params = []
    if document_id:
        query += ' AND document_id = ?'
        params.append(document_id)
    # status is not in medical_word table
    if search:
        query += ' AND (source_word LIKE ? )'
        params.append(f'%{search}%')
    query += ' ORDER BY source_word ASC LIMIT ? OFFSET ?'
    params.extend([page_size, (page-1)*page_size])
    cursor.execute(query, params)
    words = [dict(zip([column[0] for column in cursor.description], row)) for row in cursor.fetchall()]
    # Get total count for pagination
    count_query = 'SELECT COUNT(*) FROM medical_word WHERE 1=1'
    count_params = []
    if document_id:
        count_query += ' AND document_id = ?'
        count_params.append(document_id)
    # status is not in medical_word table
    if search:
        count_query += ' AND (source_word LIKE ? )'
        count_params.append(f'%{search}%')
    cursor.execute(count_query, count_params)
    total = cursor.fetchone()[0]
    return jsonify({'words': words, 'total': total, 'page': page, 'page_size': page_size, 'pages': math.ceil(total/page_size)})

# --- List Translations for a Word ---
@app.route('/api/medical_words/<int:word_id>/translations', methods=['GET'])
def list_word_translations(word_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT language, translation, description FROM medical_word_translation WHERE word_id = ?', (word_id,))
    translations = [{'language': row[0], 'translation': row[1], 'description': row[2]} for row in cursor.fetchall()]
    return jsonify({'translations': translations})

# --- Delete all translations for a word ---
@app.route('/api/medical_word_translations/by_word/<int:word_id>', methods=['DELETE'])
def delete_translations_by_word(word_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM medical_word_translation WHERE word_id = ?', (word_id,))
    db.commit()
    return jsonify({'message': 'Translations deleted'}), 200

# --- List Pending Add/Edit Requests ---
@app.route('/api/medical_words/pending', methods=['GET'])
def list_pending_words():
    db = get_db()
    cursor = db.cursor()
    # Fetch pending words by joining with medical_word_translation where status is 'pending'
    cursor.execute('''
        SELECT mw.id, mw.source_word, mw.created_by, mw.date_created, mwt.status
        FROM medical_word mw
        LEFT JOIN medical_word_translation mwt ON mw.id = mwt.word_id
        WHERE mwt.status = "pending"
    ''')
    words = [dict(zip([column[0] for column in cursor.description], row)) for row in cursor.fetchall()]
    return jsonify({'pending_words': words})

@app.route('/api/medical_words/pending_edits', methods=['GET'])
def list_pending_edits():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''
        SELECT 
            mwer.id,
            mwer.word_id,
            mw.source_word,
            mwer.new_source_word,
            mwt.language,
            mwer.new_language,
            mwt.target_word,
            mwer.new_target_word,
            mwt.description,
            mwer.new_translation_description,
            mwer.requested_by,
            mwer.date_created,
            mwer.status
        FROM medical_word_edit_request mwer
        LEFT JOIN medical_word mw ON mwer.word_id = mw.id
        LEFT JOIN medical_word_translation mwt ON mw.id = mwt.word_id
        WHERE mwer.status = "pending"
    ''')
    edits = [dict(zip([column[0] for column in cursor.description], row)) for row in cursor.fetchall()]
    return jsonify({'pending_edits': edits})

# --- Access Control: Grant Access ---
@app.route('/api/medical_document_access', methods=['POST'])
def grant_document_access():
    data = request.get_json()
    document_id = data.get('document_id')
    user_id = data.get('user_id')
    can_edit = int(data.get('can_edit', 0))
    can_approve = int(data.get('can_approve', 0))
    db = get_db()
    cursor = db.cursor()
    cursor.execute('INSERT INTO medical_document_access (document_id, user_id, can_edit, can_approve) VALUES (?, ?, ?, ?)',
        (document_id, user_id, can_edit, can_approve))
    db.commit()
    return jsonify({'message': 'Access granted'})

# --- Access Control: List Access ---
@app.route('/api/medical_document_access/<int:document_id>', methods=['GET'])
def list_document_access(document_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT user_id, can_edit, can_approve FROM medical_document_access WHERE document_id = ?', (document_id,))
    access = [{'user_id': row[0], 'can_edit': bool(row[1]), 'can_approve': bool(row[2])} for row in cursor.fetchall()]
    return jsonify({'access': access})
def create_announcements_table():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS announcements (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        title TEXT NOT NULL,
        content TEXT NOT NULL,
        created_by INTEGER,
        created_at TEXT,
        updated_by INTEGER,
        updated_at TEXT,
        target_roles TEXT,
        target_users TEXT,
        is_active INTEGER DEFAULT 1,
        announcement_type TEXT,
        priority TEXT,
        expiration_date TEXT
    )''')
    db.commit()


# Helper: log trace for announcement actions
def log_announcement_trace(actor_id, actor_email, action_type, action_details, target_id=None, target_email=None):
    db = get_db()
    create_trace_table()
    cursor = db.cursor()
    timestamp = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    cursor.execute('''INSERT INTO trace (actor_id, actor_email, target_id, target_email, action_type, action_details, timestamp)
        VALUES (?, ?, ?, ?, ?, ?, ?)''',
        (actor_id, actor_email, target_id, target_email, action_type, action_details, timestamp))
    db.commit()

# Create announcement
@app.route('/api/announcements', methods=['POST'])
def create_announcement():
    data = request.get_json()
    title = data.get('title')
    content = data.get('content')
    created_by = data.get('created_by')
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    updated_by = created_by
    updated_at = created_at
    target_roles = data.get('target_roles')
    target_users = data.get('target_users')
    target_type = data.get('target_type', 'public')
    # Ensure target_roles/target_users logic
    if target_type == 'public':
        target_roles = ''
        target_users = ''
    elif target_type == 'role':
        target_users = ''
    elif target_type == 'user':
        target_roles = ''
    announcement_type = data.get('announcement_type')
    priority = data.get('priority')
    expiration_date = data.get('expiration_date')
    is_active = data.get('is_active', 1)
    db = get_db()
    create_announcements_table()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO announcements (title, content, created_by, created_at, updated_by, updated_at, target_roles, target_users, is_active, announcement_type, priority, expiration_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)''',
                   (title, content, created_by, created_at, updated_by, updated_at, target_roles, target_users, is_active, announcement_type, priority, expiration_date))
    db.commit()
    announcement_id = cursor.lastrowid
    # Log trace
    actor_email = data.get('actor_email', '')
    log_announcement_trace(created_by, actor_email, 'create', f'Created announcement {announcement_id}', target_id=announcement_id)
    return jsonify({'message': 'Announcement created', 'id': announcement_id}), 201

# List announcements
@app.route('/api/announcements', methods=['GET'])
def list_announcements():
    db = get_db()
    create_announcements_table()
    cursor = db.cursor()
    cursor.execute('SELECT id, title, content, created_by, created_at, updated_by, updated_at, target_roles, target_users, is_active, announcement_type, priority, expiration_date FROM announcements ORDER BY created_at DESC')
    announcements = [
        {
            'id': row[0],
            'title': row[1],
            'content': row[2],
            'created_by': row[3],
            'created_at': row[4],
            'updated_by': row[5],
            'updated_at': row[6],
            'target_roles': row[7],
            'target_users': row[8],
            'is_active': row[9],
            'announcement_type': row[10],
            'priority': row[11],
            'expiration_date': row[12]
        } for row in cursor.fetchall()
    ]
    return jsonify({'announcements': announcements})

# Get single announcement
@app.route('/api/announcements/<int:announcement_id>', methods=['GET'])
def get_announcement(announcement_id):
    db = get_db()
    create_announcements_table()
    cursor = db.cursor()
    cursor.execute('SELECT id, title, content, created_by, created_at, updated_by, updated_at, target_roles, target_users, is_active, announcement_type, priority, expiration_date FROM announcements WHERE id = ?', (announcement_id,))
    row = cursor.fetchone()
    if not row:
        return jsonify({'error': 'Announcement not found'}), 404
    announcement = {
        'id': row[0],
        'title': row[1],
        'content': row[2],
        'created_by': row[3],
        'created_at': row[4],
        'updated_by': row[5],
        'updated_at': row[6],
        'target_roles': row[7],
        'target_users': row[8],
        'is_active': row[9],
        'announcement_type': row[10],
        'priority': row[11],
        'expiration_date': row[12]
    }
    return jsonify(announcement)

# Update announcement
@app.route('/api/announcements/<int:announcement_id>', methods=['PUT'])
def update_announcement(announcement_id):
    data = request.get_json()
    title = data.get('title')
    content = data.get('content')
    updated_by = data.get('updated_by')
    updated_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    target_roles = data.get('target_roles')
    target_users = data.get('target_users')
    is_active = data.get('is_active', 1)
    announcement_type = data.get('announcement_type')
    priority = data.get('priority')
    expiration_date = data.get('expiration_date')
    db = get_db()
    create_announcements_table()
    cursor = db.cursor()
    cursor.execute('''UPDATE announcements SET title=?, content=?, updated_by=?, updated_at=?, target_roles=?, target_users=?, is_active=?, announcement_type=?, priority=?, expiration_date=? WHERE id=?''',
                   (title, content, updated_by, updated_at, target_roles, target_users, is_active, announcement_type, priority, expiration_date, announcement_id))
    db.commit()
    # Log trace
    actor_email = data.get('actor_email', '')
    log_announcement_trace(updated_by, actor_email, 'update', f'Updated announcement {announcement_id}', target_id=announcement_id)
    return jsonify({'message': 'Announcement updated'}), 200

# Delete announcement
@app.route('/api/announcements/<int:announcement_id>', methods=['DELETE'])
def delete_announcement(announcement_id):
    data = request.get_json(force=True, silent=True) or {}
    deleted_by = data.get('deleted_by')
    actor_email = data.get('actor_email', '')
    db = get_db()
    create_announcements_table()
    cursor = db.cursor()
    cursor.execute('DELETE FROM announcements WHERE id = ?', (announcement_id,))
    db.commit()
    # Log trace
    log_announcement_trace(deleted_by, actor_email, 'delete', f'Deleted announcement {announcement_id}', target_id=announcement_id)
    return jsonify({'message': 'Announcement deleted'}), 200

# Clone announcement
@app.route('/api/announcements/<int:announcement_id>/clone', methods=['POST'])
def clone_announcement(announcement_id):
    data = request.get_json()
    cloned_by = data.get('cloned_by')
    actor_email = data.get('actor_email', '')
    db = get_db()
    create_announcements_table()
    cursor = db.cursor()
    cursor.execute('SELECT title, content, target_roles, target_users FROM announcements WHERE id = ?', (announcement_id,))
    row = cursor.fetchone()
    if not row:
        return jsonify({'error': 'Announcement not found'}), 404
    title, content, target_roles, target_users = row
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    cursor.execute('''INSERT INTO announcements (title, content, created_by, created_at, target_roles, target_users) VALUES (?, ?, ?, ?, ?, ?)''',
                   (title + ' (Clone)', content, cloned_by, created_at, target_roles, target_users))
    db.commit()
    new_id = cursor.lastrowid
    # Log trace
    log_announcement_trace(cloned_by, actor_email, 'clone', f'Cloned announcement {announcement_id} to {new_id}', target_id=new_id)
    return jsonify({'message': 'Announcement cloned', 'id': new_id}), 201

# --- Get Roles Endpoint for Announcement Targeting ---
@app.route('/api/roles/list', methods=['GET'])
def get_roles_list():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS roles (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        role_name TEXT,
        redirect_path TEXT,
        description TEXT,
        permissions TEXT,
        created_at TEXT,
        updated_at TEXT
    )''')
    db.commit()
    cursor.execute('SELECT role_name FROM roles')
    roles = [row[0] for row in cursor.fetchall()]
    return jsonify({'roles': roles})

@app.route('/api/interpreter_chart/<int:interpreter_id>', methods=['GET'])
def get_interpreter_chart_by_id(interpreter_id):
    db = get_db()
   
    cursor = db.cursor()
    # Ensure interpreter_chart table exists
    cursor.execute('''CREATE TABLE IF NOT EXISTS interpreter_chart (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        interpreter_id INTEGER,
        interpreter_email TEXT,
        year INTEGER,
        month INTEGER,
        minutes_worked INTEGER DEFAULT 0,
        accept_invoice BOOLEAN DEFAULT 0
    )''')
    db.commit()
    cursor.execute('SELECT year, month, minutes_worked FROM interpreter_chart WHERE interpreter_id = ? AND accept_invoice = 1', (interpreter_id,))
    rows = cursor.fetchall()
    chart = {}
    for year, month, minutes_worked in rows:
        key = f"{year}-{str(month).zfill(2)}"
        chart[key] = minutes_worked
    return jsonify({'chart': chart})


# --- Quiz Endpoints ---
# Create a quiz
@app.route('/api/quizzes', methods=['POST'])
def create_quiz():
    data = request.get_json()
    course_id = data.get('course_id')
    chapter_id = data.get('chapter_id')
    name = data.get('name')
    duration_minutes = data.get('duration_minutes')
    num_questions = data.get('num_questions')
    allowed_attempts = data.get('allowed_attempts')
    unlock_next_on_success = data.get('unlock_next_on_success', 1)
    retry_wait_hours = data.get('retry_wait_hours', 20)
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    # Save the module name directly in module_id column
    module_id = data.get('module_name')  # This is actually the name from the module
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO quiz (course_id, module_id, chapter_id, name, duration_minutes, num_questions, allowed_attempts, unlock_next_on_success, retry_wait_hours, created_at)
                      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)''',
                   (course_id, module_id, chapter_id, name, duration_minutes, num_questions, allowed_attempts, unlock_next_on_success, retry_wait_hours, created_at))
    db.commit()
    return jsonify({'message': 'Quiz created'}), 201

# Get all quizzes (optionally filter by course/chapter)
@app.route('/api/quizzes', methods=['GET'])
def get_quizzes():
    course_id = request.args.get('course_id')
    chapter_id = request.args.get('chapter_id')
    db = get_db()
    cursor = db.cursor()
    query = 'SELECT * FROM quiz WHERE 1=1'
    params = []
    if course_id:
        query += ' AND course_id = ?'
        params.append(course_id)
    if chapter_id:
        query += ' AND chapter_id = ?'
        params.append(chapter_id)
    cursor.execute(query, params)
    quizzes = [dict(zip([column[0] for column in cursor.description], row)) for row in cursor.fetchall()]
    return jsonify({'quizzes': quizzes})

# Update a quiz
@app.route('/api/quizzes/<int:quiz_id>', methods=['PUT'])
def update_quiz(quiz_id):
    data = request.get_json()
    db = get_db()
    cursor = db.cursor()
    fields = ['course_id', 'chapter_id', 'name', 'duration_minutes', 'num_questions', 'allowed_attempts', 'unlock_next_on_success', 'retry_wait_hours']
    updates = []
    params = []
    for field in fields:
        if field in data:
            updates.append(f"{field} = ?")
            params.append(data[field])
    if not updates:
        return jsonify({'error': 'No fields to update'}), 400
    params.append(quiz_id)
    cursor.execute(f'''UPDATE quiz SET {', '.join(updates)} WHERE id = ?''', params)
    db.commit()
    return jsonify({'message': 'Quiz updated'})

# Delete a quiz
@app.route('/api/quizzes/<int:quiz_id>', methods=['DELETE'])
def delete_quiz(quiz_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM quiz WHERE id = ?', (quiz_id,))
    db.commit()
    return jsonify({'message': 'Quiz deleted'})

# --- DEBUG: List all modules ---
@app.route('/api/debug/modules', methods=['GET'])
def debug_list_modules():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id, course_id, name, created_at FROM modules')
    modules = [{'id': row[0], 'course_id': row[1], 'name': row[2], 'created_at': row[3]} for row in cursor.fetchall()]
    return jsonify({'modules': modules})

# --- DEBUG: List all chapters ---
@app.route('/api/debug/chapters', methods=['GET'])
def debug_list_chapters():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id, module_id, name, created_at FROM chapters')
    chapters = [{'id': row[0], 'module_id': row[1], 'name': row[2], 'created_at': row[3]} for row in cursor.fetchall()]
    return jsonify({'chapters': chapters})

# --- Quiz Result Endpoints ---

# Get quiz result for a user and quiz
@app.route('/api/quiz_result', methods=['GET'])
def get_quiz_result():
    user_id = request.args.get('user_id')
    quiz_id = request.args.get('quiz_id')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT * FROM quiz_result WHERE user_id = ? AND quiz_id = ?', (user_id, quiz_id))
    result = cursor.fetchone()
    if result:
        columns = [col[0] for col in cursor.description]
        return jsonify(dict(zip(columns, result)))
    else:
        return jsonify({})

# Create or update quiz result (upsert)
@app.route('/api/quiz_result', methods=['POST'])
def upsert_quiz_result():
    data = request.get_json()
    user_id = data.get('user_id')
    quiz_id = data.get('quiz_id')
    score = data.get('score')
    attempts = data.get('attempts', 1)
    is_passed = 1 if score >= 80 else 0
    last_updated = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id FROM quiz_result WHERE user_id = ? AND quiz_id = ?', (user_id, quiz_id))
    row = cursor.fetchone()
    if row:
        cursor.execute('''UPDATE quiz_result SET score = ?, attempts = ?, is_passed = ?, last_updated = ? WHERE id = ?''',
                       (score, attempts, is_passed, last_updated, row[0]))
    else:
        cursor.execute('''INSERT INTO quiz_result (user_id, quiz_id, score, attempts, is_passed, last_updated) VALUES (?, ?, ?, ?, ?, ?)''',
                       (user_id, quiz_id, score, attempts, is_passed, last_updated))
    db.commit()
    return jsonify({'message': 'Quiz result saved'})

# Get quiz settings by quiz_id
@app.route('/api/quizzes/<int:quiz_id>', methods=['GET'])
def get_quiz_by_id(quiz_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT * FROM quiz WHERE id = ?', (quiz_id,))
    row = cursor.fetchone()
    if row:
        quiz = dict(zip([column[0] for column in cursor.description], row))
        return jsonify({'quiz': quiz})
    else:
        return jsonify({'error': 'Quiz not found'}), 404

def create_tutorial_tables():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS tutorials (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        title TEXT NOT NULL,
        video_url TEXT NOT NULL,
        tutorial_insight TEXT
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS tutorial_assignments (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        tutorial_id INTEGER NOT NULL,
        user_id INTEGER NOT NULL,
        FOREIGN KEY (tutorial_id) REFERENCES tutorials(id),
        FOREIGN KEY (user_id) REFERENCES users(id)
    )''')
    db.commit()

# Ensure tables are created at startup
# --- Create insight_assignment table ---
def create_insight_assignment_table():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS insight_assignment (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        insight_id INTEGER NOT NULL,
        user_id INTEGER NOT NULL,
        assigned_at TEXT NOT NULL,
        created_at TEXT,
        updated_at TEXT,
        updated_by TEXT,
        FOREIGN KEY (insight_id) REFERENCES insight_documentation(id),
        FOREIGN KEY (user_id) REFERENCES users(id_user)
    )''')
    db.commit()

# --- API: List all tutorials with assigned users ---
@app.route('/api/tutorials', methods=['GET'])
def list_tutorials():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''SELECT t.id, t.title, t.video_url, t.tutorial_insight FROM tutorials t''')
    tutorials = []
    for row in cursor.fetchall():
        tut_id, title, video_url, insight = row
        cursor.execute('''SELECT u.id_user, u.nom, u.prenom, u.email FROM tutorial_assignments ta LEFT JOIN users u ON ta.user_id = u.id_user WHERE ta.tutorial_id = ?''', (tut_id,))
        assigned_users = []
        for u in cursor.fetchall():
            uid, nom, prenom, email = u
            name = f"{prenom} {nom}".strip() if prenom or nom else (email.split('@')[0] if email else "Unknown")
            assigned_users.append({'id': uid, 'name': name, 'email': email})
        tutorials.append({
            'id': tut_id,
            'title': title,
            'video_url': video_url,
            'tutorial_insight': insight,
            'assigned_users': assigned_users
        })
    return jsonify({'tutorials': tutorials})

# --- API: Add a new tutorial ---
@app.route('/api/tutorials', methods=['POST'])
def add_tutorial():
    data = request.get_json()
    title = data.get('title')
    video_url = data.get('video_url')
    tutorial_insight = data.get('tutorial_insight')
    assigned_users = data.get('assigned_users', [])
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO tutorials (title, video_url, tutorial_insight) VALUES (?, ?, ?)''', (title, video_url, tutorial_insight))
    tutorial_id = cursor.lastrowid
    for uid in assigned_users:
        cursor.execute('''INSERT INTO tutorial_assignments (tutorial_id, user_id) VALUES (?, ?)''', (tutorial_id, uid))
    db.commit()
    return jsonify({'message': 'Tutorial added', 'id': tutorial_id}), 201

# --- API: Update a tutorial ---
@app.route('/api/tutorials/<int:tutorial_id>', methods=['PUT'])
def update_tutorial(tutorial_id):
    data = request.get_json()
    title = data.get('title')
    video_url = data.get('video_url')
    tutorial_insight = data.get('tutorial_insight')
    assigned_users = data.get('assigned_users', [])
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''UPDATE tutorials SET title=?, video_url=?, tutorial_insight=? WHERE id=?''', (title, video_url, tutorial_insight, tutorial_id))
    # Remove old assignments
    cursor.execute('DELETE FROM tutorial_assignments WHERE tutorial_id=?', (tutorial_id,))
    for uid in assigned_users:
        cursor.execute('''INSERT INTO tutorial_assignments (tutorial_id, user_id) VALUES (?, ?)''', (tutorial_id, uid))
    db.commit()
    return jsonify({'message': 'Tutorial updated'})

# --- API: Delete a tutorial ---
@app.route('/api/tutorials/<int:tutorial_id>', methods=['DELETE'])
def delete_tutorial(tutorial_id):
    db = get_db()
    cursor = db.cursor()
    # Delete assignments first
    cursor.execute('DELETE FROM tutorial_assignments WHERE tutorial_id=?', (tutorial_id,))
    # Delete tutorial
    cursor.execute('DELETE FROM tutorials WHERE id=?', (tutorial_id,))
    db.commit()
    return jsonify({'message': 'Tutorial and its assigment has been deleted'})

# --- API: Get tutorials assigned to a user ---
@app.route('/api/my_tutorials')
def get_my_tutorials():
    user_id = request.args.get('user_id', type=int)
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''
        SELECT t.id, t.title, t.video_url, t.tutorial_insight
        FROM tutorials t
        JOIN tutorial_assignments ta ON t.id = ta.tutorial_id
        WHERE ta.user_id = ?
    ''', (user_id,))
    tutorials = []
    for row in cursor.fetchall():
        tut_id, title, video_url, insight = row
        tutorials.append({
            'id': tut_id,
            'title': title,
            'video_url': video_url,
            'tutorial_insight': insight
        })
    return jsonify({'tutorials': tutorials})


# --- Insight Documentation API ---
@app.route('/api/insights', methods=['GET'])
def list_insights():
    db = get_db()
    cursor = db.cursor()
    # Ensure image_url column exists
    cursor.execute("PRAGMA table_info(insight_documentation)")
    columns = [col[1] for col in cursor.fetchall()]
    if 'image_url' not in columns:
        cursor.execute('ALTER TABLE insight_documentation ADD COLUMN image_url TEXT')
        db.commit()
    cursor.execute('SELECT id, title, content, document_url, image_url, created_at, updated_at FROM insight_documentation ORDER BY created_at DESC')
    insights = [
        {
            'id': row[0],
            'title': row[1],
            'content': row[2],
            'document_url': row[3],
            'image_url': row[4],
            'created_at': row[5],
            'updated_at': row[6]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'insights': insights})

@app.route('/api/insights', methods=['POST'])
def add_insight():
    data = request.get_json()
    title = data.get('title')
    content = data.get('content')
    document_url = data.get('document_url')
    image_url = data.get('image_url')
    now = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    # Treat empty strings as not provided
    content = content if content and content.strip() else None
    document_url = document_url if document_url and document_url.strip() else None
    image_url = image_url if image_url and image_url.strip() else None
    # Only one of content or document_url must be provided
    if (content and document_url) or (not content and not document_url):
        return jsonify({'error': 'Provide either content or document_url, not both.'}), 400
    db = get_db()
    cursor = db.cursor()
    # Ensure image_url column exists
    cursor.execute("PRAGMA table_info(insight_documentation)")
    columns = [col[1] for col in cursor.fetchall()]
    if 'image_url' not in columns:
        cursor.execute('ALTER TABLE insight_documentation ADD COLUMN image_url TEXT')
        db.commit()
    cursor.execute('INSERT INTO insight_documentation (title, content, document_url, image_url, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?)',
                   (title, content, document_url, image_url, now, now))
    db.commit()
    return jsonify({'message': 'Insight added'}), 201

@app.route('/api/insights/<int:insight_id>', methods=['PUT'])
def edit_insight(insight_id):
    data = request.get_json()
    title = data.get('title')
    content = data.get('content')
    document_url = data.get('document_url')
    image_url = data.get('image_url')
    now = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    # Treat empty strings as not provided
    content = content if content and content.strip() else None
    document_url = document_url if document_url and document_url.strip() else None
    image_url = image_url if image_url and image_url.strip() else None
    # Only one of content or document_url must be provided
    if (content and document_url) or (not content and not document_url):
        return jsonify({'error': 'Provide either content or document_url, not both.'}), 400
    db = get_db()
    cursor = db.cursor()
    # Ensure image_url column exists
    cursor.execute("PRAGMA table_info(insight_documentation)")
    columns = [col[1] for col in cursor.fetchall()]
    if 'image_url' not in columns:
        cursor.execute('ALTER TABLE insight_documentation ADD COLUMN image_url TEXT')
        db.commit()
    cursor.execute('UPDATE insight_documentation SET title=?, content=?, document_url=?, image_url=?, updated_at=? WHERE id=?',
                   (title, content, document_url, image_url, now, insight_id))
    db.commit()
    return jsonify({'message': 'Insight updated'})

@app.route('/api/insights/<int:insight_id>', methods=['DELETE'])
def delete_insight(insight_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM insight_documentation WHERE id=?', (insight_id,))
    db.commit()
    return jsonify({'message': 'Insight deleted'})
    

# --- Insight Assignment Endpoints ---
@app.route('/api/insight_assign', methods=['POST'])
def assign_insight():
    data = request.get_json()
    insight_id = data.get('insight_id')
    user_ids = data.get('user_ids', [])
    import datetime as dt
    now = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    db = get_db()
    cursor = db.cursor()
    for user_id in user_ids:
        cursor.execute('INSERT INTO insight_assignment (insight_id, user_id, assigned_at, created_at) VALUES (?, ?, ?, ?)',
                       (insight_id, user_id, now, now))
    db.commit()
    return jsonify({'message': 'Insight assigned'}), 201

@app.route('/api/insight_assign/<int:insight_id>', methods=['GET'])
def get_insight_assignments(insight_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''SELECT u.id_user, u.nom, u.prenom, u.email FROM insight_assignment ia LEFT JOIN users u ON ia.user_id = u.id_user WHERE ia.insight_id = ?''', (insight_id,))
    assigned_users = []
    for u in cursor.fetchall():
        uid, nom, prenom, email = u
        if uid is None:
            continue  # Skip assignments to non-existent users
        name = f"{prenom} {nom}".strip() if prenom or nom else (email.split('@')[0] if email else "Unknown")
        assigned_users.append({'id': uid, 'name': name, 'email': email})
    return jsonify({'assigned_users': assigned_users})

@app.route('/api/insight_assign/<int:insight_id>/<int:user_id>', methods=['DELETE'])
def remove_insight_assignment(insight_id, user_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM insight_assignment WHERE insight_id=? AND user_id=?', (insight_id, user_id))
    db.commit()
    return jsonify({'message': 'Assignment removed'})


def create_medical_glossary_tables():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS medical_word (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        source_language VARCHAR,
        source_word VARCHAR,
        date_created VARCHAR,
        created_by VARCHAR,
        update_by VARCHAR,
        last_update VARCHAR
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS medical_word_translation (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        word_id INTEGER REFERENCES medical_word(id),
        target_language VARCHAR,
        target_word VARCHAR,
        description VARCHAR,
        date_created VARCHAR,
        created_by VARCHAR
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS medical_word_description (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        word_id INTEGER REFERENCES medical_word(id),
        description VARCHAR,
        date_created VARCHAR,
        created_by VARCHAR
    )''')
    db.commit()


@app.route('/api/medical_words', methods=['GET'])
def get_medical_words():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT * FROM medical_word')
    words = [dict(zip([column[0] for column in cursor.description], row)) for row in cursor.fetchall()]
    for word in words:
        cursor.execute('SELECT target_language, target_word, description FROM medical_word_translation WHERE word_id = ?', (word['id'],))
        word['translations'] = [dict(zip([column[0] for column in cursor.description], row)) for row in cursor.fetchall()]
    return jsonify({'words': words})

@app.route('/api/medical_word_descriptions', methods=['POST'])
def add_medical_word_description():
    data = request.get_json()
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''INSERT INTO medical_word_description (word_id, description, date_created, created_by)
                      VALUES (?, ?, ?, ?)''',
                   (data['word_id'], data['description'], datetime.now().strftime('%Y-%m-%d %H:%M:%S'), data['created_by']))
    db.commit()
    return jsonify({'message': 'Description added'}), 201

@app.route('/api/medical_word_descriptions/<int:word_id>', methods=['GET'])
def get_medical_word_description(word_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT description FROM medical_word_description WHERE word_id = ?', (word_id,))
    desc = cursor.fetchone()
    return jsonify({'description': desc[0] if desc else None})

@app.route('/api/medical_words_with_translations/<int:word_id>', methods=['GET'])
def get_medical_word_with_translations(word_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''
        SELECT mw.id, mw.source_word, mw.source_language, mwt.id, mwt.language, mwt.target_word, mwt.description
        FROM medical_word mw
        LEFT JOIN medical_word_translation mwt ON mw.id = mwt.word_id
        WHERE mw.id = ?
    ''', (word_id,))
    rows = cursor.fetchall()
    if not rows:
        return jsonify({'error': 'Word not found'}), 404
    word = {
        'id': rows[0][0],
        'source_word': rows[0][1],
        'source_language': rows[0][2],
        'translations': []
    }
    for row in rows:
        translation_id = row[3]
        if translation_id is not None:
            word['translations'].append({
                'id': row[3],
                'language': row[4],
                'target_word': row[5],
                'description': row[6]
            })
    return jsonify({'word': word})

@app.route('/api/medical_words/<int:word_id>', methods=['DELETE'])
def delete_medical_word(word_id):
    data = request.get_json()
    actor_id = data.get('actor_id') if data else None
    actor_role = data.get('actor_role') if data else None
    actor_email = data.get('actor_email') if data else None
    source_word = data.get('source_word') if data else 'N/A'
    
    db = get_db()
    cursor = db.cursor()
    
    # Fetch word data for logging if not provided
    if not source_word or source_word == 'N/A':
        cursor.execute('SELECT source_word FROM medical_word WHERE id = ?', (word_id,))
        word = cursor.fetchone()
        source_word = word[0] if word else 'N/A'
    
    # Delete translations first
    cursor.execute('DELETE FROM medical_word_translation WHERE word_id = ?', (word_id,))
    # Then delete the medical word
    cursor.execute('DELETE FROM medical_word WHERE id = ?', (word_id,))
    db.commit()
    
    # Log the action
    if actor_id and actor_role and actor_email:
        log_action(
            actor_id=actor_id,
            actor_role=actor_role,
            actor_email=actor_email,
            action_type='delete_medical_word',
            action_description=f'Deleted medical word: {source_word}',
            target_id=word_id,
            page='MedicalDocumentGlossary'
        )
    
    return jsonify({'message': 'Medical word and all translations deleted'}), 200

@app.route('/api/medical_words/<int:word_id>', methods=['PUT'])
def update_medical_word_source(word_id):
    data = request.get_json()
    new_source_word = data.get('source_word')
    new_source_language = data.get('source_language')
    actor_id = data.get('actor_id')
    actor_role = data.get('actor_role')
    actor_email = data.get('actor_email')
    
    db = get_db()
    cursor = db.cursor()
    
    # Fetch old source word and language for logging
    cursor.execute('SELECT source_word, source_language FROM medical_word WHERE id = ?', (word_id,))
    old_word = cursor.fetchone()
    if not old_word:
        return jsonify({'error': 'Medical word not found'}), 404
    
    old_source_word = old_word[0]
    old_source_language = old_word[1]
    
    # Check if the new source word already exists (and it's not the same word)
    if new_source_word != old_source_word:
        cursor.execute('SELECT id FROM medical_word WHERE source_word = ?', (new_source_word,))
        existing_word = cursor.fetchone()
        if existing_word:
            return jsonify({'error': f'Source word "{new_source_word}" already exists. Please use a different word.'}), 409
    
    # Update the source word and language
    if new_source_language:
        cursor.execute('UPDATE medical_word SET source_word = ?, source_language = ? WHERE id = ?', 
                      (new_source_word, new_source_language, word_id))
    else:
        cursor.execute('UPDATE medical_word SET source_word = ? WHERE id = ?', 
                      (new_source_word, word_id))
    db.commit()
    
    # Log the action
    if actor_id and actor_role and actor_email:
        description = f'Updated source word: {old_source_word} → {new_source_word}'
        if new_source_language and old_source_language != new_source_language:
            description += f' (Language: {old_source_language} → {new_source_language})'
        log_action(
            actor_id=actor_id,
            actor_role=actor_role,
            actor_email=actor_email,
            action_type='update_medical_word_source',
            action_description=description,
            target_id=word_id,
            page='MedicalDocumentGlossary'
        )
    
    return jsonify({'message': 'Source word and language updated successfully'}), 200

# --- Endpoint to fetch approved translations for glossary tab ---
@app.route('/api/medical_word_translations', methods=['GET'])
def list_approved_translations():
    status = request.args.get('status')
    db = get_db()
    cursor = db.cursor()
    query = '''
        SELECT mwt.id, mwt.word_id, mwt.language, mwt.target_word, mwt.description, mwt.status, mwt.last_update,
               mw.source_word, mw.source_language
        FROM medical_word_translation mwt
        LEFT JOIN medical_word mw ON mw.id = mwt.word_id
        WHERE 1=1
    '''
    params = []
    if status:
        query += ' AND mwt.status = ?'
        params.append(status)
    cursor.execute(query, params)
    translations = [
        {
            'id': row[0],
            'word_id': row[1],
            'language': row[2],
            'target_word': row[3],
            'description': row[4],
            'status': row[5],
            'last_update': row[6],
            'source_word': row[7],
            'source_language': row[8]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'translations': translations})

# --- Certificate Verification Endpoint ---
@app.route('/api/verify/<cert_type>/<cerf_id>', methods=['GET'])
def verify_certificate(cert_type, cerf_id):
    db = get_db()
    cursor = db.cursor()
    # Fetch certificate by cerf_id and type
    cursor.execute('''SELECT * FROM certificate WHERE cerf_id = ? AND certificate_type = ? AND is_active = 1''', (cerf_id, cert_type))
    cert = cursor.fetchone()
    if not cert:
        return jsonify({'error': 'Certificate not found'}), 404

    # Fetch user info
    user_id = cert[1]  # Assuming user_id is at index 1
    cursor.execute('SELECT nom, prenom, email, language, foto FROM users WHERE id_user = ?', (user_id,))
    user = cursor.fetchone()
    if user:
        cert_user = {
            'nom': user[0],
            'prenom': user[1],
            'email': user[2],
            'language': user[3],
            'foto': user[4]
        }
    else:
        cert_user = {}

    # Profile image filename logic (simulate folder fallback)
    profile_image = cert_user.get('foto') or 'default-avatar.png'
    # In frontend, try: /public/images/profile/, /public/images/company/, /public/images/default/
    # Here, just return filename; frontend can handle folder logic

    # Calculate expiration
    date_validity = cert[16]  # Assuming date_validity is at index 16
    is_expired = False
    expiration_message = ''
    days_until_expiry = None
    if date_validity:
        try:
            expiry_date = datetime.strptime(date_validity, '%Y-%m-%d %H:%M:%S')
            current_date = datetime.now()
            if current_date > expiry_date:
                is_expired = True
                expiration_message = f"This certificate expired on {expiry_date.strftime('%B %d, %Y')}"
            else:
                days_until_expiry = (expiry_date - current_date).days
                if days_until_expiry <= 90:
                    expiration_message = f"This certificate will expire in {days_until_expiry} days on {expiry_date.strftime('%B %d, %Y')}"
        except Exception:
            pass

    # Build certificate dict with extra fields
    cert_dict = dict(zip([column[0] for column in cursor.description], cert))
    cert_dict['is_active'] = cert_dict.get('is_active')
    cert_dict['certificate_text'] = cert_dict.get('certificate_text')
    cert_dict['profile_image'] = profile_image

    # Add course/subject info for each certificate type
    course_content = []
    subject_list = []
    medical_subjects = []
    if cert_type == 'medical':
        # Simulate medical subject flags and info texts (v1-v11)
        # These should be columns in certificate table: v1, v2, ..., v11
        # And info texts: v1_text, ..., v11_text
        for i in range(1, 12):
            flag = cert_dict.get(f'v{i}', 0)
            text = cert_dict.get(f'v{i}_text', f'Subject {i}')
            medical_subjects.append({'title': text, 'completed': bool(flag)})
        subject_list = [
            'Health Care', 'OBGYN', 'Neurology', 'Cardiology', 'Dental', 'Emergency', 'Gynecology', 'Ophtalmology', 'Orthopedic',
            'Importance to take Notes', 'Key Words', 'Key Phrases', 'Symbols', 'Online portal Setting', 'Dress code'
        ]
        course_content = medical_subjects
    elif cert_type == 'hipaa':
        subject_list = [
            'HIPAA Privacy Rule Overview', 'Protected Health Information (PHI)', 'Minimum Necessary Standard', 'Individual Rights',
            'HIPAA Security Rule', 'Administrative Safeguards', 'Physical Safeguards', 'Technical Safeguards',
            'Breach Notification Requirements', 'Breach Assessment', 'Notification Procedures',
            'Business Associate Requirements', 'BAA Compliance', 'Subcontractor Management',
            'Enforcement and Penalties', 'OCR Investigations', 'Civil Monetary Penalties'
        ]
        course_content = [
            {'title': 'HIPAA Privacy Rule Overview', 'completed': True},
            {'title': 'HIPAA Security Rule', 'completed': True},
            {'title': 'Breach Notification Requirements', 'completed': True},
            {'title': 'Business Associate Requirements', 'completed': True},
            {'title': 'Enforcement and Penalties', 'completed': True}
        ]
    elif cert_type == 'legal':
        subject_list = [
            'Legal System Overview', 'Court Structure', 'Legal Procedures', 'Due Process',
            'Legal Terminology', 'Criminal Law Terms', 'Civil Law Terms', 'Immigration Law Terms',
            'Court Procedures', 'Arraignment Process', 'Trial Procedures', 'Sentencing Guidelines',
            'Professional Ethics', 'Interpreter Code of Ethics', 'Confidentiality Requirements', 'Impartiality Standards',
            'Interpretation Techniques', 'Consecutive Interpretation', 'Simultaneous Interpretation', 'Sight Translation'
        ]
        course_content = [
            {'title': 'Legal System Overview', 'completed': True},
            {'title': 'Legal Terminology', 'completed': True},
            {'title': 'Court Procedures', 'completed': True},
            {'title': 'Professional Ethics', 'completed': True},
            {'title': 'Interpretation Techniques', 'completed': True}
        ]

    # Add language info if available (simulate MI_langue table)
    cursor.execute('SELECT language_from, language_to FROM MI_langue WHERE id_user = ?', (user_id,))
    lang_row = cursor.fetchone()
    language_info = {}
    if lang_row:
        language_info = {
            'language_from': lang_row[0],
            'language_to': lang_row[1]
        }

    response = {
        'certificate': cert_dict,
        'user': cert_user,
        'is_expired': is_expired,
        'expiration_message': expiration_message,
        'days_until_expiry': days_until_expiry,
        'course_content': course_content,
        'subject_list': subject_list,
        'language_info': language_info
    }
    return jsonify(response)

@app.route('/api/certificates', methods=['GET'])
def get_certificates():
    user_id = request.args.get('user_id')
    cerf_id = request.args.get('cerf_id')
    db = get_db()
    cursor = db.cursor()
    # Build query with optional user_id and cerf_id filter
    query = '''
        SELECT c.*, u.prenom, u.nom
        FROM certificate c
        LEFT JOIN users u ON c.user_id = u.id_user
    '''
    filters = []
    params = []
    if user_id:
        filters.append('c.user_id = ?')
        params.append(user_id)
    if cerf_id:
        filters.append('c.cerf_id = ?')
        params.append(cerf_id)
    if filters:
        query += ' WHERE ' + ' AND '.join(filters)
    cursor.execute(query, params)
    rows = cursor.fetchall()
    certificates = []
    for row in rows:
        cert = dict(zip([column[0] for column in cursor.description], row))
        # Add fullname field
        cert['fullname'] = f"{cert.get('prenom', '')} {cert.get('nom', '')}".strip()
        # Only keep selected fields for display
        cert_display = {
            'fullname': cert['fullname'],
            'qr_code_filename': cert.get('qr_code_filename'),
            'cerf_id': cert.get('cerf_id'),
            'date_validity': cert.get('date_validity'),
            'language_from': cert.get('language_from'),
            'language_to': cert.get('language_to'),
            'certificate_type': cert.get('certificate_type'),
            'user_id': cert.get('user_id'),
            'created_at': cert.get('created_at'),
            'is_active': cert.get('is_active'),
            'certificate_text': cert.get('certificate_text'),
            # Add other fields as needed
        }
        certificates.append(cert_display)
    return jsonify(certificates)

# --- Certificate Creation Endpoint ---
@app.route('/api/certificates', methods=['POST'])
def create_certificates():
    data = request.get_json()
    user_id = data.get('fullname')
    print('DEBUG: Received user_id for certificate:', user_id)
    cert_types = data.get('cert_types', [])
    cerf_id = data.get('cerf_id')
    if not cerf_id:
        return jsonify({'error': 'Certificate number (cerf_id) is required.'}), 400
    date_validity = data.get('date_validity')
    certificate_text = data.get('texte')
    is_active = int(bool(data.get('is_active')))
    language_from = data.get('language_from')
    language_to = data.get('language_to')
    # Fields 1-11
    fields = [int(bool(data.get(f'field_{i+1}'))) for i in range(11)]
    # Profile picture flag (expects 0 or 1 from frontend, not a file upload)
    use_profile_picture = int(data.get('use_profile_picture', 0))

    # Ensure certificate_text is always present
    certificate_text = data.get('certificate_text', certificate_text)
    db = get_db()
    cursor = db.cursor()
    upserted_ids = []
    # Build QR code URL for verification
    import qrcode
    from PIL import Image
    def build_qr_code_url(cert_type, cerf_id):
        # Use the main React verification page for QR code
        # The PUBLIC_URL should be set in your frontend environment
        # Example: https://school.makeitservices.org/verify/valid_certification.js?cerf_id=xxx&cert_type=yyy
        base_url = os.environ.get('PUBLIC_URL', 'https://school.makeitservices.org')
        return f"{base_url}/verify/valid_certification.js?cerf_id={cerf_id}"

    def generate_qr_code_image(url, filename):
        qr = qrcode.QRCode(
            version=1,
            error_correction=qrcode.constants.ERROR_CORRECT_L,
            box_size=10,
            border=4,
        )
        qr.add_data(url)
        qr.make(fit=True)
        img = qr.make_image(fill_color="black", back_color="white")
        save_dir = os.path.join('public', 'images')
        os.makedirs(save_dir, exist_ok=True)
        save_path = os.path.join(save_dir, filename)
        img.save(save_path)
        return f"/images/{filename}"
    for cert_type in cert_types:
        cert_medical = int(cert_type == 'medical')
        cert_hipaa = int(cert_type == 'hipaa')
        cert_legal = int(cert_type == 'legal')
        html_filename = f"cert_{cerf_id}_{cert_type}.html" if cerf_id else None
        qr_url = build_qr_code_url(cert_type, cerf_id)
        qr_img_filename = f"qr_{cerf_id}_{cert_type}.png"
        qr_code_filename = generate_qr_code_image(qr_url, qr_img_filename)
        # Check if certificate exists
        cursor.execute('''SELECT id FROM certificate WHERE user_id = ? AND certificate_type = ? AND cerf_id = ?''', (user_id, cert_type, cerf_id))
        existing = cursor.fetchone()
        if existing:
            # Update existing certificate
            cursor.execute('''
                UPDATE certificate SET
                    qr_code_filename = ?, html_filename = ?, pdf_filename = ?, updated_at = ?,
                    field_1 = ?, field_2 = ?, field_3 = ?, field_4 = ?, field_5 = ?, field_6 = ?, field_7 = ?, field_8 = ?, field_9 = ?, field_10 = ?, field_11 = ?,
                    certificate_medical_interpreter = ?, certificate_hipaa_compliance = ?, certificate_legal_interpreter = ?,
                    date_validity = ?, certificate_text = ?, is_active = ?, language_from = ?, language_to = ?, use_profile_picture = ?
                WHERE id = ?
            ''', (
                qr_code_filename, html_filename, None, datetime.datetime.now(),
                *fields,
                cert_medical, cert_hipaa, cert_legal,
                date_validity, certificate_text, is_active, language_from, language_to, use_profile_picture,
                existing[0]
            ))
            upserted_ids.append(existing[0])
        else:
            # Insert new certificate
            cursor.execute('''
                INSERT INTO certificate (
                    user_id, certificate_type, cerf_id, qr_code_filename, html_filename, pdf_filename, created_at, updated_at,
                    field_1, field_2, field_3, field_4, field_5, field_6, field_7, field_8, field_9, field_10, field_11,
                    certificate_medical_interpreter, certificate_hipaa_compliance, certificate_legal_interpreter,
                    date_validity, certificate_text, is_active, language_from, language_to, use_profile_picture
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ''', (
                user_id, cert_type, cerf_id, qr_code_filename, html_filename, None, datetime.datetime.now(), datetime.datetime.now(),
                *fields,
                cert_medical, cert_hipaa, cert_legal,
                date_validity, certificate_text, is_active, language_from, language_to, use_profile_picture
            ))
            upserted_ids.append(cursor.lastrowid)
    db.commit()
    return jsonify({'message': f'{len(upserted_ids)} certificate(s) upserted', 'ids': upserted_ids}), 201

def get_db():
    db_path = os.path.join(os.path.dirname(__file__), '../makeitse_companies.db')
    conn = sqlite3.connect(db_path)
    conn.row_factory = sqlite3.Row
    return conn

# Visitor logging endpoint
@app.route('/api/visit', methods=['POST'])
def log_visit():
    data = request.get_json()
    site_url = data.get('site_url', 'https://makeitservices.org/')
    visitor_id = data.get('visitor_id')
    visitor_name = data.get('visitor_name')
    visitor_email = data.get('visitor_email')
    visitor_ip = request.remote_addr
    country = data.get('country', '')

    db = get_db()
    cursor = db.cursor()
    cursor.execute("SELECT id FROM site_visits WHERE site_url=? AND visitor_id=?", (site_url, visitor_id))
    if not cursor.fetchone():
        visit_datetime = datetime.datetime.now().strftime("%Y-%m-%d (%a) %H:%M:%S")
        cursor.execute(
            "INSERT INTO site_visits (site_url, visit_datetime, visitor_id, visitor_name, visitor_email, country) VALUES (?, ?, ?, ?, ?, ?)",
            (site_url, visit_datetime, visitor_id, visitor_name, visitor_email, country)
        )
        db.commit()
    return jsonify({'status': 'ok'})

# Partners list endpoint
@app.route('/api/partners', methods=['GET'])
def get_partners():
    db = get_db()
    cursor = db.cursor()
    cursor.execute("SELECT * FROM MI_partneer WHERE fullname !='' AND photo !='' AND is_active = '1' ORDER BY id DESC")
    partners = [dict(row) for row in cursor.fetchall()]
    return jsonify({'partners': partners})

# --- Profile Image Upload Endpoint ---
@app.route('/api/users/upload-profile-image', methods=['POST'])
def upload_profile_image():
    if 'image' not in request.files:
        return jsonify({'error': 'No file part'}), 400
    file = request.files['image']
    id_user = request.form.get('id_user')
    if file.filename == '':
        return jsonify({'error': 'No selected file'}), 400
    allowed_ext = {'png', 'jpg', 'jpeg', 'gif'}
    ext = file.filename.rsplit('.', 1)[-1].lower()
    if ext not in allowed_ext:
        return jsonify({'error': 'Invalid file type'}), 400
    filename = secure_filename(file.filename)
    save_dir = os.path.join(os.path.dirname(__file__), 'public', 'profile')
    os.makedirs(save_dir, exist_ok=True)
    save_path = os.path.join(save_dir, filename)
    file.save(save_path)
    image_path = f'/profile/{filename}'
    # Update user's img in DB
    if id_user:
        db = get_db()
        cursor = db.cursor()
        cursor.execute('UPDATE users SET img = ? WHERE id_user = ?', (image_path, id_user))
        db.commit()
    return jsonify({'imagePath': image_path})

# Record site visit endpoint
@app.route('/api/record-visit', methods=['POST', 'OPTIONS'])
def record_visit():
    if request.method == 'OPTIONS':
        return jsonify({'message': 'CORS preflight'}), 200
    try:
        data = request.get_json()

        # Required fields
        site_url = data.get('site_url', '')
        page_title = data.get('page_title', '')

        # Optional visitor info
        visitor_name = data.get('visitor_name', '')
        visitor_email = (data.get('visitor_email') or '').lower().strip()  # Normalize email
        visitor_id = data.get('visitor_id', '')

        # Get additional info from request
        browser = request.headers.get('User-Agent', '')
        ip_address = request.remote_addr
        country = request.headers.get('CF-IPCountry', '')  # If using Cloudflare
        referrer = request.headers.get('Referer', '')
        device = 'mobile' if 'mobile' in browser.lower() else 'desktop'
        visit_datetime = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')

        db = get_db()
        cursor = db.cursor()

        # Ensure site_visits table exists
        cursor.execute('''CREATE TABLE IF NOT EXISTS site_visits (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            site_url TEXT,
            visit_datetime TEXT,
            visitor_name TEXT,
            visitor_email TEXT,
            visitor_id TEXT,
            country TEXT,
            browser TEXT,
            device TEXT,
            referrer TEXT,
            ip_address TEXT,
            page_title TEXT
        )''')

        cursor.execute('''
            INSERT INTO site_visits (
                site_url, visit_datetime, visitor_name, visitor_email,
                visitor_id, country, browser, device, referrer,
                ip_address, page_title
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ''', (
            site_url, visit_datetime, visitor_name, visitor_email,
            visitor_id, country, browser, device, referrer,
            ip_address, page_title
        ))

        db.commit()

        return jsonify({
            "message": "Visit recorded successfully",
            "success": True
        }), 200
    except Exception as e:
        print(f"Error recording visit: {str(e)}")
        return jsonify({"error": str(e)}), 500

# List and filter site visits
@app.route('/api/site-visits', methods=['GET'])
def api_list_site_visits():
    db = get_db()
    cursor = db.cursor()
    # Filtering params
    country = request.args.get('country', '').strip()
    device = request.args.get('device', '').strip()
    date = request.args.get('date', '').strip()  # format: YYYY-MM-DD
    query = 'SELECT * FROM site_visits WHERE 1=1'
    params = []
    if country:
        query += ' AND country = ?'
        params.append(country)
    if device:
        query += ' AND device = ?'
        params.append(device)
    if date:
        query += ' AND visit_datetime LIKE ?'
        params.append(f'{date}%')
    query += ' ORDER BY visit_datetime DESC'
    cursor.execute(query, params)
    visits = [dict(zip([col[0] for col in cursor.description], row)) for row in cursor.fetchall()]
    return jsonify({'site_visits': visits})

# Delete single or multiple site visits
@app.route('/api/site-visits/delete', methods=['POST'])
def api_delete_site_visits():
    data = request.get_json()
    ids = data.get('ids', [])
    if not isinstance(ids, list):
        ids = [ids]
    if not ids:
        return jsonify({'error': 'No IDs provided'}), 400
    db = get_db()
    cursor = db.cursor()
    qmarks = ','.join(['?'] * len(ids))
    cursor.execute(f'DELETE FROM site_visits WHERE id IN ({qmarks})', ids)
    db.commit()
    return jsonify({'deleted': ids})


# --- Action Logging ---
def log_action(actor_id, actor_role, actor_email, action_type, action_description, target_id=None, target_role=None, target_email=None, page=None):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''
        INSERT INTO action_logs (actor_id, actor_role, actor_email, action_type, action_description, target_id, target_role, target_email, page, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, datetime('now'))
    ''', (actor_id, actor_role, actor_email, action_type, action_description, target_id, target_role, target_email, page or request.path))
    db.commit()

# API endpoint to log an action
@app.route('/api/log_action', methods=['POST'])
def api_log_action():
    data = request.get_json()
    print("[DEBUG] /api/log_action received:", data)
    actor_id = data.get('actor_id')
    actor_role = data.get('actor_role')
    actor_email = data.get('actor_email')
    action_type = data.get('action_type')
    action_description = data.get('action_description')
    target_id = data.get('target_id')
    target_role = data.get('target_role')
    target_email = data.get('target_email')
    page = data.get('page')
    if not (actor_id and actor_role and actor_email and action_type):
        print(f"[ERROR] Missing required fields: actor_id={actor_id}, actor_role={actor_role}, actor_email={actor_email}, action_type={action_type}")
        return jsonify({'error': 'Missing required fields'}), 400
    log_action(actor_id, actor_role, actor_email, action_type, action_description, target_id, target_role, target_email, page)
    return jsonify({'message': 'Action logged'}), 201

# --- Recent Actions API ---

def time_ago(dt):
    now = datetime.datetime.utcnow()
    diff = now - dt
    
    # Calculate total seconds for easier comparison
    total_seconds = diff.total_seconds()
    
    # Convert to various time units
    years = int(total_seconds // (365.25 * 24 * 3600))
    months = int(total_seconds // (30.44 * 24 * 3600))  # Average month length
    days = diff.days
    hours = int(total_seconds // 3600)
    minutes = int(total_seconds // 60)
    
    if years > 0:
        return f"{years} year{'s' if years > 1 else ''} ago"
    if months > 0:
        return f"{months} month{'s' if months > 1 else ''} ago"
    if days > 0:
        return f"{days} day{'s' if days > 1 else ''} ago"
    if hours > 0:
        return f"{hours} hour{'s' if hours > 1 else ''} ago"
    if minutes > 0:
        return f"{minutes} minute{'s' if minutes > 1 else ''} ago"
    return "just now"

@app.route('/api/recent-actions', methods=['GET'])
def get_recent_actions():
    user_id = request.args.get('user_id')
    role = request.args.get('role')
    db = get_db()
    cursor = db.cursor()
    if role == 'Administrator':
        cursor.execute('''SELECT * FROM action_logs WHERE actor_id = ? ORDER BY created_at DESC LIMIT 15''', (user_id,))
    else:
        cursor.execute('''SELECT * FROM action_logs WHERE actor_id = ? OR target_id = ? ORDER BY created_at DESC LIMIT 10''', (user_id, user_id))
    rows = cursor.fetchall()
    columns = [desc[0] for desc in cursor.description]
    actions = []
    for row in rows:
        action = dict(zip(columns, row))
        # Parse created_at and add time_ago
        try:
            dt = datetime.datetime.strptime(action['created_at'], '%Y-%m-%d %H:%M:%S')
            action['time_ago'] = time_ago(dt)
        except Exception:
            action['time_ago'] = action['created_at']
        actions.append(action)
    return jsonify({'actions': actions})

# --- Logout Endpoint ---
@app.route('/api/logout', methods=['POST'])
def api_logout():
    data = request.get_json()
    user_id = data.get('user_id')
    id_user = data.get('id_user')
    email = data.get('email')
    role = data.get('role')
    if not user_id:
        return jsonify({'error': 'Missing user_id'}), 400
    db = get_db()
    cursor = db.cursor()
    # Set enligne to 0
    cursor.execute('UPDATE users SET enligne = 0 WHERE id_user = ?', (user_id,))
    db.commit()
    # Log the logout action using the helper for full columns
    log_action(
        actor_id=user_id,
        actor_role=role or '',
        actor_email=email or '',
        action_type='logout',
        action_description='User logged out',
        target_id=None,
        target_role=None,
        target_email=None,
        page=data.get('page')
    )
    return jsonify({'message': 'User logged out'}), 200


# --- never remove that amymore ---

# --- News & Blog API Endpoint ---
@app.route('/api/news_blog', methods=['GET'])
def get_news_blog():
    db = get_db()
    cursor = db.cursor()
    # Use actual columns from your tables
    # NEWS: field1=id, field3=title, field4=content/description, field11=date_created
    cursor.execute('SELECT field1, field3, field4, field11 FROM news WHERE field1 != "id"')
    news = []
    for row in cursor.fetchall():
        content = row[2] if row[2] is not None else ''
        date = row[3] if row[3] is not None else ''
        summary = content[:80] + ('...' if len(content) > 80 else '')
        news.append({
            'id': row[0],
            'title': row[1],
            'content': content,
            'summary': summary,
            'date': date,
            'type': 'news'
        })
    # BLOG: field1=id, field3=title, field4=content/description, field11=date_created
    cursor.execute('SELECT field1, field3, field4, field11 FROM blog WHERE field1 != "id"')
    blog = []
    for row in cursor.fetchall():
        content = row[2] if row[2] is not None else ''
        date = row[3] if row[3] is not None else ''
        summary = content[:80] + ('...' if len(content) > 80 else '')
        blog.append({
            'id': row[0],
            'title': row[1],
            'content': content,
            'summary': summary,
            'date': date,
            'type': 'blog'
        })
    # Combine and sort by date descending
    import datetime
    def parse_date(d):
        try:
            return datetime.datetime.strptime(d, '%Y-%m-%d %H:%M:%S')
        except Exception:
            try:
                return datetime.datetime.strptime(d, '%Y-%m-%d')
            except Exception:
                return datetime.datetime.min
    combined = news + blog
    combined.sort(key=lambda x: parse_date(x['date']) if x['date'] else datetime.datetime.min, reverse=True)
    return jsonify(combined)

# --- Get user by id_user for profile page ---
@app.route('/api/users/by-iduser/<int:id_user>', methods=['GET'])
def get_user_by_iduser(id_user):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''SELECT id_user, email, mot_de_passe, role, code, sexe, language, invoice, nom, prenom, rates, tel, adresse, country, img, about FROM users WHERE id_user = ?''', (id_user,))
    row = cursor.fetchone()
    if not row:
        return jsonify({'error': 'User not found'}), 404
    user = {
        'id_user': row[0],
        'email': row[1],
        'mot_de_passe': row[2],
        'role': row[3],
        'code': row[4],
        'sexe': row[5],
        'language': row[6],
        'invoice': row[7],
        'nom': row[8],
        'prenom': row[9],
        'rates': row[10],
        'tel': row[11] if len(row) > 11 else '',
        'adresse': row[12] if len(row) > 12 else '',
        'country': row[13] if len(row) > 13 else '',
        'img': row[14] if len(row) > 14 else '',
        'about': row[15] if len(row) > 15 else '',
    }
    return jsonify({'user': user})


# --- Update user by id_user for profile page ---
@app.route('/api/users/by-iduser/<int:id_user>', methods=['PUT'])
def update_user_by_iduser(id_user):
    data = request.get_json()
    allowed_fields = ['email', 'mot_de_passe', 'role', 'code', 'sexe', 'language', 'invoice', 'nom', 'prenom', 'rates', 'tel', 'adresse', 'country', 'img', 'about', 'profileImage']
    fields = []
    values = []
    for field in allowed_fields:
        if field in data:
            fields.append(f"{field} = ?")
            values.append(data[field])
    if not fields:
        return jsonify({'error': 'No fields to update'}), 400
    values.append(id_user)
    db = get_db()
    cursor = db.cursor()
    cursor.execute(f"UPDATE users SET {', '.join(fields)} WHERE id_user = ?", values)
    db.commit()
    return jsonify({'message': 'User updated successfully'})

# --- User Access Management Endpoints ---
# Get all user access entries
@app.route('/api/user_access', methods=['GET'])
def get_user_access():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT user_id, access_key FROM user_access')
    rows = cursor.fetchall()
    access_list = [{'userId': row[0], 'accessKey': row[1]} for row in rows]
    return jsonify(access_list)

# Check if user has a specific access_key
@app.route('/api/user_access/check/<int:user_id>/<int:access_key>', methods=['GET'])
def check_user_access(user_id, access_key):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT 1 FROM user_access WHERE user_id = ? AND access_key = ?', (user_id, access_key))
    has_access = cursor.fetchone() is not None
    return jsonify({'has_access': has_access})

# Add a new access right for a user
@app.route('/api/user_access/add', methods=['POST'])
def add_user_access():
    data = request.get_json()
    user_id = data.get('userId')
    access_key = data.get('accessKey')
    db = get_db()
    cursor = db.cursor()
    print(f"[DEBUG] /api/user_access/add called with userId={user_id}, accessKey={access_key}")
    try:
        cursor.execute('INSERT OR IGNORE INTO user_access (user_id, access_key) VALUES (?, ?)', (user_id, access_key))
        db.commit()
        print(f"[DEBUG] Insert rowcount: {cursor.rowcount}")
        if cursor.rowcount > 0:
            return jsonify({'success': True, 'message': 'Access granted'}), 201
        else:
            return jsonify({'success': False, 'message': 'Access already exists'}), 200
    except Exception as e:
        print(f"[ERROR] Failed to add access: {e}")
        return jsonify({'success': False, 'message': f'Error: {str(e)}'}), 500

# Update (grant/revoke) access for a user
@app.route('/api/user_access/update', methods=['POST'])
def update_user_access():
    data = request.get_json()
    user_id = data.get('userId')
    access_key = data.get('accessKey')
    enabled = data.get('enabled')
    db = get_db()
    cursor = db.cursor()
    print(f"[DEBUG] /api/user_access/update called with userId={user_id}, accessKey={access_key}, enabled={enabled}")
    try:
        if enabled:
            cursor.execute('INSERT OR IGNORE INTO user_access (user_id, access_key) VALUES (?, ?)', (user_id, access_key))
        else:
            cursor.execute('DELETE FROM user_access WHERE user_id = ? AND access_key = ?', (user_id, access_key))
        db.commit()
        print(f"[DEBUG] Update rowcount: {cursor.rowcount}")
        return jsonify({'message': 'Access updated'})
    except Exception as e:
        print(f"[ERROR] Failed to update access: {e}")
        return jsonify({'message': f'Error: {str(e)}'}), 500

# Remove a specific access right for a user
@app.route('/api/user_access/remove', methods=['POST'])
def remove_user_access():
    data = request.get_json()
    user_id = data.get('userId')
    access_key = data.get('accessKey')
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM user_access WHERE user_id = ? AND access_key = ?', (user_id, access_key))
    db.commit()
    return jsonify({'message': 'Access removed'})

# Fetch logs for user access manager page (filtered by page if provided)
@app.route('/api/log_action', methods=['GET'])
def get_log_action():
    page = request.args.get('page')
    db = get_db()
    cursor = db.cursor()
    if page:
        cursor.execute('SELECT * FROM action_logs WHERE page = ? ORDER BY created_at DESC LIMIT 100', (page,))
    else:
        cursor.execute('SELECT * FROM action_logs ORDER BY created_at DESC LIMIT 100')
    rows = cursor.fetchall()
    columns = [col[0] for col in cursor.description]
    logs = [dict(zip(columns, row)) for row in rows]
    return jsonify(logs)

# --- Payment Users Endpoint ---
@app.route('/api/payment-users', methods=['GET'])
def get_payment_users():
    db = get_db()
    cursor = db.cursor()
    # Get all users with invoice enabled
    cursor.execute('''SELECT id_user, email, role, code, sexe, language, invoice, nom, prenom, rates, hourly, minute, img, paid_devise, bank_name, date_created FROM users WHERE invoice = 1 OR invoice = 'true' ORDER BY date_created DESC''')
    users = []
    for row in cursor.fetchall():
        user_id = row[0]
        # Get company name from MI_partneer
        cursor.execute('SELECT fullname FROM MI_partneer WHERE code = ?', (row[3],))
        company_row = cursor.fetchone()
        company_name = company_row[0] if company_row else ''
        # Get quantity (minutes) from interpreter_chart for the selected month and year
        # Default to current month/year if not provided
        month = request.args.get('month')
        year = request.args.get('year')
        if not month or not year:
            now = datetime.datetime.now()
            month = now.month
            year = now.year
        else:
            month = int(month)
            year = int(year)
        # interpreter_chart: interpreter_id, minutes_worked, month, year
        cursor.execute('SELECT SUM(minutes_worked) FROM interpreter_chart WHERE interpreter_id = ? AND month = ? AND year = ?', (user_id, month, year))
        chart_row = cursor.fetchone()
        amount_value = float(chart_row[0]) if chart_row and chart_row[0] is not None else 0.0
        rate = float(row[9]) if row[9] is not None else 0.0
        is_hourly = row[10] == 1
        is_minute = row[11] == 1
        if is_hourly:
            amount = (amount_value / 60) * rate
            qte = amount_value / 60
        else:
            amount = amount_value * rate
            qte = amount_value
        users.append({
            'id_user': user_id,
            'email': row[1],
            'role': row[2],
            'code': row[3],
            'sexe': row[4],
            'language': row[5],
            'invoice': row[6],
            'nom': row[7],
            'prenom': row[8],
            'rates': rate,
            'hourly': row[10],
            'minute': row[11],
            'img_url': row[12],
            'paid_devise': row[13],
            'bank_name': row[14],
            'date_to_pay': row[15],
            'amount': f"{amount:.2f}",
            'qte': f"{qte:.2f}",
            'company_name': company_name
        })
    return jsonify(users)

# --- Companies Endpoint ---
@app.route('/api/companies', methods=['GET'])
def get_companies():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT code, fullname FROM MI_partneer WHERE is_active = 1 ORDER BY fullname ASC')
    companies = [{'code': row[0], 'fullname': row[1]} for row in cursor.fetchall()]
    return jsonify(companies)

# --- Payment Methods Endpoint ---
@app.route('/api/payment-methods', methods=['GET'])
def get_payment_methods():
    db = get_db()
    cursor = db.cursor()
    # Get all unique bank_name values from users with invoice enabled
    cursor.execute('SELECT DISTINCT bank_name FROM users WHERE invoice = 1 OR invoice = "true"')
    methods = [row[0] for row in cursor.fetchall() if row[0]]
    return jsonify(methods)

# --- Access Names Endpoint ---
@app.route('/api/access_names', methods=['GET', 'POST'])
def access_names():
    db = get_db()
    cursor = db.cursor()
    if request.method == 'GET':
        cursor.execute('SELECT name, access_code FROM access_names ORDER BY access_code ASC')
        rows = cursor.fetchall()
        access_names = [{'name': row[0], 'access_code': row[1]} for row in rows]
        return jsonify(access_names)
    elif request.method == 'POST':
        data = request.get_json()
        name = data.get('name')
        access_code = data.get('access_code')
        if not name or not access_code:
            return jsonify({'error': 'Missing name or access_code'}), 400
        try:
            cursor.execute('INSERT INTO access_names (name, access_code) VALUES (?, ?)', (name, access_code))
            db.commit()
            return jsonify({'message': 'Access name added'}), 201
        except sqlite3.IntegrityError:
            return jsonify({'error': 'Access name or code already exists'}), 409

# --- User Names Endpoint ---
@app.route('/api/user_names', methods=['GET'])
def get_user_names():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('SELECT id_user, prenom, nom FROM users')
    rows = cursor.fetchall()
    user_names = [{'id_user': row[0], 'prenom': row[1], 'nom': row[2]} for row in rows]
    return jsonify(user_names)

# --- Edit Access Name Endpoint ---
@app.route('/api/access_names/edit', methods=['POST'])
def edit_access_name():
    data = request.get_json()
    access_code = data.get('access_code')
    new_name = data.get('name')
    new_code = data.get('new_code')
    actor_id = data.get('actor_id')
    actor_role = data.get('actor_role')
    actor_email = data.get('actor_email')
    if not access_code or not new_name or not new_code:
        return jsonify({'error': 'Missing required fields'}), 400
    db = get_db()
    cursor = db.cursor()
    try:
        cursor.execute('UPDATE access_names SET name = ?, access_code = ? WHERE access_code = ?', (new_name, new_code, access_code))
        db.commit()
        if cursor.rowcount == 0:
            return jsonify({'error': 'Access not found'}), 404
        # Log the action
        if actor_id or actor_email:
            cursor.execute('''INSERT INTO action_logs (actor_id, actor_role, actor_email, action_type, action_description, page, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)''', (
                actor_id,
                actor_role,
                actor_email,
                'edit_access_type',
                f'Edited access name/code to: {new_name} ({new_code})',
                '/api/access_names/edit',
                datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            ))
            db.commit()
        return jsonify({'message': 'Access updated'}), 200
    except sqlite3.IntegrityError:
        return jsonify({'error': 'Access code already exists'}), 409

# --- Delete Access Name Endpoint ---
@app.route('/api/access_names/delete', methods=['POST'])
def delete_access_name():
    data = request.get_json()
    access_code = data.get('access_code')
    if not access_code:
        return jsonify({'error': 'Missing access_code'}), 400
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM access_names WHERE access_code = ?', (access_code,))
    db.commit()
    if cursor.rowcount == 0:
        return jsonify({'error': 'Access not found'}), 404
    return jsonify({'message': 'Access deleted'}), 200

# --- Get ALL medical words with their translations (including words without translations) ---
@app.route('/api/medical_words_with_all_translations', methods=['GET'])
def get_all_medical_words_with_translations():
    db = get_db()
    cursor = db.cursor()
    
    # Get all medical words with their translations (LEFT JOIN to include words without translations)
    cursor.execute('''
        SELECT 
            mw.id,
            mw.source_word,
            mw.source_language,
            mw.last_update,
            mwt.id as translation_id,
            mwt.language,
            mwt.target_word,
            mwt.description,
            mwt.status,
            mwt.last_update as translation_last_update
        FROM medical_word mw
        LEFT JOIN medical_word_translation mwt ON mw.id = mwt.word_id
        ORDER BY mw.last_update DESC, mw.id DESC, mwt.last_update DESC
    ''')
    
    rows = cursor.fetchall()
    result = []
    
    for row in rows:
        word_id, source_word, source_language, word_last_update, trans_id, language, target_word, description, trans_status, trans_last_update = row
        
        # For each row, create a flat structure with word info and translation info
        result.append({
            'id': word_id,
            'source_word': source_word,
            'source_language': source_language,
            'last_update': trans_last_update or word_last_update,
            'translations': [
                {
                    'id': trans_id,
                    'language': language,
                    'target_word': target_word,
                    'description': description,
                    'status': trans_status,
                    'last_update': trans_last_update
                }
            ] if trans_id else []
        })
    
    return jsonify({'words': result})

# --- User Access Block API ---
@app.route('/api/user_access_block/<int:user_id>', methods=['GET'])
def user_access_block(user_id):
    db = get_db()
    cursor = db.cursor()
    # Ensure tables exist
    cursor.execute('''CREATE TABLE IF NOT EXISTS access_names (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name VARCHAR(64) NOT NULL,
        access_code INTEGER NOT NULL UNIQUE
    )''')
    cursor.execute('''CREATE TABLE IF NOT EXISTS user_access (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_id INTEGER NOT NULL,
        access_key TEXT NOT NULL,
        granted_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        UNIQUE(user_id, access_key)
    )''')
    db.commit()
    # Join access_names and user_access on access_code = access_key for this user
    cursor.execute('''
        SELECT an.access_code, an.name
        FROM access_names an
        INNER JOIN user_access ua ON an.access_code = ua.access_key
        WHERE ua.user_id = ?
        ORDER BY an.access_code ASC
    ''', (user_id,))
    blocks = [{'access_code': row[0], 'name': row[1]} for row in cursor.fetchall()]
    return jsonify({'blocks': blocks})


# --- API: Add a new rate for a user ---
@app.route('/api/rates', methods=['POST'])
def add_rate():
    data = request.get_json()
    user_id = data.get('user_id')
    language1 = data.get('language1')
    language2 = data.get('language2')
    rate = data.get('rate')
    per_minute = int(bool(data.get('per_minute')))
    hourly = int(bool(data.get('hourly')))
    accept_invoice = int(bool(data.get('accept_invoice')))
    comment = data.get('comment')
    now = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    print(f"[DEBUG] /api/rates POST data: {data}")
    print(f"[DEBUG] user_id received: {user_id}")
    db = get_db()
    cursor = db.cursor()
    # Check for duplicate
    cursor.execute('''SELECT id FROM rates WHERE user_id = ? AND language1 = ? AND language2 = ?''', (user_id, language1, language2))
    if cursor.fetchone():
        return jsonify({'error': 'Rate for this user and language pair already exists.'}), 400
    cursor.execute('''INSERT INTO rates (user_id, language1, language2, rate, per_minute, hourly, accept_invoice, last_update, date_add, comment)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)''',
        (user_id, language1, language2, rate, per_minute, hourly, accept_invoice, now, now, comment))
    db.commit()
    return jsonify({'message': 'Rate added'}), 201

# --- API: Get all rates for a user, showing user invoice status ---
@app.route('/api/rates', methods=['GET'])
def get_rates():
    user_id = request.args.get('user_id')
    db = get_db()
    cursor = db.cursor()
    if user_id:
        cursor.execute('''
            SELECT r.id, r.language1, r.language2, r.rate, r.per_minute, r.hourly, u.invoice as accept_invoice
            FROM rates r
            JOIN users u ON r.user_id = u.id_user
            WHERE r.user_id = ?
            ORDER BY r.id DESC
        ''', (user_id,))
    else:
        cursor.execute('''
            SELECT r.id, r.language1, r.language2, r.rate, r.per_minute, r.hourly, u.invoice as accept_invoice
            FROM rates r
            JOIN users u ON r.user_id = u.id_user
            ORDER BY r.id DESC
        ''')
    rows = cursor.fetchall()
    result = []
    for row in rows:
        result.append({
            'id': row[0],
            'language1': row[1],
            'language2': row[2],
            'rate': row[3],
            'per_minute': bool(row[4]),
            'hourly': bool(row[5]),
            'accept_invoice': bool(row[6])
        })
    return jsonify({'rates': result})

# --- Blog News School API Endpoint ---
@app.route('/api/blog_news_school', methods=['GET'])
def get_blog_news_school():
    db = get_db()
    cursor = db.cursor()
    # BLOG: field1=id, field3=title, field4=content/description, field8=carousel, field11=date_created, field9=image_url
    cursor.execute('SELECT field1, field3, field4, field8, field9, field11 FROM blog WHERE field1 != "id" AND field8 = 1')
    blogs = []
    for row in cursor.fetchall():
        content = row[2] if row[2] is not None else ''
        date = row[5] if row[5] is not None else ''
        summary = content[:80] + ('...' if len(content) > 80 else '')
        blogs.append({
            'id': row[0],
            'title': row[1],
            'content': content,
            'summary': summary,
            'carousel': row[3],
            'image_url': row[4],
            'date': date,
            'type': 'blog'
        })
    import datetime
    def parse_date(d):
        try:
            return datetime.datetime.strptime(d, '%Y-%m-%d %H:%M:%S')
        except Exception:
            try:
                return datetime.datetime.strptime(d, '%Y-%m-%d')
            except Exception:
                return datetime.datetime.min
    blogs.sort(key=lambda x: parse_date(x['date']) if x['date'] else datetime.datetime.min, reverse=True)
    return jsonify(blogs)

# --- Top Public Courses API Endpoint ---
@app.route('/api/top_courses', methods=['GET'])
def get_top_courses():
    db = get_db()
    cursor = db.cursor()
    # COURSE: id, title, description, public, image_url, etc.
    cursor.execute('SELECT course_id, course_name, description, public, image_url, hourlengh, pricing FROM courses WHERE public = 1')
    courses = []
    for row in cursor.fetchall():
        courses.append({
            'course_id': row[0],
            'course_name': row[1],
            'description': row[2],
            'public': row[3],
            'image_url': row[4],
            'hourlengh': row[5],
            'pricing': row[6],
        })
    return jsonify({'courses': courses})

# --- Assign Courses Table Creation ---
def create_assign_courses_table():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS assign_courses (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        course_id INTEGER NOT NULL,
        user_id INTEGER NOT NULL,
        assigned_at TEXT NOT NULL,
        FOREIGN KEY (course_id) REFERENCES courses(id),
        FOREIGN KEY (user_id) REFERENCES users(id_user)
    )''')
    db.commit()

# Ensure assign_courses table exists at startup
create_assign_courses_table()

# --- API: Assign Course to Users ---
@app.route('/api/assign_course', methods=['POST'])
def assign_course():
    data = request.get_json()
    course_id = data.get('course_id')
    user_id = data.get('user_id')
    user_ids = data.get('user_ids')
    if user_id is None and user_ids:
        # If user_ids is a list, take the first one (for backward compatibility)
        if isinstance(user_ids, list) and len(user_ids) > 0:
            user_id = user_ids[0]
    if user_id is None:
        return jsonify({'error': 'user_id is required'}), 400
    db = get_db()
    cursor = db.cursor()
    # Ensure assign_courses table exists
    cursor.execute('''CREATE TABLE IF NOT EXISTS assign_courses (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        course_id INTEGER,
        user_id INTEGER,
        assigned_at TEXT
    )''')
    db.commit()
    # Insert assignment
    import datetime
    assigned_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    cursor.execute('INSERT INTO assign_courses (course_id, user_id, assigned_at) VALUES (?, ?, ?)', (course_id, user_id, assigned_at))
    db.commit()
    # Fetch updated assigned users for this course
    cursor.execute('''SELECT u.id, u.id_user, u.email, u.nom, u.prenom FROM users u
                      JOIN assign_courses ac ON ac.user_id = u.id_user
                      WHERE ac.course_id = ?''', (course_id,))
    assigned_users = [
        {
            'id': row[0],
            'id_user': row[1],
            'email': row[2],
            'nom': row[3],
            'prenom': row[4]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'message': 'User assigned to course', 'user_id': user_id, 'assigned_users': assigned_users}), 201

# --- API: List users assigned to a course ---
@app.route('/api/assign_course/<int:course_id>', methods=['GET'])
def get_course_assignments(course_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''SELECT u.id_user, u.prenom, u.nom, u.email FROM assign_courses ac LEFT JOIN users u ON ac.user_id = u.id_user WHERE ac.course_id = ?''', (course_id,))
    assigned_users = []
    for u in cursor.fetchall():
        id_user, prenom, nom, email = u
        assigned_users.append({'id_user': id_user, 'prenom': prenom, 'nom': nom, 'email': email})
    return jsonify({'assigned_users': assigned_users})

# --- API: List courses assigned to a user ---
@app.route('/api/assigned_courses/<int:user_id>', methods=['GET'])
def get_user_assigned_courses(user_id):
    db = get_db()
    cursor = db.cursor()
    # Fetch all columns for full course details
    cursor.execute('''SELECT c.* FROM assign_courses ac LEFT JOIN courses c ON ac.course_id = c.course_id WHERE ac.user_id = ?''', (user_id,))
    columns = [col[0] for col in cursor.description]
    courses = [dict(zip(columns, row)) for row in cursor.fetchall()]
    return jsonify({'courses': courses})

# --- API: Remove course assignment ---
@app.route('/api/assign_course/<int:course_id>/<int:user_id>', methods=['DELETE'])
def remove_course_assignment(course_id, user_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM assign_courses WHERE course_id=? AND user_id=?', (course_id, user_id))
    db.commit()
    return jsonify({'message': 'Assignment removed'})


# --- API: Enrolled Course Count ---
@app.route('/api/enrolled_course_count', methods=['GET'])
def enrolled_course_count():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''
        SELECT course_id, COUNT(DISTINCT user_id) as num_users
        FROM enrolled_course
        GROUP BY course_id
    ''')
    results = cursor.fetchall()
    data = [
        {'course_id': row[0], 'num_users': row[1]} for row in results
    ]
    return jsonify({'enrolled_counts': data})

# --- Background job: Sync assign_courses to enrolled_course every 5 minutes ---
import threading
import time
def sync_enrolled_course():
    while True:
        try:
            db = get_db()
            cursor = db.cursor()
            cursor.execute('''
                INSERT INTO enrolled_course (course_id, user_id, assigned_at)
                SELECT ac.course_id, ac.user_id, ac.assigned_at
                FROM assign_courses ac
                LEFT JOIN enrolled_course ec
                ON ac.course_id = ec.course_id AND ac.user_id = ec.user_id AND ac.assigned_at = ec.assigned_at
                WHERE ec.id IS NULL
            ''')
            db.commit()
        except Exception as e:
            print('Error syncing enrolled_course:', e)
        time.sleep(300)  # 5 minutes

sync_thread = threading.Thread(target=sync_enrolled_course, daemon=True)
sync_thread.start()


# --- Teacher Table and API ---
def create_teacher_table():
    db = get_db()
    cursor = db.cursor()
    cursor.execute('''CREATE TABLE IF NOT EXISTS teacher (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_id INTEGER NOT NULL,
        subject TEXT,
        bio TEXT,
        school_type TEXT,
        created_at TEXT,
        FOREIGN KEY(user_id) REFERENCES users(id_user)
    )''')
    db.commit()

# Create teacher table at startup
with app.app_context():
    create_teacher_table()

# API: Get all teachers (joined with users)
@app.route('/api/teachers', methods=['GET'])
def get_teachers():
    db = get_db()
    cursor = db.cursor()
    # Add visible column if missing
    cursor.execute("PRAGMA table_info(teacher)")
    columns = [col[1] for col in cursor.fetchall()]
    if 'visible' not in columns:
        cursor.execute('ALTER TABLE teacher ADD COLUMN visible INTEGER DEFAULT 0')
        db.commit()
    cursor.execute('''
        SELECT t.id, t.user_id, u.prenom, u.nom, u.email, t.subject, t.bio, t.school_type, t.created_at, t.visible
        FROM teacher t
        LEFT JOIN users u ON t.user_id = u.id_user
    ''')
    teachers = [
        {
            'id': row[0],
            'user_id': row[1],
            'prenom': row[2],
            'nom': row[3],
            'email': row[4],
            'subject': row[5],
            'bio': row[6],
            'school_type': row[7],
            'created_at': row[8],
            'visible': row[9]
        }
        for row in cursor.fetchall()
    ]
    return jsonify({'teachers': teachers})

# API: Add a teacher (user_id must exist in users)
@app.route('/api/teachers', methods=['POST'])
def add_teacher():
    data = request.get_json()
    user_id = data.get('user_id')
    subject = data.get('subject')
    bio = data.get('bio')
    school_type = data.get('school_type')
    created_at = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    visible = data.get('visible', 1)
    actor_id = data.get('actor_id')
    actor_role = data.get('actor_role')
    actor_email = data.get('actor_email')
    if not user_id:
        return jsonify({'error': 'user_id required'}), 400
    db = get_db()
    cursor = db.cursor()
    # Check user exists
    cursor.execute('SELECT id_user, email FROM users WHERE id_user = ?', (user_id,))
    user_row = cursor.fetchone()
    if not user_row:
        return jsonify({'error': 'User not found'}), 404
    user_email = user_row[1]
    # Allow school_type to be 'both' or a valid type from schools
    if not school_type:
        return jsonify({'error': 'school_type required'}), 400
    cursor.execute('INSERT INTO teacher (user_id, subject, bio, school_type, created_at, visible) VALUES (?, ?, ?, ?, ?, ?)', (user_id, subject, bio, school_type, created_at, visible))
    db.commit()
    # Log action
    if actor_id and actor_role and actor_email:
        log_action(
            actor_id=actor_id,
            actor_role=actor_role,
            actor_email=actor_email,
            action_type='add_teacher',
            action_description=f'Added teacher for user_id={user_id}, subject={subject}, school_type={school_type}',
            target_id=user_id,
            target_email=user_email,
            page='Teachers'
        )
    return jsonify({'message': 'Teacher added'}), 201

# API: Edit a teacher
@app.route('/api/teachers/<int:teacher_id>', methods=['PUT'])
def edit_teacher(teacher_id):
    data = request.get_json()
    fields = []
    values = []
    allowed = ['user_id', 'subject', 'bio', 'school_type', 'visible']
    for key in allowed:
        if key in data:
            fields.append(f"{key} = ?")
            values.append(data[key])
    if not fields:
        return jsonify({'error': 'No fields to update'}), 400
    values.append(teacher_id)
    db = get_db()
    cursor = db.cursor()
    # Get old teacher info for logging
    cursor.execute('SELECT user_id FROM teacher WHERE id = ?', (teacher_id,))
    old_teacher = cursor.fetchone()
    old_user_id = old_teacher[0] if old_teacher else None
    cursor.execute('SELECT email FROM users WHERE id_user = ?', (old_user_id,))
    old_user_email_row = cursor.fetchone()
    old_user_email = old_user_email_row[0] if old_user_email_row else None
    cursor.execute(f"UPDATE teacher SET {', '.join(fields)} WHERE id = ?", values)
    db.commit()
    # Log action
    actor_id = data.get('actor_id')
    actor_role = data.get('actor_role')
    actor_email = data.get('actor_email')
    if actor_id and actor_role and actor_email:
        log_action(
            actor_id=actor_id,
            actor_role=actor_role,
            actor_email=actor_email,
            action_type='edit_teacher',
            action_description=f"Edited teacher id={teacher_id}, user_id={data.get('user_id', old_user_id)}, subject={data.get('subject', '')}, school_type={data.get('school_type', '')}",
            target_id=teacher_id,
            target_email=old_user_email,
            page='Teachers'
        )
    return jsonify({'message': 'Teacher updated'}), 200

# API: Delete a teacher
@app.route('/api/teachers/<int:teacher_id>', methods=['DELETE'])
def delete_teacher(teacher_id):
    db = get_db()
    cursor = db.cursor()
    cursor.execute('DELETE FROM teacher WHERE id = ?', (teacher_id,))
    db.commit()
    return jsonify({'message': 'Teacher deleted'}), 200

# do not remove these line to the end
if __name__ == '__main__':
    app.run(debug=True)

