
import React, { useState } from 'react';
import { useNavigate, useLocation } from 'react-router-dom';
import 'bootstrap/dist/css/bootstrap.min.css';

export default function Header({ activeTab, setActiveTab }) {
  const [showMobile, setShowMobile] = useState(false);
  const menuItems = [
    { label: 'Home' },
    { label: 'About' },
    { label: 'Courses' },
    { label: 'Teachers' },
    { label: 'Portfolio' },
    { label: 'Contact' },
  ];

  return (
    <nav className="navbar navbar-expand-lg navbar-light bg-light shadow-sm" style={{ zIndex: 100 }}>
      <div className="container-fluid">
        <span className="navbar-brand fw-bold" style={{ letterSpacing: 1.5, cursor: 'pointer' }} onClick={() => setActiveTab('Home')}>
          MAKE-ITCOURSES
        </span>
        <button className="navbar-toggler" type="button" onClick={() => setShowMobile(!showMobile)}>
          <span className="navbar-toggler-icon"></span>
        </button>
        <div className={`collapse navbar-collapse${showMobile ? ' show' : ''}`}>
          <ul className="navbar-nav ms-auto mb-2 mb-lg-0 align-items-lg-center">
            {menuItems.map(item => (
              <li className="nav-item" key={item.label}>
                <button
                  className={`nav-link btn btn-link${activeTab === item.label ? ' active fw-bold text-danger' : ''}`}
                  style={{
                    borderBottom: activeTab === item.label ? '2.5px solid #f75c7a' : 'none',
                    borderRadius: 0,
                    color: activeTab === item.label ? '#f75c7a' : undefined,
                    fontWeight: activeTab === item.label ? 700 : 500,
                    letterSpacing: 0.5,
                  }}
                  onClick={() => { setActiveTab(item.label); setShowMobile(false); }}
                >
                  {item.label}
                </button>
              </li>
            ))}
            <li className="nav-item ms-2">
              <button className="btn btn-danger fw-bold px-4 rounded-2" onClick={() => window.location.href = '/login'}>
                Log In
              </button>
            </li>
          </ul>
        </div>
      </div>
    </nav>
  );
}
