import React from 'react';
import './CourseCardPopup.css';

export default function CourseCardPopup({ course, onClose }) {
  return (
    <div className="course-popup-overlay" onClick={onClose}>
      <div className="course-popup" onClick={e => e.stopPropagation()}>
        <button className="close-btn" onClick={onClose}>&times;</button>
        <img src={course.image_url || '/default-course.jpg'} alt={course.title} className="popup-image" />
        <div className="popup-content">
          <h2>{course.title}</h2>
          <p className="popup-description">{course.description}</p>
          <div className="d-flex align-items-center" style={{ fontSize: 16, gap: 24, marginBottom: 8 }}>
            {course.hourlengh && (
              <span style={{background:'#e3f2fd', color:'#1976d2', borderRadius:8, padding:'2px 12px', fontWeight:500, display:'inline-block'}}>
                <i className="fa fa-clock-o me-1"></i> {course.hourlengh} Hours
              </span>
            )}
            {course.pricing > 0 ? (
              <span style={{background:'#fff3e0', color:'#fb8c00', borderRadius:8, padding:'2px 12px', fontWeight:500, display:'inline-block'}}>
                <i className="fa fa-tag me-1"></i> ${course.pricing}
              </span>
            ) : (
              <span style={{background:'#e8f5e9', color:'#388e3c', borderRadius:8, padding:'2px 12px', fontWeight:500, display:'inline-block'}}>
                <i className="fa fa-tag me-1"></i> Free
              </span>
            )}
          </div>
          {/* Action button: Buy or Enroll */}
          <div style={{marginTop: '1.5rem'}}>
            {Number(course.pricing) > 0 ? (
              <button className="btn btn-danger w-100">Buy</button>
            ) : (
              <button className="btn btn-success w-100">Enroll</button>
            )}
          </div>
        </div>
      </div>
    </div>
  );
}
