import React from 'react';
export default function About() {
  return (
    <div className="container my-5" style={{maxWidth: 900}}>
      <h1 className="fw-bold mb-4 text-center" style={{ letterSpacing: 1 }}>About MAKE-ITCOURSES</h1>
      <p style={{fontSize: '1.2rem', lineHeight: 1.7}}>
        <strong>MAKE-ITCOURSES</strong> is a modern, flexible online learning platform designed to empower students, professionals, and organizations with high-quality, accessible education. Built with a robust <strong>React</strong> frontend and a scalable <strong>Flask/Python</strong> backend, MAKE-ITCOURSES offers a seamless experience for course browsing, enrollment, and interactive learning.
      </p>
      <h3 className="mt-5 mb-3">Key Features</h3>
      <ul style={{fontSize: '1.1rem', lineHeight: 1.7}}>
        <li>Professional and classical course catalogs</li>
        <li>Secure user authentication and registration</li>
        <li>Dynamic blog and news carousel.</li>
        <li>Role-based dashboards for administrators and users</li>
        <li>Certificate management and verification</li>
        <li>Modern, responsive UI with Bootstrap styling</li>
        <li>Integrated visit tracking and analytics</li>
        <li>Document and media management</li>
      </ul>
      <h3 className="mt-5 mb-3">Platform Structure</h3>
      <ul style={{fontSize: '1.1rem', lineHeight: 1.7}}>
        <li><strong>Frontend:</strong> React.js, Bootstrap, modular components for courses, authentication, and dashboards</li>
        <li><strong>Backend:</strong> Python Flask API, SQLite database, RESTful endpoints for all major features</li>
        <li><strong>Database:</strong> Structured tables for users, courses, blogs, certificates, and more</li>
        <li><strong>Security:</strong> Password hashing, CORS, and role-based access</li>
      </ul>
      <h3 className="mt-5 mb-3">Our Mission</h3>
      <p style={{fontSize: '1.2rem', lineHeight: 1.7}}>
        MAKE-ITCOURSES aims to make education accessible, engaging, and effective for everyone. Whether you are a student seeking new skills, a professional advancing your career, or an organization training your team, our platform is built to support your journey.
      </p>
    </div>
  );
}
