import React from 'react';
import { Card, CardContent, Typography, Button } from '@mui/material';

export default function CourseCard({ course }) {
  return (
    <Card sx={{ margin: 2 }}>
      <CardContent>
        <Typography variant="h5">{course.title}</Typography>
        <Typography variant="body2">{course.description}</Typography>
        {course.isFree ? (
          <Button variant="contained" color="success">Get Started</Button>
        ) : (
          <Button variant="contained" color="primary">Buy</Button>
        )}
      </CardContent>
    </Card>
  );
}
