import React, { useEffect, useState } from 'react';

const MyTutorial = ({ userId }) => {
  const [tutorials, setTutorials] = useState([]);
  const [selectedIdx, setSelectedIdx] = useState(0);
  useEffect(() => {
    fetch(`/api/my_tutorials?user_id=${userId}`)
      .then(res => res.json())
      .then(data => setTutorials(data.tutorials || []));
  }, [userId]);

  return (
    <div style={{ padding: '32px', display: 'flex', gap: '32px', minHeight: '400px', background: '#f7f8fa' }}>
      <div style={{ minWidth: '240px', maxWidth: '280px', background: '#fff', borderRadius: '16px', boxShadow: '0 4px 24px rgba(25,118,210,0.08)', padding: '24px 18px', height: 'fit-content', marginTop: '12px' }}>
        <h2 style={{ fontSize: '1.35rem', marginBottom: '18px', color: '#1976d2', fontWeight: 700 }}>Tutorials</h2>
        {tutorials.length === 0 ? (
          <div style={{ color: '#888', fontSize: '1.08rem' }}>No tutorials assigned.</div>
        ) : (
          <ul style={{ listStyle: 'none', padding: 0, margin: 0 }}>
            {tutorials.map((tut, idx) => (
              <li
                key={tut.id}
                style={{
                  padding: '12px 16px',
                  marginBottom: '10px',
                  background: idx === selectedIdx ? '#e3f2fd' : '#f7f8fa',
                  color: idx === selectedIdx ? '#1976d2' : '#222',
                  borderRadius: '8px',
                  fontWeight: idx === selectedIdx ? 'bold' : 'normal',
                  cursor: 'pointer',
                  boxShadow: idx === selectedIdx ? '0 2px 8px rgba(25,118,210,0.08)' : 'none',
                  border: idx === selectedIdx ? '2px solid #90caf9' : '1px solid #e0e0e0',
                  transition: 'background 0.2s, border 0.2s',
                }}
                onClick={() => setSelectedIdx(idx)}
                onMouseEnter={e => e.currentTarget.style.background = '#e3f2fd'}
                onMouseLeave={e => e.currentTarget.style.background = idx === selectedIdx ? '#e3f2fd' : '#f7f8fa'}
              >
                {tut.title}
              </li>
            ))}
          </ul>
        )}
      </div>
      <div style={{ flex: 1, background: '#fff', borderRadius: '16px', boxShadow: '0 4px 24px rgba(25,118,210,0.08)', padding: '32px 24px', minHeight: '320px', marginTop: '12px', display: 'flex', flexDirection: 'column', alignItems: 'flex-start' }}>
        {tutorials.length === 0 ? (
          <div style={{ color: '#888', fontSize: '1.08rem' }}>No tutorial selected.</div>
        ) : (
          <>
            <h3 style={{ color: '#1976d2', marginBottom: '18px', fontWeight: 700, fontSize: '1.25rem' }}>{tutorials[selectedIdx].title}</h3>
            <div style={{ marginBottom: '24px', width: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', minHeight: '320px', padding: '16px 0' }}>
              {tutorials[selectedIdx].video_url ? (
                tutorials[selectedIdx].video_url.startsWith('/videos/') || tutorials[selectedIdx].video_url.startsWith('http') ? (
                  <div style={{ width: '100%', maxWidth: '640px', position: 'relative', display: 'flex', justifyContent: 'center', alignItems: 'center', padding: '0 16px' }}>
                    <video
                      key={tutorials[selectedIdx].id}
                      style={{ width: '100%', maxWidth: '640px', height: 'auto', borderRadius: '16px', boxShadow: '0 4px 24px rgba(25,118,210,0.10)', background: '#000', display: 'block', margin: '0 auto' }}
                      controls
                      controlsList="nodownload"
                      onContextMenu={e => e.preventDefault()}
                    >
                      <source src={tutorials[selectedIdx].video_url} type="video/mp4" />
                      Your browser does not support the video tag.
                    </video>
                  </div>
                ) : (
                  <div style={{ width: '100%', maxWidth: '640px', display: 'flex', justifyContent: 'center', alignItems: 'center', padding: '0 16px' }}>
                    <iframe
                      key={tutorials[selectedIdx].id}
                      style={{ width: '100%', maxWidth: '640px', height: '360px', borderRadius: '16px', boxShadow: '0 4px 24px rgba(25,118,210,0.10)', background: '#000', display: 'block', margin: '0 auto' }}
                      src={tutorials[selectedIdx].video_url}
                      title={tutorials[selectedIdx].title}
                      frameBorder="0"
                      allowFullScreen
                      onContextMenu={e => e.preventDefault()}
                    ></iframe>
                  </div>
                )
              ) : null}
            </div>
            <div style={{ width: '100%' }}>
              <h4 style={{ color: '#1565c0', marginBottom: '10px', fontWeight: 700 }}>Insight</h4>
              <div style={{ fontSize: '1.08rem', color: '#222', background: '#f7f8fa', borderRadius: '8px', padding: '16px', minHeight: '48px', boxShadow: '0 2px 8px rgba(0,0,0,0.04)' }} dangerouslySetInnerHTML={{ __html: tutorials[selectedIdx].tutorial_insight }} />
            </div>
          </>
        )}
      </div>
    </div>
  );
};

export default MyTutorial;
