import React, { useState } from 'react';
import { Editor } from '@tinymce/tinymce-react';
import { BASE_API } from '../../utils/config';
// ...existing code...
const SignatureManager = () => {
  const [requestEmail, setRequestEmail] = useState('');
  const [requestDocId, setRequestDocId] = useState('');
  const [requestStatus, setRequestStatus] = useState(null);
  const [requestLink, setRequestLink] = useState('');
  const [activeTab, setActiveTab] = useState('add');
  const [companyId, setCompanyId] = useState('');
  const [documentName, setDocumentName] = useState('');
  const [documentContent, setDocumentContent] = useState('');
  const [saveStatus, setSaveStatus] = useState(null);
  const [documents, setDocuments] = useState([]);
  const [selectedDoc, setSelectedDoc] = useState(null);
  const [signedDocuments, setSignedDocuments] = useState([]);
  // Fetch all documents for preview
  React.useEffect(() => {
    if (activeTab === 'preview' || activeTab === 'request' || activeTab === 'signed') {
      fetch(`${BASE_API}/documents/signed`)
        .then(res => res.json())
        .then(data => {
          setSignedDocuments(data.signed_documents || []);
        });
      fetch(`${BASE_API}/documents/all`)
        .then(res => res.json())
        .then(data => {
          setDocuments(data.documents || []);
        });
    }
  }, [activeTab]);
  return (
    <div style={{padding:'32px'}}>
      <h2 style={{color:'#1565c0', marginBottom:'24px'}}>Manage Signature Manager</h2>
      <div style={{display:'flex', gap:'16px', marginBottom:'24px'}}>
        <button onClick={()=>setActiveTab('add')} style={{fontWeight:activeTab==='add'?'bold':'normal'}}>Add Document</button>
        <button onClick={()=>setActiveTab('preview')} style={{fontWeight:activeTab==='preview'?'bold':'normal'}}>Preview Document</button>
        <button onClick={()=>setActiveTab('request')} style={{fontWeight:activeTab==='request'?'bold':'normal'}}>Request Signature</button>
        <button onClick={()=>setActiveTab('signed')} style={{fontWeight:activeTab==='signed'?'bold':'normal'}}>Signed Documents</button>
      </div>
      <div style={{marginTop:'24px'}}>
        {activeTab==='add' && (
          <div>
            <div style={{marginBottom:'16px'}}>
              <label style={{fontWeight:'bold', marginRight:'8px'}}>Document Name:</label>
              <input type="text" value={documentName} onChange={e=>setDocumentName(e.target.value)} placeholder="Enter document name" style={{padding:'6px', borderRadius:'6px', border:'1px solid #ccc', marginRight:'16px'}} />
              <label style={{fontWeight:'bold', marginRight:'8px'}}>Company ID:</label>
              <input type="text" value={companyId} onChange={e=>setCompanyId(e.target.value)} placeholder="Enter company ID" style={{padding:'6px', borderRadius:'6px', border:'1px solid #ccc'}} />
            </div>
            <Editor
              apiKey="2ujb8js1jflsddb96gzk4pzh89gxa8v4hn3f1tze484trd65"
              value={documentContent}
              init={{
                height: 400,
                menubar: false,
                plugins: [
                  'advlist autolink lists link image charmap preview anchor',
                  'searchreplace visualblocks code fullscreen',
                  'insertdatetime media table paste code help wordcount'
                ],
                toolbar:
                  'undo redo | formatselect | bold italic backcolor | \
                  alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help | signatureField nameField dateField',
                setup: (editor) => {
                  editor.ui.registry.addButton('signatureField', {
                    text: 'Insert Signature Field',
                    onAction: () => {
                      editor.insertContent('<span style="border:1px dashed #1565c0; padding:4px 12px; background:#eaf6ff; color:#1565c0; border-radius:6px;">[Signature Here]</span>');
                    }
                  });
                  editor.ui.registry.addButton('nameField', {
                    text: 'Insert Name Field',
                    onAction: () => {
                      editor.insertContent('<span style="border:1px dashed #27ae60; padding:4px 12px; background:#eaf6ff; color:#27ae60; border-radius:6px;">[Name Here]</span>');
                    }
                  });
                  editor.ui.registry.addButton('dateField', {
                    text: 'Insert Date Field',
                    onAction: () => {
                      editor.insertContent('<span style="border:1px dashed #a259e6; padding:4px 12px; background:#eaf6ff; color:#a259e6; border-radius:6px;">[Date Here]</span>');
                    }
                  });
                }
              }}
              onEditorChange={content => setDocumentContent(content)}
            />
            <div style={{marginTop:'16px'}}>
              <button
                style={{background:'#1565c0', color:'#fff', border:'none', borderRadius:'8px', padding:'8px 24px', fontWeight:'bold', cursor:'pointer'}}
                onClick={async () => {
                  setSaveStatus(null);
                  if (!documentName.trim()) {
                    setSaveStatus('Document name is required.');
                    return;
                  }
                  const res = await fetch(`${BASE_API}/documents`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({
                      name: documentName,
                      content: documentContent,
                      company_code: companyId,
                      indication: '[Signature Here]'
                    })
                  });
                  if (res.ok) {
                    setSaveStatus('Document saved successfully!');
                    setDocumentContent('');
                    setCompanyId('');
                    setDocumentName('');
                  } else {
                    const data = await res.json();
                    setSaveStatus(data.error || 'Error saving document');
                  }
                }}
              >
                Save Document
              </button>
              {saveStatus && (
                <div style={{marginTop:'12px', color: saveStatus.includes('success') ? '#27ae60' : '#f75c7a', fontWeight:'bold'}}>{saveStatus}</div>
              )}
            </div>
          </div>
        )}
        {activeTab==='preview' && (
          <div>
            <h3 style={{marginBottom:'12px'}}>Saved Documents</h3>
            <ul style={{listStyle:'none', padding:0}}>
              {documents.length === 0 && <li>No documents found.</li>}
              {documents.map(doc => (
                <li key={doc.id} style={{marginBottom:'8px'}}>
                  <button style={{background:'#eaf6ff', border:'1px solid #1565c0', borderRadius:'6px', padding:'6px 12px', cursor:'pointer', color:'#1565c0', fontWeight:'bold'}} onClick={()=>setSelectedDoc(doc)}>
                    Preview Document #{doc.id}
                  </button>
                </li>
              ))}
            </ul>
            {selectedDoc && (
              <div style={{marginTop:'24px', background:'#fff', borderRadius:'8px', boxShadow:'0 2px 8px rgba(0,0,0,0.08)', padding:'16px'}}>
                <h4>Document #{selectedDoc.id}</h4>
                <div id="pdf-preview" dangerouslySetInnerHTML={{__html: selectedDoc.document_content}} />
                <button style={{marginTop:'12px', background:'#1565c0', color:'#fff', border:'none', borderRadius:'6px', padding:'6px 16px', fontWeight:'bold', cursor:'pointer', marginRight:'8px'}} onClick={() => {
                  import('html2pdf.js').then(html2pdf => {
                    const element = document.getElementById('pdf-preview');
                    html2pdf.default().from(element).save(`document_${selectedDoc.id}.pdf`);
                  });
                }}>Download PDF</button>
                <button style={{marginTop:'12px', background:'#f75c7a', color:'#fff', border:'none', borderRadius:'6px', padding:'6px 16px', fontWeight:'bold', cursor:'pointer'}} onClick={()=>setSelectedDoc(null)}>Close Preview</button>
              </div>
            )}
          </div>
        )}
        {activeTab==='request' && (
          <div>
            <h3 style={{marginBottom:'12px'}}>Request Signature</h3>
            <div style={{marginBottom:'12px'}}>
              <label style={{fontWeight:'bold', marginRight:'8px'}}>Select Document:</label>
              <select value={requestDocId} onChange={e=>setRequestDocId(e.target.value)} style={{padding:'6px', borderRadius:'6px', border:'1px solid #ccc'}}>
                <option value="">-- Select --</option>
                {documents.map(doc => (
                  <option key={doc.id} value={doc.id}>{doc.name ? doc.name : `Document #${doc.id}`}</option>
                ))}
              </select>
            </div>
            <div style={{marginBottom:'12px'}}>
              <label style={{fontWeight:'bold', marginRight:'8px'}}>Recipient Email:</label>
              <input type="email" value={requestEmail} onChange={e=>setRequestEmail(e.target.value)} placeholder="Enter email" style={{padding:'6px', borderRadius:'6px', border:'1px solid #ccc', marginRight:'16px'}} />
              <label style={{fontWeight:'bold', marginRight:'8px'}}>Expires In (minutes):</label>
              <input type="number" min="1" max="1440" value={requestStatus?.expiresIn || ''} onChange={e=>setRequestStatus({...(requestStatus||{}), expiresIn: e.target.value})} placeholder="60" style={{padding:'6px', borderRadius:'6px', border:'1px solid #ccc', width:'80px'}} />
            </div>
            <button
              style={{background:'#1565c0', color:'#fff', border:'none', borderRadius:'8px', padding:'8px 24px', fontWeight:'bold', cursor:'pointer'}}
              onClick={async () => {
                setRequestStatus(null);
                setRequestLink('');
                if (!requestDocId || !requestEmail) {
                  setRequestStatus('Please select a document and enter an email.');
                  return;
                }
                const expiresInMinutes = parseInt(requestStatus?.expiresIn || '60', 10);
                const expiresInSeconds = expiresInMinutes * 60;
                const res = await fetch(`${BASE_API}/documents/request-signature`, {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/json' },
                  body: JSON.stringify({
                    document_id: requestDocId,
                    email: requestEmail,
                    expires_in: expiresInSeconds
                  })
                });
                const data = await res.json();
                if (res.ok && data.link) {
                  setRequestLink(data.link);
                  setRequestStatus('Signature request link generated!');
                } else {
                  setRequestStatus(data.error || 'Error generating link');
                }
              }}
            >
              Request Signature
            </button>
            {requestStatus && (
              <div style={{marginTop:'12px', color: typeof requestStatus === 'string' && requestStatus.includes('generated') ? '#27ae60' : '#f75c7a', fontWeight:'bold'}}>
                {typeof requestStatus === 'string' ? requestStatus : requestStatus.status || ''}
              </div>
            )}
            {requestLink && (
              <div style={{marginTop:'12px'}}>
                <label style={{fontWeight:'bold'}}>Signature Link:</label>
                <input type="text" value={requestLink} readOnly style={{width:'100%', padding:'6px', borderRadius:'6px', border:'1px solid #ccc', marginTop:'4px'}} />
                <button style={{marginTop:'8px', background:'#27ae60', color:'#fff', border:'none', borderRadius:'6px', padding:'6px 16px', fontWeight:'bold', cursor:'pointer'}} onClick={()=>navigator.clipboard.writeText(requestLink)}>Copy Link</button>
              </div>
            )}
          </div>
        )}
        {activeTab==='signed' && (
          <div>
            <h3 style={{marginBottom:'12px'}}>Signed Documents</h3>
            <ul style={{listStyle:'none', padding:0}}>
              {signedDocuments.length === 0 && <li>No signed documents found.</li>}
              {signedDocuments.map(doc => (
                <li key={doc.id} style={{marginBottom:'8px'}}>
                  <div style={{background:'#eaf6ff', border:'1px solid #1565c0', borderRadius:'6px', padding:'8px 16px'}}>
                    <h4>Document #{doc.id}</h4>
                    <div dangerouslySetInnerHTML={{__html: doc.signed_content || doc.document_content}} />
                  </div>
                </li>
              ))}
            </ul>
          </div>
        )}
      </div>
    </div>
  );
};
export default SignatureManager;
