import { useEffect, useRef } from 'react';
import axios from 'axios';
import { useNavigate } from 'react-router-dom';
import { BASE_API } from '../utils/config';

function getUserInfo() {
  return {
    userId: localStorage.getItem('userId'),
    idUser: localStorage.getItem('id_user'),
    email: localStorage.getItem('email'),
    role: localStorage.getItem('role'),
  };
}

export default function AutomaticLogout({ children, timeout = 10 * 60 * 1000 }) {
  const navigate = useNavigate();
  const timer = useRef();

  // Logout logic
  const logout = (reason = 'system') => {
    const { userId, idUser, email, role } = getUserInfo();
    if (userId) {
      axios.post(`${BASE_API}/api/logout`, {
        user_id: userId,
        id_user: idUser,
        email,
        role,
        reason,
      }).catch(() => {});
    }
    localStorage.clear();
    sessionStorage.clear();
    setTimeout(() => navigate('/login', { replace: true }), 500);
  };

  // Reset timer on activity
  const resetTimer = () => {
    if (timer.current) clearTimeout(timer.current);
    timer.current = setTimeout(() => logout('system'), timeout);
  };

  useEffect(() => {
    const events = ['mousemove', 'mousedown', 'keydown', 'scroll', 'touchstart'];
    events.forEach(e => window.addEventListener(e, resetTimer));
    resetTimer();
    return () => {
      events.forEach(e => window.removeEventListener(e, resetTimer));
      if (timer.current) clearTimeout(timer.current);
    };
    // eslint-disable-next-line
  }, []);

  return children || null;
}
