<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Legal Interpreter Certification</title>
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Roboto:wght@300;400;500&display=swap");
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: "Roboto", sans-serif;
            background: white;
            width: 11in;
            height: 8.5in;
            margin: 0;
            padding: 0.5in;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .certificate-container {
            background: white;
            width: 10in;
            height: 7.5in;
            border: 15px solid #800080;
            border-radius: 20px;
            position: relative;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 6rem;
            color: rgba(0,0,0,0.03);
            z-index: 1;
            font-family: "Playfair Display", serif;
            letter-spacing: 0.2em;
            font-weight: 900;
        }
        
        .certificate-header {
            background: linear-gradient(135deg, #800080 0%, #9370DB 100%);
            color: white;
            text-align: center;
            padding: 20px 20px 15px 20px;
            position: relative;
            z-index: 2;
        }
        
        .certificate-title {
            font-family: "Playfair Display", serif;
            font-size: 2.0rem;
            font-weight: 700;
            margin-bottom: 8px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        
        .certificate-subtitle {
            font-size: 1.0rem;
            font-weight: 300;
            opacity: 0.9;
        }
        
        .certificate-body {
            padding: 25px 40px;
            text-align: center;
            position: relative;
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            z-index: 2;
        }
        
        .main-content {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        
        .certificate-text {
            font-size: 1.0rem;
            line-height: 1.6;
            color: #333;
            margin-bottom: 15px;
        }
        
        .recipient-name {
            font-family: "Playfair Display", serif;
            font-size: 2.4rem;
            font-weight: 700;
            color: #800080;
            margin: 20px 0;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
            border-bottom: 3px solid #9370DB;
            padding-bottom: 10px;
            display: inline-block;
        }
        
        .legal-simple-container {
            margin-top: 20px;
        }
        
        .legal-subtitle {
            font-family: "Playfair Display", serif;
            font-size: 1.2rem;
            color: #800080;
            font-weight: 600;
            margin-bottom: 20px;
        }
        
        .legal-verification-text {
            font-size: 0.95rem;
            color: #555;
            line-height: 1.6;
            margin-bottom: 25px;
            max-width: 85%;
            margin-left: auto;
            margin-right: auto;
        }
        
        .legal-signature-section {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
            background: linear-gradient(135deg, rgba(128, 0, 128, 0.03) 0%, rgba(147, 112, 219, 0.05) 100%);
            border-radius: 15px;
            padding: 20px;
            border: 2px solid #800080;
        }
        
        .legal-signature-left {
            flex: 1;
            text-align: center;
        }
        
        .signature-image-container {
            margin-bottom: -22px;
        }
        
        .legal-signature-img {
            max-width: 280px;
            max-height: 50px;
            opacity: 1.1;
        }
        
        .signature-line-legal {
            width: 300px;
            height: 1px;
            background-color: #000;
            margin: 0 auto 8px auto;
        }
        
        .legal-signatory-info {
            text-align: center;
        }
        
        .signatory-name {
            font-family: Arial, sans-serif;
            font-size: 14px;
            font-weight: bold;
            color: #000;
            margin-bottom: 3px;
        }
        
        .signatory-title {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #666;
            line-height: 1.3;
        }
        
        .signatory-org {
            font-family: Arial, sans-serif;
            font-size: 10px;
            color: #666;
            font-weight: 500;
        }
        
        .signature-dates-container {
            margin-top: 15px;
            display: flex;
            justify-content: center;
            gap: 20px;
        }
        
        .signature-date-item {
            background: white;
            border: 2px solid #800080;
            border-radius: 25px;
            padding: 8px 16px;
            text-align: center;
            box-shadow: 0 2px 8px rgba(128, 0, 128, 0.15);
            min-width: 120px;
        }
        
        .signature-date-label {
            font-family: "Playfair Display", serif;
            font-size: 0.75rem;
            font-weight: 700;
            color: #800080;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 2px;
        }
        
        .signature-date-value {
            font-family: "Roboto", sans-serif;
            font-size: 0.85rem;
            font-weight: 600;
            color: #333;
        }
        
        .legal-qr-center {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            margin: 0 20px;
        }
        
        .qr-code-legal {
            width: 80px;
            height: 80px;
            border: 3px solid #800080;
            border-radius: 8px;
        }
        
        .qr-text {
            font-size: 0.8rem;
            color: #666;
            margin: 5px 0;
        }
        
        .legal-info-right {
            flex: 1;
            text-align: center;
        }
        
        .legal-info-box {
            background: white;
            border-radius: 12px;
            padding: 15px;
            box-shadow: 0 4px 15px rgba(128, 0, 128, 0.1);
            border: 1px solid #800080;
        }
        
        .legal-info-title {
            font-family: "Playfair Display", serif;
            color: #800080;
            font-size: 1rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 8px;
        }
        
        .legal-info-desc {
            font-family: "Roboto", sans-serif;
            font-size: 0.75rem;
            color: #666;
            line-height: 1.4;
            margin-bottom: 8px;
        }
        
        .legal-info-number {
            font-family: "Roboto", sans-serif;
            font-size: 0.8rem;
            color: #800080;
            font-weight: 600;
        }
        
        /* Professional Print Button Styles */
        .print-button-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            display: flex;
            gap: 10px;
        }
        
        .print-btn {
            background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-family: 'Arial', sans-serif;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
            transition: all 0.3s ease;
            text-decoration: none;
            letter-spacing: 0.5px;
            text-transform: uppercase;
        }
        
        .print-btn:hover {
            background: linear-gradient(135deg, #b91c1c 0%, #991b1b 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(220, 38, 38, 0.4);
        }
        
        .print-btn:active {
            transform: translateY(0);
            box-shadow: 0 2px 8px rgba(220, 38, 38, 0.3);
        }
        
        .print-icon {
            font-size: 16px;
            font-weight: bold;
        }
        
        .download-btn {
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-family: 'Arial', sans-serif;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 4px 12px rgba(5, 150, 105, 0.3);
            transition: all 0.3s ease;
            text-decoration: none;
            letter-spacing: 0.5px;
            text-transform: uppercase;
        }
        
        .download-btn:hover {
            background: linear-gradient(135deg, #047857 0%, #065f46 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(5, 150, 105, 0.4);
        }
        
        .download-btn:active {
            transform: translateY(0);
            box-shadow: 0 2px 8px rgba(5, 150, 105, 0.3);
        }
        
        .view-btn {
            background: linear-gradient(135deg, #800080 0%, #9370DB 100%);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-family: 'Arial', sans-serif;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 4px 12px rgba(128, 0, 128, 0.3);
            transition: all 0.3s ease;
            text-decoration: none;
            letter-spacing: 0.5px;
            text-transform: uppercase;
        }
        
        .view-btn:hover {
            background: linear-gradient(135deg, #9370DB 0%, #663399 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(128, 0, 128, 0.4);
        }
        
        .view-btn:active {
            transform: translateY(0);
            box-shadow: 0 2px 8px rgba(128, 0, 128, 0.3);
        }
        
        /* Print specific styles */
        @media print { 
            .print-button-container { 
                display: none !important; 
            } 
            body { 
                background: white !important; 
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
                print-color-adjust: exact;
            }
            .certificate-container {
                background: white !important;
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
                print-color-adjust: exact;
            }
        }
    </style>

        <style>
            @media print {
                @page {
                    size: 11in 8.5in landscape;
                    margin: 0.5in;
                }
                body {
                    -webkit-print-color-adjust: exact;
                    color-adjust: exact;
                    print-color-adjust: exact;
                }
            }
        </style></head>
<body>
    <!-- Professional Print Button Container -->
    <div class="print-button-container">
        <button class="print-btn" onclick="window.print()">
            <span class="print-icon">🖨️</span>
            Print Certificate
        </button>
        <button class="download-btn" onclick="downloadAsPDF()">
            <span class="print-icon">📄</span>
            Save as PDF
        </button>
        <a href="https://school.makeitservices.org/verify/legal/Legal_certificate_html/legal_certificate_189957042830.html" target="_blank" class="view-btn">
            <span class="print-icon">👁️</span>
            View Certificate
        </a>
    </div>
    
    <div class="certificate-container">
        <div class="watermark">CERTIFIED</div>
        
        <div class="certificate-header">
            <h1 class="certificate-title">Legal Interpreter Certification</h1>
            <p class="certificate-subtitle">40 Hours Legal Interpreter Program</p>
        </div>
        
        <div class="certificate-body">
            <div class="main-content">
                <p class="certificate-text">This is to certify that</p>
                
                <div class="recipient-name">{fulle name}</div>
                
                <p class="certificate-text">This certificate confirms that the individual has successfully completed the 40-hour Legal Interpreter certification program and is qualified to provide legal interpretation services.</p>
                
                <div class="legal-simple-container">
                    <div class="legal-subtitle">Legal Interpretation in English and Arabic</div>
                    
                    <div class="legal-verification-text">
                        This certificate verifies passing scores in MAKE-IT Legal Center' written exam and legal interpretation exam (verbal)
                    </div>
                    
                    <div class="legal-signature-section">
                        <div class="legal-signature-left">
                            <div class="signature-image-container">
                                <img src="../../../Other/ernston_signature_legal.png" alt="Signature" class="legal-signature-img" />
                            </div>
                            <div class="signature-line-legal"></div>
                            <div class="legal-signatory-info">
                                <div class="signatory-name">Ernston St Pierre</div>
                                <div class="signatory-title">Lead Legal Trainer</div>
                                <div class="signatory-org">MAKE-IT SERVICES TECHNOLOGY legal Center.</div>
                            </div>
                            <div class="signature-dates-container">
                                <div class="signature-date-item">
                                    <div class="signature-date-label">issue Date</div>
                                    <div class="signature-date-value">{Date validity}</div>
                                </div>
                                <div class="signature-date-item">
                                    <div class="signature-date-label">Expiration</div>
                                    <div class="signature-date-value">{expired 2 years from issue date}</div>
                                </div>
                            </div>
                        </div>
                        <div class="legal-qr-center">
                            <img src="../qr_certificate/qr_legal_189957042830.png" alt="Verification QR Code" class="qr-code-legal">
                            <div class="qr-text">Scan to Verify</div>
                        </div>
                        <div class="legal-info-right">
                            <div class="legal-info-box">
                                <div class="legal-info-title">Advancing Justice Through Legal Education®</div>
                                <div class="legal-info-desc">is developed and maintained by MAKE-IT LEGAL CENTER, committed to excellence in legal training and aligned with best practices recognized by leading U.S. legal organizations</div>
                                <div class="legal-info-number">Certificate #: {cerf_id}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- JavaScript for Print and PDF functionality -->
    <script>
        // Fetch certificate details and update placeholders
        document.addEventListener('DOMContentLoaded', function() {
            const urlParams = new URLSearchParams(window.location.search);
            const cerf_id = urlParams.get('cerf_id');
            if (!cerf_id) return;
            fetch(`/api/certificates?cerf_id=${cerf_id}`)
                .then(res => res.json())
                .then(data => {
                    // Replace recipient name
                    const nameEl = document.querySelector('.recipient-name');
                    if (nameEl) nameEl.textContent = data.fullname || '';

                    // Replace issue date
                    const dateEls = document.querySelectorAll('.signature-date-value');
                    if (dateEls[0]) dateEls[0].textContent = data.date_validity || '';

                    // Replace expiration date
                    if (dateEls[1]) dateEls[1].textContent = data.expiration_date || '';

                    // Replace certificate number
                    const certNumEl = document.querySelector('.legal-info-number');
                    if (certNumEl) certNumEl.textContent = `Certificate #: ${data.cerf_id}`;
                });
        });

        // Existing print and PDF logic
        function downloadAsPDF() {
            const printContainer = document.querySelector('.print-button-container');
            if (printContainer) {
                printContainer.style.display = 'none';
            }
            showPDFInstructions();
        }
        function showPDFInstructions() {
            const modal = document.createElement('div');
            modal.id = 'pdf-modal';
            modal.style.cssText = `
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.8);
                z-index: 10000;
                display: flex;
                align-items: center;
                justify-content: center;
                font-family: Arial, sans-serif;
            `;
            modal.innerHTML = `
                <div style='background: white; padding: 30px; border-radius: 12px; max-width: 500px; box-shadow: 0 20px 40px rgba(0,0,0,0.3);'>
                    <div style='text-align: center; margin-bottom: 20px;'>
                        <h2 style='color: #dc2626; margin: 0 0 10px 0; font-size: 24px;'>📄 Save as PDF</h2>
                        <p style='color: #666; margin: 0; font-size: 16px;'>Follow these steps to save your Legal certificate as PDF</p>
                    </div>
                    <ol style='color: #333; font-size: 14px; line-height: 1.6; margin: 20px 0; padding-left: 20px;'>
                        <li><strong>Press Ctrl+P</strong> (or Cmd+P on Mac)</li>
                        <li>Select <strong>Save as PDF</strong> as destination</li>
                        <li>Set paper size to <strong>11 x 8.5 inches Landscape</strong></li>
                        <li>Set margins to <strong>None</strong> or <strong>Minimum</strong></li>
                        <li>Enable <strong>Background graphics</strong></li>
                        <li>Click <strong>Save</strong> or <strong>Print</strong></li>
                    </ol>
                    <div style='display: flex; gap: 10px; justify-content: center; margin-top: 25px;'>
                        <button onclick='startPrintProcess()' style='
                            background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
                            color: white;
                            border: none;
                            padding: 12px 24px;
                            border-radius: 8px;
                            font-weight: 600;
                            cursor: pointer;
                            font-family: Arial, sans-serif;
                        '>
                            Start Print Process
                        </button>
                        <button onclick='closePDFModal()' style='
                            background: #6b7280;
                            color: white;
                            border: none;
                            padding: 12px 24px;
                            border-radius: 8px;
                            font-weight: 600;
                            cursor: pointer;
                            font-family: Arial, sans-serif;
                        '>
                            Close
                        </button>
                    </div>
                </div>
            `;
            document.body.appendChild(modal);
        }
        function startPrintProcess() {
            closePDFModal();
            setTimeout(() => {
                window.print();
            }, 300);
        }
        function closePDFModal() {
            const modal = document.getElementById('pdf-modal');
            if (modal) {
                modal.remove();
            }
            const printContainer = document.querySelector('.print-button-container');
            if (printContainer) {
                printContainer.style.display = 'flex';
            }
        }
    </script>
</body>
</html>
