
import React from 'react';
import { List } from 'react-window';
import { Table, TableBody, TableCell, TableHead, TableRow, Switch, IconButton, Paper, TableContainer } from '@mui/material';
import DeleteIcon from '@mui/icons-material/Delete';

const ROW_HEIGHT = 56;


function VirtualizedUserTable({ users = [], accessList = [], possibleAccess = [], loading, handleToggleAccess, handleRemoveAccess }) {
	if (!Array.isArray(users) || !Array.isArray(accessList) || !Array.isArray(possibleAccess) || users.length === 0) return null;
	const itemData = { users, accessList, possibleAccess, loading, handleToggleAccess, handleRemoveAccess };
	const Row = ({ index, style, data }) => {
		if (!data || !Array.isArray(data.users) || !Array.isArray(data.accessList) || !Array.isArray(data.possibleAccess)) return null;
		const { users, accessList, possibleAccess, loading, handleToggleAccess, handleRemoveAccess } = data;
		const user = users[index];
		if (!user) return null;
		const uidStr = String(user.Id);
		return (
			<TableRow key={uidStr} style={style}>
				<TableCell>{user.email || user.username}</TableCell>
				{possibleAccess.map(a => {
					const hasAccess = accessList.some(acc => String(acc.userId) === uidStr && acc.accessKey === a);
					return (
						<TableCell key={a}>
							<Switch
								checked={hasAccess}
								onChange={e => handleToggleAccess(uidStr, a, e.target.checked)}
								color="primary"
								disabled={loading}
							/>
							{hasAccess && (
								<IconButton size="small" onClick={() => handleRemoveAccess(uidStr, a)} disabled={loading} title={`Remove access to ${a}`}>
									<DeleteIcon fontSize="small" />
								</IconButton>
							)}
						</TableCell>
					);
				})}
			</TableRow>
		);
	};

		try {
			return (
				<TableContainer component={Paper} sx={{ mb: 4, maxHeight: 600 }}>
					<Table stickyHeader>
						<TableHead>
							<TableRow>
								<TableCell>User</TableCell>
								{possibleAccess.map(a => <TableCell key={a}>{a}</TableCell>)}
							</TableRow>
						</TableHead>
						<TableBody>
							<List
								height={Math.min(600, users.length * ROW_HEIGHT)}
								itemCount={users.length}
								itemSize={ROW_HEIGHT}
								width={1200}
								itemData={itemData}
							>
								{Row}
							</List>
						</TableBody>
					</Table>
				</TableContainer>
			);
		} catch (err) {
			// Log the error and itemData for debugging
			// eslint-disable-next-line no-console
			console.error('VirtualizedUserTable error:', err, { users, accessList, possibleAccess, itemData });
			return <div style={{ color: 'red' }}>Error rendering user table: {String(err)}</div>;
		}
}

export default VirtualizedUserTable;
