import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';

const CourseSidebar = ({ active, onSelectMenu, role, selectedMenu }) => {
  const [courseOpen, setCourseOpen] = useState(false);
  const [adminOpen, setAdminOpen] = useState(false);
  return (
    <>
      <div style={{marginBottom:'24px'}}>
        <div
          style={{
            cursor:'pointer', fontWeight:'bold', padding:'12px 18px', background:active?'#e3f2fd':'none', borderRadius:'8px', color:'#1976d2',
            transition:'background 0.2s'
          }}
          onClick={() => setCourseOpen(!courseOpen)}
        >
          Course Management{courseOpen ? '▲' : '▼'}
        </div>
        {courseOpen && (
          <div style={{marginLeft:'12px', marginTop:'8px'}}>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#333'}} onClick={()=>onSelectMenu('editCourse')}>Edit Course</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#333'}} onClick={()=>onSelectMenu('addCourseContent')}>Add Course Content</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#333'}} onClick={()=>onSelectMenu('addTeacher')}>Add Teacher</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#333'}} onClick={()=>onSelectMenu('assignCourse')}>Assign Course</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#333'}} onClick={()=>onSelectMenu('manageMedia')}>Manage Media</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#1565c0', fontWeight:'bold'}} onClick={()=>onSelectMenu('manageTutorial')}>Manage Tutorials</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#1565c0', fontWeight:'bold'}} onClick={()=>onSelectMenu('manageInsight')}>Manage Insight</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#1976d2', fontWeight:'bold'}} onClick={()=>onSelectMenu('quizManagement')}>Quiz Management</div>
            <div style={{margin:'18px 0', fontWeight:'bold', color:'#1976d2', padding:'8px 18px', cursor:'pointer', background:selectedMenu==='medicalDocumentGlossary'?'#e3f2fd':'none', borderRadius:'8px'}} onClick={()=>onSelectMenu('medicalDocumentGlossary')}>Medical Document Glossary</div>
          </div>
        )}
      </div>
      <div style={{marginBottom:'24px'}}>
        <div
          style={{
            cursor:'pointer', fontWeight:'bold', padding:'12px 18px', background:active?'#e3f2fd':'none', borderRadius:'8px', color:'#1976d2',
            transition:'background 0.2s'
          }}
          onClick={() => setAdminOpen(!adminOpen)}
        >
          Admin Management{adminOpen ? '▲' : '▼'}
        </div>
        {adminOpen && (
          <div style={{marginLeft:'12px', marginTop:'8px'}}>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#333'}} onClick={()=>onSelectMenu('announcements')}>Announcement</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#1976d2', fontWeight:'bold'}} onClick={()=>onSelectMenu('manageCertificate')}>Manage Certificates</div>
            <div style={{cursor:'pointer', padding:'8px 0', color:'#333'}} onClick={()=>onSelectMenu('invoicing')}>Invoicing</div>
            {role === 'administrator' && (
              <div style={{margin:'0', fontWeight:'bold', color:'#1976d2', padding:'20px 18px 8px 18px', cursor:'pointer', background:selectedMenu==='websiteTraffic'?'#e3f2fd':'none', borderRadius:'8px', fontSize:'1.15rem', textAlign:'left'}} onClick={()=>onSelectMenu('websiteTraffic')}>Website Traffic</div>
            )}
          </div>
        )}
      </div>
    </>
  );
};

export default CourseSidebar;
