import React from 'react';

// chapters: array of chapter objects [{id, name, completed: boolean}]
// currentChapter: id of the currently viewed chapter
// onSelect: function to handle chapter click

function ChapterNavigation({ chapters, currentChapter, onSelect }) {
  return (
    <div style={{ display: 'flex', gap: '16px' }}>
      {chapters.map((chapter, idx) => {
        // Determine if this chapter should be enabled
        const isCompleted = chapter.completed;
        const isCurrent = chapter.id === currentChapter;
        const isNext = idx === 0 || chapters[idx - 1].completed;
        const isEnabled = isCompleted || isCurrent || isNext;

        return (
          <button
            key={chapter.id}
            onClick={() => isEnabled && onSelect(chapter.id)}
            style={{
              padding: '12px 24px',
              borderRadius: '50%',
              background: isCurrent ? '#1976d2' : isCompleted ? '#43cea2' : '#e0e0e0',
              color: isCurrent || isCompleted ? '#fff' : '#888',
              border: 'none',
              cursor: isEnabled ? 'pointer' : 'not-allowed',
              opacity: isEnabled ? 1 : 0.5,
              fontWeight: 'bold',
              fontSize: '18px',
            }}
            disabled={!isEnabled}
          >
            {chapter.name}
          </button>
        );
      })}
    </div>
  );
}

export default ChapterNavigation;
