import React, { useState, useRef, useEffect } from 'react';
import DashboardSidebar from './Administrator/DashboardSidebar';
import InterpreterChart from './Administrator/InterpreterChart';

const cardStyle = {
  padding: '24px',
  marginBottom: '24px',
  background: '#fff',
  borderRadius: '16px',
  boxShadow: '0 2px 12px rgba(0,0,0,0.08)',
};

const rightSidebarStyle = {
  width: '320px',
  maxWidth: '90vw',
  minWidth: '220px',
  background: 'linear-gradient(135deg, #eaf6ff 80%, #fff 100%)',
  boxShadow: '0 4px 24px rgba(0,0,0,0.10)',
  borderRadius: '24px 0 0 24px',
  padding: '32px 18px',
  position: 'fixed',
  top: '32px',
  right: '12px',
  height: 'calc(100vh - 64px)',
  overflowY: 'auto',
  display: 'flex',
  flexDirection: 'column',
  alignItems: 'flex-start',
  border: 'none',
};

const AdminLayout = ({ children, selectedMenu, setSelectedMenu }) => {
  const [role] = useState('administrator');
  const [darkMode, setDarkMode] = useState(false);
  const [accentColor, setAccentColor] = useState('#1565c0');
  const [compactMode, setCompactMode] = useState(false);
  const [profileOpen, setProfileOpen] = useState(false);
  const [notifOpen, setNotifOpen] = useState(false);
  const [notifSettingsOpen, setNotifSettingsOpen] = useState(false);
  const [searchFocus, setSearchFocus] = useState(false);
  const [notifCount] = useState(3);
  const [language, setLanguage] = useState('EN');
  const [avatar, setAvatar] = useState('https://via.placeholder.com/36x36.png?text=Mi');
  const [helpOpen, setHelpOpen] = useState(false);
  const profileRef = useRef();
  const notifRef = useRef();

  useEffect(() => {
    function handleClick(e) {
      if (profileRef.current && !profileRef.current.contains(e.target)) setProfileOpen(false);
      if (notifRef.current && !notifRef.current.contains(e.target)) setNotifOpen(false);
    }
    document.addEventListener('mousedown', handleClick);
    return () => document.removeEventListener('mousedown', handleClick);
  }, []);

  const themeStyles = darkMode ? {
    background: '#181c24', color: '#fff', transition: 'background 0.2s', minHeight: '100vh'
  } : {
    background: '#f7f8fa', color: '#222', minHeight: '100vh', transition: 'background 0.2s'
  };
  themeStyles['--accent'] = accentColor;

  const topBarStyle = {
    width:'100vw', height:'64px', background: darkMode ? '#23283a' : '#fff', boxShadow:'0 2px 8px rgba(0,0,0,0.04)', display:'flex', alignItems:'center', justifyContent:'space-between', padding:'0 32px', position:'fixed', top:0, left:0, zIndex:100
  };
  if (compactMode) topBarStyle.height = '48px';

  const searchInputStyle = {
    width: searchFocus ? '340px' : '180px',
    padding:'8px 16px', borderRadius:'8px', border:'1px solid #e0e0e0', fontSize:'1rem', marginRight:'16px', transition:'width 0.3s', outline: searchFocus ? '2px solid #1565c0' : 'none'
  };

  const responsiveContainerStyle = {
    display: 'flex',
    minHeight: '100vh',
    paddingLeft: '280px',
    paddingRight: '340px',
  };

  return (
    <div style={{...responsiveContainerStyle, ...themeStyles}}>
      {/* Top Bar */}
      <div style={topBarStyle}>
        <div style={{flex:1, display:'flex', alignItems:'center'}}>
          <input type="text" placeholder="Search users, courses, notifications..." style={searchInputStyle} onFocus={()=>setSearchFocus(true)} onBlur={()=>setSearchFocus(false)} />
          <button style={{background:'none', border:'none', cursor:'pointer'}}>
            <svg width="22" height="22" fill="none" viewBox="0 0 24 24"><circle cx="11" cy="11" r="8" stroke={accentColor} strokeWidth="2"/><path d="M21 21l-4.35-4.35" stroke={accentColor} strokeWidth="2" strokeLinecap="round"/></svg>
          </button>
          <button style={{marginLeft:'16px', background:accentColor, color:'#fff', border:'none', borderRadius:'8px', padding:'6px 16px', cursor:'pointer', fontWeight:'bold'}}>+ Add Course</button>
          <button style={{marginLeft:'8px', background:'#27ae60', color:'#fff', border:'none', borderRadius:'8px', padding:'6px 16px', cursor:'pointer', fontWeight:'bold'}}>+ Invite User</button>
          <select value={language} onChange={e=>setLanguage(e.target.value)} style={{marginLeft:'16px', borderRadius:'8px', padding:'6px', border:'1px solid #e0e0e0', fontWeight:'bold', color:accentColor}}>
            <option value="EN">EN</option>
            <option value="FR">FR</option>
            <option value="ES">ES</option>
          </select>
          <button style={{marginLeft:'8px', background:'none', border:'none', cursor:'pointer'}} onClick={()=>setHelpOpen(true)} title="Help">
            <svg width="22" height="22" fill="none" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" stroke={accentColor} strokeWidth="2"/><text x="8" y="16" fontSize="12" fill={accentColor}>?</text></svg>
          </button>
        </div>
        <div style={{display:'flex', alignItems:'center', gap:'24px'}}>
          <button style={{background:'none', border:'none', cursor:'pointer'}} onClick={()=>setDarkMode(!darkMode)} title="Toggle theme">
            {darkMode ? (
              <svg width="24" height="24" fill="none" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" stroke="#fff" strokeWidth="2"/><path d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" fill="#fff"/></svg>
            ) : (
              <svg width="24" height="24" fill="none" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" stroke={accentColor} strokeWidth="2"/><path d="M12 7v5l4 2" stroke={accentColor} strokeWidth="2" strokeLinecap="round"/></svg>
            )}
          </button>
          <input type="color" value={accentColor} onChange={e=>setAccentColor(e.target.value)} style={{marginLeft:'8px', width:'32px', height:'32px', border:'none', background:'none', cursor:'pointer'}} title="Accent Color" />
          <button style={{background:'none', border:'none', cursor:'pointer'}} onClick={()=>setCompactMode(!compactMode)} title="Compact Mode">
            <svg width="24" height="24" fill="none" viewBox="0 0 24 24"><rect x="4" y="8" width="16" height="8" rx="2" stroke={accentColor} strokeWidth="2"/></svg>
          </button>
          <div style={{position:'relative'}} ref={notifRef}>
            <button style={{background:'none', border:'none', cursor:'pointer'}} onClick={()=>setNotifOpen(!notifOpen)}>
              <svg width="24" height="24" fill="none" viewBox="0 0 24 24"><path d="M12 22c1.1 0 2-.9 2-2h-4a2 2 0 002 2zm6-6V11c0-3.07-1.63-5.64-4.5-6.32V4a1.5 1.5 0 00-3 0v.68C7.63 5.36 6 7.92 6 11v5l-1.7 1.7a1 1 0 00.7 1.7h14a1 1 0 00.7-1.7L18 16z" stroke={darkMode ? '#fff' : accentColor} strokeWidth="2"/></svg>
              {notifCount > 0 && <span style={{position:'absolute', top:'-4px', right:'-4px', background:'#f75c7a', color:'#fff', borderRadius:'50%', fontSize:'0.8rem', padding:'2px 6px', fontWeight:'bold'}}>{notifCount}</span>}
            </button>
            {notifOpen && (
              <div style={{position:'absolute', top:'40px', right:0, background:darkMode ? '#23283a' : '#fff', boxShadow:'0 2px 8px rgba(0,0,0,0.12)', borderRadius:'12px', minWidth:'260px', zIndex:200, padding:'12px', transition:'all 0.2s'}}>
                <div style={{fontWeight:'bold', marginBottom:'8px'}}>Notifications</div>
                <div style={{marginBottom:'8px', color:'#27ae60'}}>You just Login <span style={{color:'#555', fontSize:'0.9rem'}}>1 second ago</span></div>
                <div style={{marginBottom:'8px', color:'#f75c7a'}}>System has been log you out <span style={{color:'#555', fontSize:'0.9rem'}}>1 day ago</span></div>
                <div style={{marginBottom:'8px', color:'#27ae60'}}>You just Login <span style={{color:'#555', fontSize:'0.9rem'}}>1 day ago</span></div>
                <button style={{marginTop:'8px', background:accentColor, color:'#fff', border:'none', borderRadius:'8px', padding:'6px 12px', cursor:'pointer', fontWeight:'bold'}}>View All</button>
                <button style={{marginTop:'8px', background:'none', color:accentColor, border:'none', borderRadius:'8px', padding:'6px 12px', cursor:'pointer', fontWeight:'bold'}} onClick={()=>setNotifSettingsOpen(!notifSettingsOpen)}>Settings</button>
                {notifSettingsOpen && (
                  <div style={{marginTop:'8px', background:darkMode ? '#23283a' : '#f7f8fa', borderRadius:'8px', padding:'8px', boxShadow:'0 2px 8px rgba(0,0,0,0.08)'}}>
                    <div style={{fontWeight:'bold', marginBottom:'4px'}}>Notification Settings</div>
                    <label style={{display:'block', marginBottom:'4px'}}><input type="checkbox" defaultChecked /> Login Alerts</label>
                    <label style={{display:'block', marginBottom:'4px'}}><input type="checkbox" defaultChecked /> System Alerts</label>
                    <label style={{display:'block', marginBottom:'4px'}}><input type="checkbox" /> Promotions</label>
                  </div>
                )}
              </div>
            )}
          </div>
          <button style={{background:'none', border:'none', cursor:'pointer'}}>
            <svg width="24" height="24" fill="none" viewBox="0 0 24 24"><rect x="4" y="8" width="16" height="10" rx="2" stroke={darkMode ? '#fff' : '#1565c0'} strokeWidth="2"/><path d="M4 8V6a2 2 0 012-2h12a2 2 0 012 2v2" stroke={darkMode ? '#fff' : '#1565c0'} strokeWidth="2"/></svg>
          </button>
          <div style={{position:'relative'}} ref={profileRef}>
            <div style={{display:'flex', alignItems:'center', gap:'8px', cursor:'pointer'}} onClick={()=>setProfileOpen(!profileOpen)}>
              <img src={avatar} alt="Profile" style={{borderRadius:'50%', border:`2px solid ${accentColor}`}} />
              <span style={{fontWeight:'bold', color:accentColor}}>Administrator</span>
              <span style={{width:'10px', height:'10px', background:'#27ae60', borderRadius:'50%', display:'inline-block', marginLeft:'4px'}}></span>
              <svg width="16" height="16" fill="none" viewBox="0 0 24 24"><path d="M7 10l5 5 5-5" stroke={accentColor} strokeWidth="2"/></svg>
            </div>
            {profileOpen && (
              <div style={{position:'absolute', top:'44px', right:0, background:darkMode ? '#23283a' : '#fff', boxShadow:'0 2px 8px rgba(0,0,0,0.12)', borderRadius:'12px', minWidth:'180px', zIndex:200, padding:'12px', transition:'all 0.2s'}}>
                <div style={{fontWeight:'bold', marginBottom:'8px'}}>Profile</div>
                <div style={{marginBottom:'8px', cursor:'pointer'}}>Settings</div>
                <div style={{marginBottom:'8px', cursor:'pointer'}}>My Account</div>
                <div style={{marginBottom:'8px', cursor:'pointer', color:'#f75c7a'}}>Logout</div>
                <div style={{marginBottom:'8px'}}>
                  <label style={{fontWeight:'normal'}}>Change Avatar:</label>
                  <input type="file" accept="image/*" onChange={e=>{
                    const file = e.target.files[0];
                    if (file) {
                      const reader = new FileReader();
                      reader.onload = ev => setAvatar(ev.target.result);
                      reader.readAsDataURL(file);
                    }
                  }} style={{marginTop:'4px'}} />
                </div>
              </div>
            )}
          </div>
      {helpOpen && (
        <div style={{position:'fixed', top:0, left:0, width:'100vw', height:'100vh', background:'rgba(0,0,0,0.2)', zIndex:999, display:'flex', alignItems:'center', justifyContent:'center'}} onClick={()=>setHelpOpen(false)}>
          <div style={{background:darkMode ? '#23283a' : '#fff', color:darkMode ? '#fff' : '#222', borderRadius:'16px', padding:'32px', minWidth:'320px', boxShadow:'0 2px 12px rgba(0,0,0,0.12)'}} onClick={e=>e.stopPropagation()}>
            <h2 style={{marginBottom:'16px'}}>Help & Support</h2>
            <p>Welcome to the dashboard! Here you can manage users, courses, notifications, and more.<br/>For documentation or support, visit <a href="#" style={{color:accentColor}}>our help center</a>.</p>
            <button style={{marginTop:'16px', background:accentColor, color:'#fff', border:'none', borderRadius:'8px', padding:'6px 16px', cursor:'pointer', fontWeight:'bold'}} onClick={()=>setHelpOpen(false)}>Close</button>
          </div>
        </div>
      )}
        </div>
      </div>

      {/* Left Sidebar */}
      <div style={{marginTop:'64px'}}>
        <DashboardSidebar role={role} onSelectMenu={setSelectedMenu} selectedMenu={selectedMenu} />
      </div>

      {/* Main Content */}
      <main style={{marginTop:'64px', padding:'32px', flex:1}}>
        {children}
      </main>

      {/* Right Sidebar: Recent Activities */}
      <aside style={{...rightSidebarStyle, marginTop:'64px'}}>
        <h3 style={{marginBottom:'18px', fontWeight:'bold', color:'#222', fontSize:'1.15rem'}}>Recent Activities</h3>
        <ul style={{listStyle:'none', padding:0, margin:0, width:'100%'}}>
          <li style={{marginBottom:'16px', color:'#27ae60', fontWeight:'500', fontSize:'1rem'}}>
            You just Login <span style={{color:'#555', fontSize:'0.92rem', marginLeft:'6px'}}>1 second ago</span>
          </li>
          <li style={{marginBottom:'16px', color:'#f75c7a', fontWeight:'500', fontSize:'1rem'}}>
            System has been log you out <span style={{color:'#555', fontSize:'0.92rem', marginLeft:'6px'}}>1 day ago</span>
          </li>
          <li style={{marginBottom:'16px', color:'#27ae60', fontWeight:'500', fontSize:'1rem'}}>
            You just Login <span style={{color:'#555', fontSize:'0.92rem', marginLeft:'6px'}}>1 day ago</span>
          </li>
        </ul>
      </aside>
    </div>
  );
};

export default AdminLayout;
