import { useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import axios from 'axios';
import { BASE_API } from '../../utils/config';

// Helper to get user info from localStorage
function getUserInfo() {
  return {
    userId: localStorage.getItem('userId'),
    idUser: localStorage.getItem('id_user'),
    email: localStorage.getItem('email'),
    role: localStorage.getItem('role'),
  };
}

export default function Logout() {
  const navigate = useNavigate();

  useEffect(() => {
    const { userId, idUser, email, role } = getUserInfo();
    // Call backend to set enligne=0 and log the action
    if (userId) {
      axios.post(`${BASE_API}/api/logout`, {
        user_id: userId,
        id_user: idUser,
        email,
        role,
      }).catch(() => {}); // Ignore errors for now
    }
    // Clear local/session storage
    localStorage.clear();
    sessionStorage.clear();
    // Redirect to login page after short delay
    setTimeout(() => navigate('/login', { replace: true }), 500);
  }, [navigate]);

  return null;
}
