import React from 'react';
import AutomaticLogout from './Company/AutomaticLogout';
import { BrowserRouter, Routes, Route, Navigate } from 'react-router-dom';
import HomePage from './HomePage';
import About from './professional/About';
import ProfessionalIndex from './professional/ProfessionalIndex';
import ClassicalIndex from './classical/ClassicalIndex';
import Login from './Login';
import Register from './Register';
import Index10000 from './Company/10000/Index';
import AdminIndex from './Company/Administrator/Index';
import SignDocument from './Company/Document_signature/SignDocument';
import CertificateVerify from './verify/CertificateVerify';
import { useParams } from 'react-router-dom';
import LegalCertificatePrintView from './Company/Administrator/LegalCertificatePrintView';
import MedicalCertificatePrintView from './Company/Administrator/MedicalCertificatePrintView';
import HipaaCertificatePrintView from './Company/Administrator/HipaaCertificatePrintView';
import ValidCertification from './verify/valid_certification';
import Footer from './professional/Footer';
import './professional/Footer.css';

function App() {
  return (
    <BrowserRouter>
      <AutomaticLogout>
        {/* Main content */}
        <div style={{ minHeight: '90vh', display: 'flex', flexDirection: 'column' }}>
          <div style={{ flex: 1 }}>
            <Routes>
              <Route path="/" element={<HomePage />} />
              <Route path="/professional" element={<ProfessionalIndex />} />
              <Route path="/about" element={<About />} />
              <Route path="/Professional/about" element={<About />} />
              <Route path="/Professional/courses" element={require('./professional/Courses').default ? React.createElement(require('./professional/Courses').default) : null} />
              <Route path="/Professional/teachers" element={require('./professional/Teachers').default ? React.createElement(require('./professional/Teachers').default) : null} />
              <Route path="/Professional/portfolio" element={require('./professional/Portfolio').default ? React.createElement(require('./professional/Portfolio').default) : null} />
              <Route path="/Professional/contact" element={require('./professional/Contact').default ? React.createElement(require('./professional/Contact').default) : null} />
              <Route path="/classical" element={<ClassicalIndex />} />
              <Route path="/login" element={<Login />} />
              <Route path="/register" element={<Register />} />
              <Route path="/Company/10000/index" element={<Index10000 />} />
              <Route path="/Company/Administrator/index" element={<AdminIndex />} />
              <Route path="/sign/:docId/:token" element={<SignDocumentRoute />} />
              <Route path="/verify" element={<CertificateVerify />} />
              <Route path="/verify/valid_certification" element={<ValidCertification />} />
              <Route path="/Company/Administrator/certificate-print" element={<LegalCertificatePrintView />} />
              <Route path="/Company/Administrator/MedicalCertificatePrintView" element={<MedicalCertificatePrintView />} />
              <Route path="/Company/Administrator/LegalCertificatePrintView" element={<LegalCertificatePrintView />} />
              <Route path="/Company/Administrator/HipaaCertificatePrintView" element={<HipaaCertificatePrintView />} />
              {/* Add logout route */}
              <Route path="/logout" element={require('./Company/10000/Logout.js').default ? React.createElement(require('./Company/10000/Logout.js').default) : null} />
            </Routes>
          </div>
          <Footer />
        </div>
      </AutomaticLogout>
    </BrowserRouter>
  );
}


function SignDocumentRoute() {
  const { docId, token } = useParams();
  return <SignDocument docId={docId} token={token} />;
}

export default App;
