// Visitor Tracking Script
function recordVisit(additionalData = {}) {
    // Get basic visit information
    const visitData = {
        site_url: window.location.href,
        page_title: document.title,
        ...additionalData
    };

    // Get API URL from environment config
    const apiUrl = window.config?.apiUrl || 'http://localhost:5000';
    
    // Send visit data to backend
    fetch(`${apiUrl}/api/record-visit`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(visitData),
        credentials: 'include'
    })
    .then(response => response.json())
    .then(data => {
        console.log('Visit recorded:', data);
    })
    .catch(error => {
        console.error('Error recording visit:', error);
    });
}

// Record visit when page loads
document.addEventListener('DOMContentLoaded', function() {
    recordVisit();
});

// Export the function to use it manually
window.recordVisit = recordVisit;
