-- Migration: Add certificate table for backend verification
CREATE TABLE certificate (
    id SERIAL PRIMARY KEY,
    user_id INTEGER NOT NULL REFERENCES users(id_user),
    certificate_type VARCHAR(50) NOT NULL,
    qr_code_filename VARCHAR(255),
    html_filename VARCHAR(255),
    pdf_filename VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
-- Add indexes if needed
CREATE INDEX idx_certificate_user_id ON certificate(user_id);
CREATE INDEX idx_certificate_type ON certificate(certificate_type);

-- Add course outline fields (Field 1 to Field 11)
ALTER TABLE certificate ADD COLUMN field_1 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_2 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_3 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_4 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_5 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_6 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_7 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_8 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_9 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_10 BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN field_11 BOOLEAN DEFAULT FALSE;

-- Add additional fields for certificate metadata
ALTER TABLE certificate ADD COLUMN certificate_medical_interpreter BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN certificate_hipaa_compliance BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN certificate_legal_interpreter BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN date_validity TIMESTAMP;
ALTER TABLE certificate ADD COLUMN certificate_text TEXT;
ALTER TABLE certificate ADD COLUMN is_active BOOLEAN DEFAULT FALSE;
ALTER TABLE certificate ADD COLUMN language_from VARCHAR(100);
ALTER TABLE certificate ADD COLUMN language_to VARCHAR(100);