-- Table: action_logs

CREATE TABLE IF NOT EXISTS action_logs (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    actor_id INTEGER NOT NULL,
    actor_role TEXT NOT NULL,
    actor_email TEXT NOT NULL,
    action_type TEXT NOT NULL,
    action_description TEXT,
    target_id INTEGER,
    target_role TEXT,
    target_email TEXT,
    page TEXT NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Index for fast lookup by actor or target
CREATE INDEX IF NOT EXISTS idx_action_logs_actor_id ON action_logs(actor_id);
CREATE INDEX IF NOT EXISTS idx_action_logs_target_id ON action_logs(target_id);
CREATE INDEX IF NOT EXISTS idx_action_logs_created_at ON action_logs(created_at);
