# Read the file
with open('app.py', 'r', encoding='utf-8') as f:
    content = f.read()

# Check if blog endpoint already exists
if '@app.route(\'/api/blog\'' in content:
    print("Blog endpoint already exists")
else:
    # Add the blog endpoint before the if __name__ == '__main__':
    blog_endpoint = '''
# Blog endpoint
@app.route('/api/blog', methods=['GET'])
def get_blogs():
    try:
        db = get_db()
        cursor = db.cursor()
        # Get all blogs where status_MI = '1'
        cursor.execute("SELECT * FROM blog WHERE field1 != 'id' AND field7 = '1' ORDER BY field10 DESC")
        rows = cursor.fetchall()
        
        blogs = []
        for row in rows:
            blog = dict(row)
            blogs.append(blog)
        
        # If we need to rename fields to match the header
        if blogs:
            # Map field1-field11 to proper names based on first row
            cursor.execute("SELECT * FROM blog LIMIT 1")
            first_row = cursor.fetchone()
            if first_row:
                headers = dict(first_row)
                field_names = list(headers.keys())
                
                # Map the fields
                for blog in blogs:
                    blog['id'] = blog.get('field1', '')
                    blog['image_cover'] = blog.get('field2', '')
                    blog['title'] = blog.get('field3', '')
                    blog['description'] = blog.get('field4', '')
                    blog['category'] = blog.get('field5', '')
                    blog['tags'] = blog.get('field6', '')
                    blog['status_MI'] = blog.get('field7', '')
                    blog['status_SC'] = blog.get('field8', '')
                    blog['created_by'] = blog.get('field9', '')
                    blog['last_updated'] = blog.get('field10', '')
                    blog['date_created'] = blog.get('field11', '')
        
        return jsonify(blogs), 200
    except Exception as e:
        print(f"Error in get_blogs: {str(e)}")
        return jsonify({'error': str(e)}), 500

'''
    
    # Find the insertion point
    insertion_point = content.rfind("if __name__ == '__main__':")
    if insertion_point != -1:
        # Insert the endpoint
        new_content = content[:insertion_point] + blog_endpoint + "\n" + content[insertion_point:]
        
        # Write back
        with open('app.py', 'w', encoding='utf-8') as f:
            f.write(new_content)
        print("Blog endpoint added successfully")
    else:
        print("Could not find insertion point")
